/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.util.Messages;
import org.apache.openejb.util.OpenEJBErrorHandler;

public class SafeToolkit {
    public static final Messages messages = new Messages("org.apache.openejb.util.resources");
    public static final HashMap codebases = new HashMap();
    private String systemLocation;

    public static SafeToolkit getToolkit(String systemLocation) {
        return new SafeToolkit(systemLocation);
    }

    private SafeToolkit(String systemLocation) {
        this.systemLocation = systemLocation;
    }

    private Class forName(String className) throws OpenEJBException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            OpenEJBErrorHandler.classNotFound(this.systemLocation, className);
        }
        return clazz;
    }

    public Object newInstance(String className) throws OpenEJBException {
        return this.newInstance(this.forName(className));
    }

    public Object newInstance(Class clazz) throws OpenEJBException {
        Object instance = null;
        try {
            instance = clazz.newInstance();
        }
        catch (InstantiationException ie) {
            OpenEJBErrorHandler.classNotIntantiateable(this.systemLocation, clazz.getName());
        }
        catch (IllegalAccessException iae) {
            OpenEJBErrorHandler.classNotAccessible(this.systemLocation, clazz.getName());
        }
        catch (Throwable exception) {
            exception.printStackTrace();
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                OpenEJBErrorHandler.classNotIntantiateableFromCodebaseForUnknownReason(this.systemLocation, clazz.getName(), SafeToolkit.getCodebase((URLClassLoader)classLoader), exception.getClass().getName(), exception.getMessage());
            }
            OpenEJBErrorHandler.classNotIntantiateableForUnknownReason(this.systemLocation, clazz.getName(), exception.getClass().getName(), exception.getMessage());
        }
        return instance;
    }

    private static String getCodebase(URLClassLoader urlClassLoader) {
        StringBuffer codebase = new StringBuffer();
        URL[] urlList = urlClassLoader.getURLs();
        codebase.append(urlList[0].toString());
        for (int i = 1; i < urlList.length; ++i) {
            codebase.append(';');
            codebase.append(urlList[i].toString());
        }
        return codebase.toString();
    }
}

