/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.completers;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.virgo.kernel.model.management.RuntimeArtifactModelObjectNameCreator;
import org.eclipse.virgo.shell.CommandCompleter;

class AbstractInstallArtifactCompleter
implements CommandCompleter {
    private static final String SUBCOMMAND_LIST = "list";
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final String type;
    private final RuntimeArtifactModelObjectNameCreator objectNameCreator;

    public AbstractInstallArtifactCompleter(String type, RuntimeArtifactModelObjectNameCreator objectNameCreator) {
        this.type = type;
        this.objectNameCreator = objectNameCreator;
    }

    @Override
    public final List<String> getCompletionCandidates(String subcommand, String ... tokens) {
        Set<String> candidates = SUBCOMMAND_LIST.equals(subcommand) ? Collections.emptySet() : (tokens.length == 2 ? this.versions(tokens[0], tokens[1]) : (tokens.length == 1 ? this.names(tokens[0]) : Collections.emptySet()));
        this.filter(candidates, subcommand, tokens);
        ArrayList<String> candidateList = new ArrayList<String>(candidates);
        Collections.sort(candidateList);
        return candidateList;
    }

    protected void filter(Set<String> candidates, String subcommand, String ... tokens) {
    }

    private Set<String> versions(String name, String version) {
        HashSet<String> candidates = new HashSet<String>();
        Set<ObjectName> objectNames = this.server.queryNames(this.objectNameCreator.createArtifactVersionsQuery(this.type, name), null);
        for (ObjectName objectName : objectNames) {
            String candidateVersion = this.objectNameCreator.getVersion(objectName);
            if (!candidateVersion.startsWith(version)) continue;
            candidates.add(candidateVersion);
        }
        return candidates;
    }

    private Set<String> names(String name) {
        HashSet<String> candidates = new HashSet<String>();
        Set<ObjectName> objectNames = this.server.queryNames(this.objectNameCreator.createArtifactsOfTypeQuery(this.type), null);
        for (ObjectName objectName : objectNames) {
            String candidateName = this.objectNameCreator.getName(objectName);
            if (!candidateName.startsWith(name)) continue;
            candidates.add(candidateName);
        }
        return candidates;
    }
}

