/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.StateHolderSaver;
import com.sun.faces.context.StateContext;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.ComponentStruct;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.StateManagementStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaceletFullStateManagementStrategy
extends StateManagementStrategy {
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();
    private static String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";
    private Map<String, Class<?>> classMap;
    private boolean isDevelopmentMode;

    public FaceletFullStateManagementStrategy() {
        this(FacesContext.getCurrentInstance());
    }

    public FaceletFullStateManagementStrategy(FacesContext context) {
        this.isDevelopmentMode = context.isProjectStage(ProjectStage.Development);
        this.classMap = new ConcurrentHashMap(32);
    }

    private void captureChild(List<TreeNode> tree, int parent, UIComponent c) {
        if (!c.isTransient() && !c.getAttributes().containsKey("com.sun.faces.DynamicComponent")) {
            TreeNode n = new TreeNode(parent, c);
            int pos = tree.size();
            tree.add(n);
            this.captureRest(tree, pos, c);
        }
    }

    private void captureFacet(List<TreeNode> tree, int parent, String name, UIComponent c) {
        if (!c.isTransient() && !c.getAttributes().containsKey("com.sun.faces.DynamicComponent")) {
            FacetNode n = new FacetNode(parent, name, c);
            int pos = tree.size();
            tree.add(n);
            this.captureRest(tree, pos, c);
        }
    }

    private void captureRest(List<TreeNode> tree, int pos, UIComponent c) {
        int sz = c.getChildCount();
        if (sz > 0) {
            List child = c.getChildren();
            for (int i = 0; i < sz; ++i) {
                this.captureChild(tree, pos, (UIComponent)child.get(i));
            }
        }
        if ((sz = c.getFacetCount()) > 0) {
            for (Map.Entry entry : c.getFacets().entrySet()) {
                this.captureFacet(tree, pos, (String)entry.getKey(), (UIComponent)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UIComponent locateComponentByClientId(FacesContext context, UIComponent subTree, final String clientId) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "FaceletFullStateManagementStrategy.locateComponentByClientId", clientId);
        }
        final ArrayList found = new ArrayList();
        UIComponent result = null;
        try {
            context.getAttributes().put(SKIP_ITERATION_HINT, true);
            EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_ITERATION);
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, null, hints);
            subTree.visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext visitContext, UIComponent component) {
                    VisitResult result = VisitResult.ACCEPT;
                    if (component.getClientId(visitContext.getFacesContext()).equals(clientId)) {
                        found.add(component);
                        result = VisitResult.COMPLETE;
                    } else if (component instanceof UIForm) {
                        UIForm form = (UIForm)component;
                        if (form.isPrependId() && !clientId.startsWith(form.getClientId(visitContext.getFacesContext()))) {
                            result = VisitResult.REJECT;
                        }
                    } else if (component instanceof NamingContainer && !clientId.startsWith(component.getClientId(visitContext.getFacesContext()))) {
                        result = VisitResult.REJECT;
                    }
                    return result;
                }
            });
        }
        finally {
            context.getAttributes().remove(SKIP_ITERATION_HINT);
        }
        if (!found.isEmpty()) {
            result = (UIComponent)found.get(0);
        }
        return result;
    }

    private UIComponent newInstance(TreeNode n) throws FacesException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "FaceletFullStateManagementStrategy.newInstance", n.componentType);
        }
        try {
            Class t;
            Class clazz = t = this.classMap != null ? this.classMap.get(n.componentType) : null;
            if (t == null) {
                t = Util.loadClass(n.componentType, n);
                if (t != null && this.classMap != null) {
                    this.classMap.put(n.componentType, t);
                } else if (!this.isDevelopmentMode) {
                    throw new NullPointerException();
                }
            }
            assert (t != null);
            UIComponent c = (UIComponent)t.newInstance();
            c.setId(n.id);
            return c;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    private void pruneAndReAddToDynamicActions(List<ComponentStruct> dynamicActionList, ComponentStruct struct) {
        int firstIndex;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.pruneAndReAddToDynamicActions");
        }
        if ((firstIndex = dynamicActionList.indexOf(struct)) == -1) {
            dynamicActionList.add(struct);
        } else {
            int lastIndex = dynamicActionList.lastIndexOf(struct);
            if (lastIndex == -1 || lastIndex == firstIndex) {
                dynamicActionList.add(struct);
            } else {
                if ("ADD".equals(struct.action)) {
                    dynamicActionList.remove(lastIndex);
                    dynamicActionList.remove(firstIndex);
                    dynamicActionList.add(struct);
                }
                if ("REMOVE".equals(struct.action)) {
                    dynamicActionList.remove(lastIndex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreComponentState(final FacesContext context, final HashMap<String, Object> state) {
        final StateContext stateContext = StateContext.getStateContext(context);
        UIViewRoot viewRoot = context.getViewRoot();
        try {
            context.getAttributes().put(SKIP_ITERATION_HINT, true);
            EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_ITERATION);
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, null, hints);
            viewRoot.visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext visitContext, UIComponent component) {
                    VisitResult result = VisitResult.ACCEPT;
                    String cid = component.getClientId(context);
                    Object stateObj = state.get(cid);
                    if (stateObj != null && !stateContext.componentAddedDynamically(component)) {
                        boolean restoreStateNow = true;
                        if (stateObj instanceof StateHolderSaver) {
                            boolean bl = restoreStateNow = !((StateHolderSaver)stateObj).componentAddedDynamically();
                        }
                        if (restoreStateNow) {
                            try {
                                component.restoreState(context, stateObj);
                            }
                            catch (Exception e) {
                                throw new FacesException((Throwable)e);
                            }
                        }
                    }
                    return result;
                }
            });
        }
        finally {
            context.getAttributes().remove(SKIP_ITERATION_HINT);
        }
    }

    private void restoreDynamicActions(FacesContext context, StateContext stateContext, HashMap<String, Object> state) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.restoreDynamicActions");
        }
        UIViewRoot viewRoot = context.getViewRoot();
        List savedActions = (List)viewRoot.getAttributes().get("com.sun.faces.DynamicActions");
        List<ComponentStruct> actions = stateContext.getDynamicActions();
        if (savedActions != null && !savedActions.isEmpty()) {
            for (Object object : savedActions) {
                ComponentStruct action = new ComponentStruct();
                action.restoreState(context, object);
                if ("ADD".equals(action.action)) {
                    this.restoreDynamicAdd(context, state, action);
                }
                if ("REMOVE".equals(action.action)) {
                    this.restoreDynamicRemove(context, action);
                }
                this.pruneAndReAddToDynamicActions(actions, action);
            }
        }
    }

    private void restoreDynamicAdd(FacesContext context, Map<String, Object> state, ComponentStruct struct) {
        UIComponent parent;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.restoreDynamicAdd");
        }
        if ((parent = this.locateComponentByClientId(context, (UIComponent)context.getViewRoot(), struct.parentClientId)) != null) {
            StateHolderSaver saver;
            UIComponent child = this.locateComponentByClientId(context, parent, struct.clientId);
            if (child != null) {
                if (struct.facetName == null) {
                    parent.getChildren().remove(child);
                } else {
                    parent.getFacets().remove(struct.facetName);
                }
            }
            if (child == null && (saver = (StateHolderSaver)state.get(struct.clientId)) != null) {
                child = (UIComponent)saver.restore(context);
            }
            StateContext stateContext = StateContext.getStateContext(context);
            if (child == null) {
                child = stateContext.getDynamicComponents().get(struct.clientId);
            }
            if (child != null) {
                if (struct.facetName != null) {
                    parent.getFacets().put(struct.facetName, child);
                } else {
                    int childIndex = -1;
                    if (child.getAttributes().containsKey("com.sun.faces.DynamicComponent")) {
                        childIndex = (Integer)child.getAttributes().get("com.sun.faces.DynamicComponent");
                    }
                    child.setId(struct.id);
                    if (childIndex >= parent.getChildCount() || childIndex == -1) {
                        parent.getChildren().add(child);
                    } else {
                        parent.getChildren().add(childIndex, child);
                    }
                    child.getClientId();
                }
                child.getAttributes().put("com.sun.faces.DynamicComponent", child.getParent().getChildren().indexOf(child));
                stateContext.getDynamicComponents().put(struct.clientId, child);
            }
        }
    }

    private void restoreDynamicRemove(FacesContext context, ComponentStruct struct) {
        UIComponent child;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.restoreDynamicRemove");
        }
        if ((child = this.locateComponentByClientId(context, (UIComponent)context.getViewRoot(), struct.clientId)) != null) {
            StateContext stateContext = StateContext.getStateContext(context);
            stateContext.getDynamicComponents().put(struct.clientId, child);
            UIComponent parent = child.getParent();
            parent.getChildren().remove(child);
        }
    }

    private UIViewRoot restoreTree(FacesContext context, String renderKitId, Object[] tree) throws FacesException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "FaceletFullStateManagementStrategy.restoreTree", renderKitId);
        }
        for (int i = 0; i < tree.length; ++i) {
            UIComponent c;
            if (tree[i] instanceof FacetNode) {
                FacetNode fn = (FacetNode)tree[i];
                c = this.newInstance(fn);
                tree[i] = c;
                if (i == fn.parent) continue;
                ((UIComponent)tree[fn.parent]).getFacets().put(fn.facetName, c);
                continue;
            }
            TreeNode tn = (TreeNode)tree[i];
            c = this.newInstance(tn);
            tree[i] = c;
            if (i != tn.parent) {
                ((UIComponent)tree[tn.parent]).getChildren().add(c);
                continue;
            }
            assert (c instanceof UIViewRoot);
            UIViewRoot viewRoot = (UIViewRoot)c;
            context.setViewRoot(viewRoot);
            viewRoot.setRenderKitId(renderKitId);
        }
        return (UIViewRoot)tree[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "FaceletFullStateManagementStrategy.restoreView", new Object[]{viewId, renderKitId});
        }
        UIViewRoot result = null;
        ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderKitId);
        Object[] state = (Object[])rsm.getState(context, viewId);
        if (state != null && state.length >= 2) {
            if (state[0] != null) {
                result = this.restoreTree(context, renderKitId, (Object[])((Object[])state[0]).clone());
                context.setViewRoot(result);
            }
            if (result != null) {
                StateContext stateContext = StateContext.getStateContext(context);
                stateContext.startTrackViewModifications(context, result);
                stateContext.setTrackViewModifications(false);
                try {
                    HashMap stateMap = (HashMap)state[1];
                    if (stateMap != null) {
                        this.restoreComponentState(context, stateMap);
                        this.restoreDynamicActions(context, stateContext, stateMap);
                    }
                }
                finally {
                    stateContext.setTrackViewModifications(true);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object saveComponentState(FacesContext context) {
        final HashMap stateMap = new HashMap();
        final StateContext stateContext = StateContext.getStateContext(context);
        UIViewRoot viewRoot = context.getViewRoot();
        final FacesContext finalContext = context;
        context.getAttributes().put(SKIP_ITERATION_HINT, true);
        EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_ITERATION);
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, null, hints);
        try {
            viewRoot.visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext context, UIComponent component) {
                    VisitResult result = VisitResult.ACCEPT;
                    if (!component.isTransient()) {
                        Object stateObj;
                        if (stateContext.componentAddedDynamically(component)) {
                            component.getAttributes().put("com.sun.faces.DynamicComponent", new Integer(FaceletFullStateManagementStrategy.this.getProperChildIndex(component)));
                            stateObj = new StateHolderSaver(finalContext, component);
                        } else {
                            stateObj = component.saveState(finalContext);
                        }
                        if (stateObj != null) {
                            stateMap.put(component.getClientId(finalContext), stateObj);
                        }
                    } else {
                        result = VisitResult.REJECT;
                    }
                    return result;
                }
            });
        }
        finally {
            context.getAttributes().remove(SKIP_ITERATION_HINT);
        }
        return stateMap;
    }

    private void saveDynamicActions(FacesContext context, StateContext stateContext, UIViewRoot viewRoot) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.saveDynamicActions");
        }
        List<ComponentStruct> actions = stateContext.getDynamicActions();
        HashMap<String, UIComponent> componentMap = stateContext.getDynamicComponents();
        if (actions != null) {
            ArrayList<Object> savedActions = new ArrayList<Object>(actions.size());
            for (ComponentStruct action : actions) {
                UIComponent component = componentMap.get(action.clientId);
                if (component == null && context.isProjectStage(ProjectStage.Development)) {
                    LOGGER.log(Level.WARNING, "Unable to save dynamic action with clientId ''{0}'' because the UIComponent cannot be found", action.clientId);
                }
                if (component == null || component.isTransient() || this.hasTransientAncestor(component)) continue;
                savedActions.add(action.saveState(context));
            }
            viewRoot.getAttributes().put("com.sun.faces.DynamicActions", savedActions);
        }
    }

    public Object saveView(FacesContext context) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.saveView");
        }
        UIViewRoot viewRoot = context.getViewRoot();
        Util.checkIdUniqueness(context, (UIComponent)viewRoot, new HashSet<String>(viewRoot.getChildCount() << 1));
        StateContext stateContext = StateContext.getStateContext(context);
        this.saveDynamicActions(context, stateContext, viewRoot);
        Object state = this.saveComponentState(context);
        ArrayList<TreeNode> treeList = new ArrayList<TreeNode>(32);
        this.captureChild(treeList, 0, (UIComponent)viewRoot);
        Object[] tree = treeList.toArray();
        Object[] result = new Object[]{tree, state};
        StateContext.release(context);
        return result;
    }

    private int getProperChildIndex(UIComponent component) {
        int result = -1;
        if (component.getParent().getChildren().indexOf(component) != -1) {
            UIComponent child;
            UIComponent parent = component.getParent();
            int index = 0;
            Iterator iterator = parent.getChildren().iterator();
            while (iterator.hasNext() && (child = (UIComponent)iterator.next()) != component) {
                if (child.isTransient()) continue;
                ++index;
            }
            result = index;
        }
        return result;
    }

    private boolean hasTransientAncestor(UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.isTransient()) continue;
            return true;
        }
        return false;
    }

    private static final class FacetNode
    extends TreeNode {
        private static final long serialVersionUID = -3777170310958005106L;
        public String facetName;

        public FacetNode() {
        }

        public FacetNode(int parent, String name, UIComponent c) {
            super(parent, c);
            this.facetName = name;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.facetName = in.readUTF();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeUTF(this.facetName);
        }
    }

    private static class TreeNode
    implements Externalizable {
        private static final long serialVersionUID = -835775352718473281L;
        private static final String NULL_ID = "";
        public String componentType;
        public String id;
        public int parent;

        public TreeNode() {
        }

        public TreeNode(int parent, UIComponent c) {
            this.parent = parent;
            this.id = c.getId();
            this.componentType = c.getClass().getName();
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.parent = in.readInt();
            this.componentType = in.readUTF();
            this.id = in.readUTF();
            if (this.id.length() == 0) {
                this.id = null;
            }
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.parent);
            out.writeUTF(this.componentType);
            if (this.id != null) {
                out.writeUTF(this.id);
            } else {
                out.writeUTF(NULL_ID);
            }
        }
    }
}

