/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.IToolTipAdapter;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.MarkupValidator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolTip
extends Widget {
    private final Shell parent;
    private boolean autoHide;
    private boolean visible;
    private String text;
    private String message;
    private int x;
    private int y;
    private transient IToolTipAdapter toolTipAdapter;

    public ToolTip(Shell parent, int style) {
        super(parent, ToolTip.checkStyle(style));
        this.parent = parent;
        this.autoHide = true;
        this.text = "";
        this.message = "";
        Point cursorLocation = this.display.getCursorLocation();
        this.x = cursorLocation.x;
        this.y = cursorLocation.y;
        this.parent.createToolTip(this);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result;
        if (adapter == IToolTipAdapter.class) {
            if (this.toolTipAdapter == null) {
                this.toolTipAdapter = new IToolTipAdapter(){

                    public Point getLocation() {
                        return new Point(ToolTip.this.x, ToolTip.this.y);
                    }
                };
            }
            result = this.toolTipAdapter;
        } else {
            result = super.getAdapter(adapter);
        }
        return result;
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autoHide;
    }

    public void setAutoHide(boolean autoHide) {
        this.checkWidget();
        this.autoHide = autoHide;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.visible;
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        this.visible = visible;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            this.error(4);
        }
        if (MarkupUtil.isMarkupEnabledFor(this) && !MarkupValidator.isValidationDisabledFor(this)) {
            MarkupValidator.getInstance().validate(text);
        }
        this.text = text;
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    public void setMessage(String message) {
        this.checkWidget();
        if (message == null) {
            this.error(4);
        }
        if (MarkupUtil.isMarkupEnabledFor(this) && !MarkupValidator.isValidationDisabledFor(this)) {
            MarkupValidator.getInstance().validate(message);
        }
        this.message = message;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.x = x;
        this.y = y;
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            SWT.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    @Override
    public void setData(String key, Object value) {
        if (!"org.eclipse.rap.rwt.markupEnabled".equals(key) || !MarkupUtil.isMarkupEnabledFor(this)) {
            super.setData(key, value);
        }
    }

    @Override
    String getNameText() {
        return this.text;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        this.parent.destroyToolTip(this);
    }

    private static int checkStyle(int style) {
        int mask = 11;
        int result = (style & mask) == 0 ? style : ToolTip.checkBits(style, 2, 8, 1, 0, 0, 0);
        return result;
    }
}

