/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.deployer.hot;

import java.io.File;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.nano.deployer.api.core.ApplicationDeployer;
import org.eclipse.virgo.nano.deployer.api.core.DeployerConfiguration;
import org.eclipse.virgo.nano.deployer.hot.HotDeploymentFileSystemListener;
import org.eclipse.virgo.nano.deployer.hot.WatchTask;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.util.io.FileSystemChecker;
import org.eclipse.virgo.util.io.FileSystemListener;
import org.eclipse.virgo.util.io.PathReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HotDeployer {
    private static final String EXCLUDE_PATTERN = "\\.DS_Store|\\.state";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Object lifecycleLock = new Object();
    private final File pickupDir;
    private final Thread thread;

    public HotDeployer(@NonNull DeployerConfiguration deployerConfiguration, @NonNull ApplicationDeployer deployer, EventLogger eventLogger) {
        this.pickupDir = this.createHotDeployDir(deployerConfiguration.getDeploymentPickupDirectory());
        FileSystemChecker checker = this.createFileSystemChecker(deployer, eventLogger);
        this.thread = new Thread((Runnable)new WatchTask(checker, this.pickupDir, deployerConfiguration.getScanIntervalMillis()), "fs-watcher");
    }

    private FileSystemChecker createFileSystemChecker(ApplicationDeployer deployer, EventLogger eventLogger) {
        FileSystemChecker checker = new FileSystemChecker(this.pickupDir, EXCLUDE_PATTERN, this.logger);
        checker.addListener((FileSystemListener)new HotDeploymentFileSystemListener(deployer, eventLogger));
        return checker;
    }

    private File createHotDeployDir(@NonNull PathReference pickUpDirectoryPath) {
        if (pickUpDirectoryPath.isFile()) {
            this.logger.debug("Deleting stray file from hot deployment directory location '{}'.", (Object)pickUpDirectoryPath.getAbsolutePath());
            pickUpDirectoryPath.delete();
        }
        if (!pickUpDirectoryPath.exists()) {
            this.logger.info("Creating hot deployment directory at '{}'.", (Object)pickUpDirectoryPath.getAbsolutePath());
            pickUpDirectoryPath.createDirectory();
        } else {
            this.logger.info("Using hot deployment directory at '{}'.", (Object)pickUpDirectoryPath.getAbsolutePath());
        }
        return pickUpDirectoryPath.toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.thread != null) {
                this.thread.start();
                this.logger.info("Started hot deployer on '{}'.", (Object)this.pickupDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.thread != null) {
                this.logger.info("Stopping hot deployer");
                this.thread.interrupt();
            }
        }
    }

    public String toString() {
        return String.format("Hot Deployer [pickupDir = %s]", this.pickupDir.getAbsolutePath());
    }
}

