/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.wls.shaded.org.apache.xalan.lib;

import com.oracle.wls.shaded.org.apache.xalan.extensions.ExpressionContext;
import com.oracle.wls.shaded.org.apache.xalan.lib.ExsltBase;
import com.oracle.wls.shaded.org.apache.xalan.res.XSLMessages;
import com.oracle.wls.shaded.org.apache.xpath.NodeSet;
import com.oracle.wls.shaded.org.apache.xpath.NodeSetDTM;
import com.oracle.wls.shaded.org.apache.xpath.XPath;
import com.oracle.wls.shaded.org.apache.xpath.XPathContext;
import com.oracle.wls.shaded.org.apache.xpath.objects.XBoolean;
import com.oracle.wls.shaded.org.apache.xpath.objects.XNodeSet;
import com.oracle.wls.shaded.org.apache.xpath.objects.XNumber;
import com.oracle.wls.shaded.org.apache.xpath.objects.XObject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXNotSupportedException;

public class ExsltDynamic
extends ExsltBase {
    public static final String EXSL_URI = "http://exslt.org/common";

    public static double max(ExpressionContext myContext, NodeList nl, String expr) throws SAXNotSupportedException {
        XPathContext xctxt = null;
        if (!(myContext instanceof XPathContext.XPathExpressionContext)) {
            throw new SAXNotSupportedException(XSLMessages.createMessage("ER_INVALID_CONTEXT_PASSED", new Object[]{myContext}));
        }
        xctxt = ((XPathContext.XPathExpressionContext)myContext).getXPathContext();
        if (expr == null || expr.length() == 0) {
            return Double.NaN;
        }
        NodeSetDTM contextNodes = new NodeSetDTM(nl, xctxt);
        xctxt.pushContextNodeList(contextNodes);
        double maxValue = -1.7976931348623157E308;
        int i = 0;
        while (i < contextNodes.getLength()) {
            int contextNode = contextNodes.item(i);
            xctxt.pushCurrentNode(contextNode);
            double result = 0.0;
            try {
                XPath dynamicXPath = new XPath(expr, xctxt.getSAXLocator(), xctxt.getNamespaceContext(), 0);
                result = dynamicXPath.execute(xctxt, contextNode, xctxt.getNamespaceContext()).num();
            }
            catch (TransformerException e) {
                xctxt.popCurrentNode();
                xctxt.popContextNodeList();
                return Double.NaN;
            }
            xctxt.popCurrentNode();
            if (result > maxValue) {
                maxValue = result;
            }
            ++i;
        }
        xctxt.popContextNodeList();
        return maxValue;
    }

    public static double min(ExpressionContext myContext, NodeList nl, String expr) throws SAXNotSupportedException {
        XPathContext xctxt = null;
        if (!(myContext instanceof XPathContext.XPathExpressionContext)) {
            throw new SAXNotSupportedException(XSLMessages.createMessage("ER_INVALID_CONTEXT_PASSED", new Object[]{myContext}));
        }
        xctxt = ((XPathContext.XPathExpressionContext)myContext).getXPathContext();
        if (expr == null || expr.length() == 0) {
            return Double.NaN;
        }
        NodeSetDTM contextNodes = new NodeSetDTM(nl, xctxt);
        xctxt.pushContextNodeList(contextNodes);
        double minValue = Double.MAX_VALUE;
        int i = 0;
        while (i < nl.getLength()) {
            int contextNode = contextNodes.item(i);
            xctxt.pushCurrentNode(contextNode);
            double result = 0.0;
            try {
                XPath dynamicXPath = new XPath(expr, xctxt.getSAXLocator(), xctxt.getNamespaceContext(), 0);
                result = dynamicXPath.execute(xctxt, contextNode, xctxt.getNamespaceContext()).num();
            }
            catch (TransformerException e) {
                xctxt.popCurrentNode();
                xctxt.popContextNodeList();
                return Double.NaN;
            }
            xctxt.popCurrentNode();
            if (result < minValue) {
                minValue = result;
            }
            ++i;
        }
        xctxt.popContextNodeList();
        return minValue;
    }

    public static double sum(ExpressionContext myContext, NodeList nl, String expr) throws SAXNotSupportedException {
        XPathContext xctxt = null;
        if (!(myContext instanceof XPathContext.XPathExpressionContext)) {
            throw new SAXNotSupportedException(XSLMessages.createMessage("ER_INVALID_CONTEXT_PASSED", new Object[]{myContext}));
        }
        xctxt = ((XPathContext.XPathExpressionContext)myContext).getXPathContext();
        if (expr == null || expr.length() == 0) {
            return Double.NaN;
        }
        NodeSetDTM contextNodes = new NodeSetDTM(nl, xctxt);
        xctxt.pushContextNodeList(contextNodes);
        double sum = 0.0;
        int i = 0;
        while (i < nl.getLength()) {
            int contextNode = contextNodes.item(i);
            xctxt.pushCurrentNode(contextNode);
            double result = 0.0;
            try {
                XPath dynamicXPath = new XPath(expr, xctxt.getSAXLocator(), xctxt.getNamespaceContext(), 0);
                result = dynamicXPath.execute(xctxt, contextNode, xctxt.getNamespaceContext()).num();
            }
            catch (TransformerException e) {
                xctxt.popCurrentNode();
                xctxt.popContextNodeList();
                return Double.NaN;
            }
            xctxt.popCurrentNode();
            sum += result;
            ++i;
        }
        xctxt.popContextNodeList();
        return sum;
    }

    public static NodeList map(ExpressionContext myContext, NodeList nl, String expr) throws SAXNotSupportedException {
        XPathContext xctxt = null;
        Document lDoc = null;
        if (!(myContext instanceof XPathContext.XPathExpressionContext)) {
            throw new SAXNotSupportedException(XSLMessages.createMessage("ER_INVALID_CONTEXT_PASSED", new Object[]{myContext}));
        }
        xctxt = ((XPathContext.XPathExpressionContext)myContext).getXPathContext();
        if (expr == null || expr.length() == 0) {
            return new NodeSet();
        }
        NodeSetDTM contextNodes = new NodeSetDTM(nl, xctxt);
        xctxt.pushContextNodeList(contextNodes);
        NodeSet resultSet = new NodeSet();
        resultSet.setShouldCacheNodes(true);
        int i = 0;
        while (i < nl.getLength()) {
            int contextNode = contextNodes.item(i);
            xctxt.pushCurrentNode(contextNode);
            XObject object = null;
            try {
                XPath dynamicXPath = new XPath(expr, xctxt.getSAXLocator(), xctxt.getNamespaceContext(), 0);
                object = dynamicXPath.execute(xctxt, contextNode, xctxt.getNamespaceContext());
                if (object instanceof XNodeSet) {
                    NodeList nodelist = null;
                    nodelist = ((XNodeSet)object).nodelist();
                    int k = 0;
                    while (k < nodelist.getLength()) {
                        Node n = nodelist.item(k);
                        if (!resultSet.contains(n)) {
                            resultSet.addNode(n);
                        }
                        ++k;
                    }
                } else {
                    if (lDoc == null) {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        dbf.setNamespaceAware(true);
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        lDoc = db.newDocument();
                    }
                    Element element = null;
                    element = object instanceof XNumber ? lDoc.createElementNS(EXSL_URI, "exsl:number") : (object instanceof XBoolean ? lDoc.createElementNS(EXSL_URI, "exsl:boolean") : lDoc.createElementNS(EXSL_URI, "exsl:string"));
                    Text textNode = lDoc.createTextNode(object.str());
                    element.appendChild(textNode);
                    resultSet.addNode(element);
                }
            }
            catch (Exception e) {
                xctxt.popCurrentNode();
                xctxt.popContextNodeList();
                return new NodeSet();
            }
            xctxt.popCurrentNode();
            ++i;
        }
        xctxt.popContextNodeList();
        return resultSet;
    }

    public static XObject evaluate(ExpressionContext myContext, String xpathExpr) throws SAXNotSupportedException {
        if (myContext instanceof XPathContext.XPathExpressionContext) {
            XPathContext xctxt = null;
            try {
                xctxt = ((XPathContext.XPathExpressionContext)myContext).getXPathContext();
                XPath dynamicXPath = new XPath(xpathExpr, xctxt.getSAXLocator(), xctxt.getNamespaceContext(), 0);
                return dynamicXPath.execute(xctxt, myContext.getContextNode(), xctxt.getNamespaceContext());
            }
            catch (TransformerException e) {
                return new XNodeSet(xctxt.getDTMManager());
            }
        }
        throw new SAXNotSupportedException(XSLMessages.createMessage("ER_INVALID_CONTEXT_PASSED", new Object[]{myContext}));
    }

    public static NodeList closure(ExpressionContext myContext, NodeList nl, String expr) throws SAXNotSupportedException {
        XPathContext xctxt = null;
        if (!(myContext instanceof XPathContext.XPathExpressionContext)) {
            throw new SAXNotSupportedException(XSLMessages.createMessage("ER_INVALID_CONTEXT_PASSED", new Object[]{myContext}));
        }
        xctxt = ((XPathContext.XPathExpressionContext)myContext).getXPathContext();
        if (expr == null || expr.length() == 0) {
            return new NodeSet();
        }
        NodeSet closureSet = new NodeSet();
        closureSet.setShouldCacheNodes(true);
        NodeList iterationList = nl;
        do {
            NodeSet iterationSet = new NodeSet();
            NodeSetDTM contextNodes = new NodeSetDTM(iterationList, xctxt);
            xctxt.pushContextNodeList(contextNodes);
            int i = 0;
            while (i < iterationList.getLength()) {
                block11: {
                    int contextNode = contextNodes.item(i);
                    xctxt.pushCurrentNode(contextNode);
                    XObject object = null;
                    try {
                        XPath dynamicXPath = new XPath(expr, xctxt.getSAXLocator(), xctxt.getNamespaceContext(), 0);
                        object = dynamicXPath.execute(xctxt, contextNode, xctxt.getNamespaceContext());
                        if (object instanceof XNodeSet) {
                            NodeList nodelist = null;
                            nodelist = ((XNodeSet)object).nodelist();
                            int k = 0;
                            while (k < nodelist.getLength()) {
                                Node n = nodelist.item(k);
                                if (!iterationSet.contains(n)) {
                                    iterationSet.addNode(n);
                                }
                                ++k;
                            }
                            break block11;
                        }
                        xctxt.popCurrentNode();
                        xctxt.popContextNodeList();
                        return new NodeSet();
                    }
                    catch (TransformerException e) {
                        xctxt.popCurrentNode();
                        xctxt.popContextNodeList();
                        return new NodeSet();
                    }
                }
                xctxt.popCurrentNode();
                ++i;
            }
            xctxt.popContextNodeList();
            iterationList = iterationSet;
            int i2 = 0;
            while (i2 < iterationList.getLength()) {
                Node n = iterationList.item(i2);
                if (!closureSet.contains(n)) {
                    closureSet.addNode(n);
                }
                ++i2;
            }
        } while (iterationList.getLength() > 0);
        return closureSet;
    }
}

