/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.editor;

import java.util.HashSet;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.metadata.IEvent;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.ui.editor.XWTEditor;
import org.eclipse.xwt.ui.editor.jdt.ASTHelper;
import org.eclipse.xwt.vex.AbstractCodeSynchronizer;
import org.eclipse.xwt.vex.VEXEditor;
import org.eclipse.xwt.vex.dom.DomHelper;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XWTCodeSynchronizer
extends AbstractCodeSynchronizer {
    private static final String INIT_METHOD_NAME = "initializeComponent";
    private IType type;

    public XWTCodeSynchronizer(XWTEditor editor, IType type) {
        super((VEXEditor)editor);
        this.type = type;
        if (type == null) {
            throw new NullPointerException("Java Source Type is Null!");
        }
    }

    public void remove(final IDOMNode node) {
        Display display;
        final String remove = (String)this.getNode2name().remove(node);
        if (remove != null && (display = Display.getDefault()) != null) {
            display.syncExec(new Runnable(){

                public void run() {
                    String fullTypeName = XWTCodeSynchronizer.this.getFullTypeName(node);
                    if (fullTypeName == null) {
                        return;
                    }
                    XWTCodeSynchronizer.this.removeFields(fullTypeName, remove);
                    XWTCodeSynchronizer.this.buildInitialization();
                    ASTHelper.removeUnusedImports(XWTCodeSynchronizer.this.type);
                }
            });
        }
    }

    protected String getFullTypeName(IDOMNode node) {
        String fullName = null;
        String nodeName = node.getNodeName();
        return fullName;
    }

    public IType getType() {
        return this.type;
    }

    public void setType(IType type) {
        this.type = type;
    }

    public void generateFields(String fullTypeName, String argName) {
        ASTHelper.generateNamedFields(this.type, fullTypeName, argName);
    }

    public void removeFields(String fullTypeName, String argName) {
        try {
            IField[] fields;
            IField[] iFieldArray = fields = this.type.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                if (argName.equals(field.getElementName())) {
                    field.delete(false, null);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    public void buildInitialization() {
        try {
            HashSet<String> forGens = new HashSet<String>(this.getNode2name().values());
            IField[] fields = this.type.getFields();
            ASTHelper.generateInitialization(this.type, INIT_METHOD_NAME, forGens);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean generateHandles() {
        StructuredTextViewer textViewer = this.getEditor().getTextEditor().getTextViewer();
        int offset = textViewer.getTextWidget().getCaretOffset();
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)offset);
        Node node = (Node)treeNode;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode xmlnode = (IDOMNode)node;
        this.updateCodeManager();
        String name = xmlnode.getNodeName();
        if (name.indexOf(":") > 0) {
            name = name.substring(name.indexOf(":") + 1);
        }
        IMetaclass metaclass = null;
        try {
            metaclass = XWT.getMetaclass((String)name, (String)DomHelper.lookupNamespaceURI((Node)xmlnode));
        }
        catch (Exception e1) {
            return false;
        }
        if (metaclass != null) {
            NamedNodeMap nodeMap = xmlnode.getAttributes();
            int i = nodeMap.getLength() - 1;
            while (i >= 0) {
                IDOMAttr attrNode = (IDOMAttr)nodeMap.item(i);
                int endOffset = attrNode.getEndOffset();
                int startOffset = attrNode.getStartOffset();
                if (offset >= startOffset && offset <= endOffset) {
                    int index;
                    String propertyName = attrNode.getName();
                    IEvent event = metaclass.findEvent(propertyName);
                    if (event == null && (index = propertyName.indexOf(46)) != -1) {
                        String typeName = propertyName.substring(0, index);
                        String eventName = propertyName.substring(index + 1);
                        metaclass = XWT.getMetaclass((String)typeName, (String)DomHelper.lookupNamespaceURI((Node)attrNode));
                        if (metaclass != null) {
                            event = metaclass.findEvent(eventName);
                        }
                    }
                    if (event != null) {
                        try {
                            ASTHelper.generateEventHandler(this.type, Event.class.getName(), attrNode.getValue());
                            return true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                }
                --i;
            }
        }
        return false;
    }

    public boolean openDefinition() {
        StructuredTextViewer textViewer = this.getEditor().getTextEditor().getTextViewer();
        int offset = textViewer.getTextWidget().getCaretOffset();
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)offset);
        Node node = (Node)treeNode;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode xmlnode = (IDOMNode)node;
        String name = xmlnode.getNodeName();
        return false;
    }

    public boolean handleInputChanged(IDocument newInput) {
        String value = newInput.get();
        if (this.checkContent(value)) {
            return false;
        }
        StructuredTextViewer textViewer = this.getEditor().getTextEditor().getTextViewer();
        int offset = textViewer.getTextWidget().getCaretOffset();
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)offset);
        Node node = (Node)treeNode;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode xmlnode = (IDOMNode)node;
        String name = xmlnode.getNodeName();
        return true;
    }

    private void jumpToJavaMethod(IMethod[] methods, String methodName) {
        IMethod method = this.findMethod(methods, methodName);
        CompilationUnitEditor javaEditor = ((XWTEditor)this.getEditor()).getJavaEditor();
        if (method != null) {
            javaEditor.setSelection((IJavaElement)method);
        }
        this.getEditor().setActiveEditor((IEditorPart)javaEditor);
    }

    private IMethod findMethod(IMethod[] methods, String methodName) {
        int i = 0;
        while (i < methods.length) {
            IMethod method = methods[i];
            if (method.getElementName().equals(methodName)) {
                return method;
            }
            ++i;
        }
        return null;
    }

    private void modifyAllRelativeHandlerName(StructuredTextViewer textViewer, int offset, String inputHandler, String oldAttrValue) {
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)offset);
        Node node = (Node)treeNode;
        this.modifyHandlerName(inputHandler, node, oldAttrValue);
    }

    private void modifyHandlerName(String inputHandler, Node node, String oldAttrValue) {
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        String name = node.getNodeName();
        node.getNodeType();
        NodeList nodes = node.getChildNodes();
        int length = nodes.getLength();
        int i = 0;
        while (i < length) {
            Node childNode = nodes.item(i);
            if (childNode.getNodeType() == 1) {
                this.modifyHandlerName(inputHandler, childNode, oldAttrValue);
            }
            ++i;
        }
    }
}

