/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.utils;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.xwt.ILogger;
import org.eclipse.xwt.Tracking;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log
implements ILogger {
    private MessageConsoleStream messageConsoleStream = null;
    private Map<Tracking, String> messageMap = new HashMap<Tracking, String>();
    private MessageConsole console;

    private MessageConsoleStream getConsoleStream() {
        if (this.messageConsoleStream == null) {
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            if (plugin == null) {
                return null;
            }
            this.console = new MessageConsole("XWT Application [XWT Application]", null);
            IConsoleManager manager = plugin.getConsoleManager();
            manager.addConsoles(new IConsole[]{this.console});
            manager.showConsoleView((IConsole)this.console);
            this.messageConsoleStream = this.console.newMessageStream();
            this.messageConsoleStream.setColor(Display.getDefault().getSystemColor(2));
        }
        return this.messageConsoleStream;
    }

    public void printInfo(String message, Tracking tracking, Set<Tracking> trackTypes) {
        String printMessage = "";
        if (trackTypes != null && trackTypes.size() > 0 && trackTypes.contains(tracking)) {
            printMessage = this.messageMap.get(tracking);
        }
        MessageConsoleStream msgStream = this.getConsoleStream();
        this.console.clearConsole();
        if (msgStream != null) {
            msgStream.print(printMessage);
        }
    }

    public void addMessage(String message, Tracking tracking) {
        if (this.messageMap.containsKey(tracking)) {
            this.messageMap.remove(tracking);
        }
        this.messageMap.put(tracking, message);
    }

    public void removeMessage(Tracking tracking) {
        if (this.messageMap.containsKey(tracking)) {
            this.messageMap.remove(tracking);
        }
    }

    public void error(Throwable e) {
        MessageConsoleStream msgStream = this.getConsoleStream();
        if (msgStream != null) {
            Color color = msgStream.getColor();
            msgStream.setColor(Display.getDefault().getSystemColor(3));
            PrintStream printStream = new PrintStream((OutputStream)msgStream);
            e.printStackTrace(printStream);
            msgStream.setColor(color);
        }
    }

    public void error(Throwable e, String message) {
        MessageConsoleStream msgStream = this.getConsoleStream();
        if (msgStream != null) {
            Color color = msgStream.getColor();
            msgStream.setColor(Display.getDefault().getSystemColor(3));
            PrintStream printStream = new PrintStream((OutputStream)msgStream);
            msgStream.print(message);
            e.printStackTrace(printStream);
            msgStream.setColor(color);
        }
    }

    public void message(String message) {
        MessageConsoleStream msgStream = this.getConsoleStream();
        if (msgStream != null) {
            msgStream.print(message);
        }
    }

    public void warning(String message) {
        this.message(message);
    }
}

