/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.dialogs;

import java.util.Map;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutsHelper;
import org.eclipse.xwt.tools.ui.designer.layouts.pages.AssistancePageFactory;
import org.eclipse.xwt.tools.ui.designer.layouts.pages.IAssistantPage;
import org.eclipse.xwt.tools.ui.designer.resources.ImageShop;
import org.eclipse.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutAssistantWindow
extends Window {
    public static final String NOLAYOUT_TAB = "Info";
    public static final String LAYOUT_TAB = "Layout";
    public static final String PARENTLAYOUT_TAB = "Parent Layout";
    public static final String LAYOUTDATA_TAB = "Layout Data";
    private EditPart editPart;
    protected CTabFolder tabFolder;
    private CTabItem layoutTab;
    private CTabItem layoutDataTab;
    protected Composite layoutPage;
    protected StackLayout layoutPageLayout;
    protected Composite layoutDataPage;
    protected StackLayout layoutDataPageLayout;
    protected Composite noLayoutPage;
    protected Composite noComponentPage;
    private Map<Object, IAssistantPage> pageMaps = AssistancePageFactory.newPages();
    private boolean isClosed;
    private boolean isOpened;

    public LayoutAssistantWindow(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(2160);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Layout Assistant");
    }

    public void setEditPart(EditPart editPart) {
        EditPart oldEp = this.editPart;
        if (editPart != null && editPart != oldEp) {
            this.editPart = editPart;
            this.refresh();
        }
    }

    protected Control createContents(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 0);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        String tabName = this.getLayoutTabName();
        this.layoutTab = new CTabItem(this.tabFolder, 0);
        this.layoutTab.setText(tabName);
        this.layoutTab.setToolTipText("layout options");
        this.layoutPage = new Composite((Composite)this.tabFolder, 0);
        this.layoutPageLayout = new StackLayout();
        this.layoutPage.setLayout((Layout)this.layoutPageLayout);
        this.layoutTab.setControl((Control)this.layoutPage);
        if (tabName.equals(NOLAYOUT_TAB)) {
            this.createNoneLayoutPage();
        } else if (tabName.equals(LAYOUT_TAB)) {
            this.createParentLayoutPage(this.editPart);
        } else if (tabName.equals(PARENTLAYOUT_TAB)) {
            this.createControlLayoutPage();
        }
        this.tabFolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LayoutAssistantWindow.this.tabFolder = null;
            }
        });
        ToolBar toolBar = new ToolBar((Composite)this.tabFolder, 0);
        ToolItem defaultTool = new ToolItem(toolBar, 8);
        defaultTool.setImage(ImageShop.get("/icons/full/tools/clear_filter.gif"));
        defaultTool.setToolTipText("Clear setting values.");
        defaultTool.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LayoutAssistantWindow.this.performDefault();
            }
        });
        this.tabFolder.setTopRight((Control)toolBar);
        this.tabFolder.setTabHeight(22);
        Dialog.applyDialogFont((Control)this.tabFolder);
        return this.tabFolder;
    }

    protected void performDefault() {
        CTabItem selection = this.tabFolder.getSelection();
        if (selection == null) {
            return;
        }
        Control control = null;
        if (selection == this.layoutTab) {
            control = this.layoutPageLayout.topControl;
        } else if (selection == this.layoutDataTab) {
            control = this.layoutDataPageLayout.topControl;
        }
        if (control != null && control.getData() != null && control.getData() instanceof IAssistantPage) {
            ((IAssistantPage)control.getData()).performDefault();
        }
    }

    private void createNoneLayoutPage() {
        if (this.noLayoutPage == null) {
            this.noLayoutPage = new Composite(this.layoutPage, 0);
            this.noLayoutPage.setLayout((Layout)new GridLayout());
            Label noLayoutLabel = new Label(this.noLayoutPage, 64);
            noLayoutLabel.setText("Selection does not provide any layout assistance.");
            GridData gd = new GridData();
            gd.widthHint = 200;
            noLayoutLabel.setLayoutData((Object)gd);
        }
        this.layoutPageLayout.topControl = this.noLayoutPage;
        this.layoutPage.layout();
    }

    private void createControlLayoutPage() {
        IAssistantPage dataPage;
        EditPart parentEditPart = this.getParent(this.editPart);
        if (parentEditPart != null) {
            this.createParentLayoutPage(parentEditPart);
        }
        if ((dataPage = this.pageMaps.get((Object)LayoutsHelper.getLayoutDataType(this.editPart))) != null) {
            if (this.layoutDataTab == null || this.layoutDataTab.isDisposed()) {
                this.createLayoutDataTab();
            }
            this.createPageControl(dataPage, this.layoutDataPage, this.layoutDataPageLayout);
        } else if (this.layoutDataTab != null && !this.layoutDataTab.isDisposed()) {
            this.layoutDataTab.setControl(null);
            this.layoutDataTab.dispose();
        }
    }

    private void createLayoutDataTab() {
        this.layoutDataTab = new CTabItem(this.tabFolder, 0);
        this.layoutDataTab.setText(LAYOUTDATA_TAB);
        this.layoutDataTab.setToolTipText("layoutData options");
        if (this.layoutDataPage == null) {
            this.layoutDataPage = new Composite((Composite)this.tabFolder, 0);
            this.layoutDataPageLayout = new StackLayout();
            this.layoutDataPage.setLayout((Layout)this.layoutDataPageLayout);
        }
        this.layoutDataTab.setControl((Control)this.layoutDataPage);
    }

    private void createParentLayoutPage(EditPart editPart) {
        IAssistantPage page = this.pageMaps.get((Object)LayoutsHelper.getLayoutType(editPart));
        if (page != null) {
            this.createPageControl(page, this.layoutPage, this.layoutPageLayout);
            page.setEditPart(editPart);
        }
    }

    private void createPageControl(IAssistantPage assistantPage, Composite parentComposite, StackLayout parentLayout) {
        Control control = assistantPage.getControl(parentComposite);
        if (control != null) {
            parentLayout.topControl = control;
            parentComposite.layout();
            assistantPage.setEditPart(this.editPart);
            Point size = this.getInitialSize();
            this.getShell().setSize(size.x, size.y);
        }
    }

    public void refresh() {
        if (this.layoutTab == null || this.layoutTab.isDisposed()) {
            return;
        }
        String tabName = this.getLayoutTabName();
        this.layoutTab.setText(tabName);
        if (tabName.equals(NOLAYOUT_TAB)) {
            this.createNoneLayoutPage();
        } else if (tabName.equals(LAYOUT_TAB)) {
            this.createParentLayoutPage(this.editPart);
            if (this.layoutDataTab != null && !this.layoutDataTab.isDisposed()) {
                this.layoutDataTab.setControl(null);
                this.layoutDataTab.dispose();
            }
        } else if (tabName.equals(PARENTLAYOUT_TAB)) {
            this.createControlLayoutPage();
        }
    }

    private String getLayoutTabName() {
        if (this.editPart != null) {
            EditPart parent = this.getParent(this.editPart);
            XamlAttribute layoutAttr = null;
            if (parent == null) {
                layoutAttr = this.getLayoutAttr(this.editPart.getModel());
                if (layoutAttr != null) {
                    return LAYOUT_TAB;
                }
            } else {
                layoutAttr = this.getLayoutAttr(parent.getModel());
                if (layoutAttr != null) {
                    return PARENTLAYOUT_TAB;
                }
            }
        }
        return NOLAYOUT_TAB;
    }

    private XamlAttribute getLayoutAttr(Object model) {
        XamlAttribute attribute = null;
        if (model instanceof XamlElement) {
            XamlElement element = (XamlElement)model;
            attribute = element.getAttribute("layout");
        }
        return attribute;
    }

    private Class<?> getType(EditPart editPart) {
        XamlElement element;
        IMetaclass metaclass;
        if (editPart == null) {
            return null;
        }
        Object model = editPart.getModel();
        if (model instanceof XamlElement && (metaclass = XWTUtility.getMetaclass((XamlNode)(element = (XamlElement)model))) != null) {
            return metaclass.getType();
        }
        return null;
    }

    private EditPart getParent(EditPart editPart) {
        if (editPart != null) {
            EditPart parent = editPart.getParent();
            if (parent.getModel() instanceof XamlDocument) {
                return null;
            }
            Class<?> type = this.getType(parent);
            if (type == null) {
                return null;
            }
            if (Composite.class.isAssignableFrom(type) || Shell.class.isAssignableFrom(type)) {
                return parent;
            }
            return this.getParent(parent);
        }
        return null;
    }

    public int open() {
        int open = super.open();
        this.isOpened = open == 0;
        return open;
    }

    public boolean close() {
        this.isClosed = super.close();
        if (this.tabFolder != null) {
            this.tabFolder.dispose();
        }
        return this.isClosed;
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    protected Point getInitialSize() {
        Point initSize = this.getShell().computeSize(-1, -1, true);
        if (initSize.x < 100) {
            initSize.x = 100;
        }
        if (initSize.x < 90) {
            initSize.y = 90;
        }
        return initSize;
    }
}

