/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt.targetvm.macosx;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ImageCapture
extends org.eclipse.xwt.vex.swt.ImageCapture {
    private static Field shellHandleField = null;
    private static Method HIViewGetRootMethod = null;
    private static Method carbon_newMethod = null;

    static {
        System.loadLibrary("swt-carbon-print");
        try {
            shellHandleField = Shell.class.getDeclaredField("shellHandle");
            shellHandleField.setAccessible(true);
            Class<?> osClass = Class.forName("org.eclipse.swt.internal.carbon.OS");
            HIViewGetRootMethod = osClass.getMethod("HIViewGetRoot", Integer.TYPE);
            carbon_newMethod = Image.class.getMethod("carbon_new", Device.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private native int captureImage(int var1, int var2);

    @Override
    protected Image getImage(Control control, int maxWidth, int maxHeight, boolean includeChildren) {
        Rectangle rect = control.getBounds();
        if (rect.width <= 0 || rect.height <= 0) {
            return null;
        }
        int width = Math.min(rect.width, maxWidth);
        int height = Math.min(rect.height, maxHeight);
        Image image = null;
        int controlHandle = -1;
        int shellHandle = -1;
        try {
            int imageHandle;
            if (control instanceof Shell) {
                Integer result;
                shellHandle = shellHandleField.getInt(control);
                if (shellHandle != -1 && (result = (Integer)HIViewGetRootMethod.invoke(null, new Integer(shellHandle))) != null) {
                    controlHandle = result;
                }
            } else {
                controlHandle = ImageCapture.getIntHandle(control);
                shellHandle = shellHandleField.getInt(control.getShell());
            }
            if ((imageHandle = this.captureImage(controlHandle, shellHandle)) != 0) {
                Image tempImage = (Image)carbon_newMethod.invoke(null, control.getDisplay(), new Integer(0), new Integer(imageHandle), new Integer(0));
                image = new Image((Device)control.getDisplay(), width, height);
                GC gc = new GC((Drawable)tempImage);
                gc.copyArea(image, 0, 0);
                gc.dispose();
                tempImage.dispose();
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return image;
    }
}

