/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.vex.palette;

import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xwt.vex.palette.PaletteResourceManager;
import org.eclipse.xwt.vex.palette.PaletteRootFactory;
import org.eclipse.xwt.vex.palette.part.ToolPaletteViewerProvider;

public class PaletteViewManager {
    private PaletteViewerProvider provider;
    private PaletteRoot paletteRoot;
    private IEditorPart editorPart;
    private DefaultEditDomain editDomain;

    public PaletteViewManager(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    public PaletteViewerProvider getPaletteViewerProvider() {
        if (this.provider == null) {
            this.provider = this.createPaletteViewerProvider();
        }
        return this.provider;
    }

    private PaletteViewerProvider createPaletteViewerProvider() {
        return new ToolPaletteViewerProvider(this.getEditDomain(), this.editorPart);
    }

    private EditDomain getEditDomain() {
        if (this.editDomain == null) {
            this.editDomain = new DefaultEditDomain(this.editorPart);
            this.editDomain.setPaletteRoot(this.getPaletteRoot());
        }
        return this.editDomain;
    }

    public PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = PaletteRootFactory.createPalette(this.editorPart);
        }
        return this.paletteRoot;
    }

    public PaletteRoot getPaletteRootByResourceManager(PaletteResourceManager resourceManager) {
        this.paletteRoot = PaletteRootFactory.createPaletteByResourceManager(resourceManager);
        return this.paletteRoot;
    }
}

