/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.dialogs;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTMaps;
import org.eclipse.xwt.utils.NamedColorsUtil;
import org.eclipse.xwt.utils.ResourceManager;

public class ColorChooser
extends Dialog {
    private Canvas previewCanvas;
    private Text redText;
    private Text greenText;
    private Text blueText;
    private Text resultText;
    private Object initValue;
    private Map<Object, Color> colorsMap = new HashMap<Object, Color>();
    private String result;
    private static final Color BACKGROUND = Display.getDefault().getSystemColor(1);
    private Control selection;

    public ColorChooser(Shell parent, Object initValue) {
        super(parent);
        this.initValue = initValue;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Color Chooser");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new GridLayout(1, true));
        this.createPreviewGrp(dialogArea);
        this.createColorGrp(dialogArea);
        if (this.initValue != null) {
            if (this.initValue instanceof String) {
                this.preview((String)this.initValue);
            } else if (this.initValue instanceof Color) {
                this.preview((Color)this.initValue);
            }
        }
        return dialogArea;
    }

    private void createColorGrp(Composite dialogArea) {
        Group colorGrp = new Group(dialogArea, 0);
        colorGrp.setText("Color");
        colorGrp.setLayout((Layout)new GridLayout());
        colorGrp.setLayoutData((Object)new GridData(1808));
        TabFolder tabFolder = new TabFolder((Composite)colorGrp, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem systemTab = new TabItem(tabFolder, 0);
        systemTab.setText("System Colors");
        systemTab.setControl(this.createSystemColorsControl((Composite)tabFolder));
        TabItem namedTab = new TabItem(tabFolder, 0);
        namedTab.setText("Named Colors");
        namedTab.setControl(this.createNamedColorsControl((Composite)tabFolder));
        Button browserButton = new Button((Composite)colorGrp, 8);
        browserButton.setText("System Color Dialog");
        browserButton.setLayoutData((Object)new GridData(768));
        browserButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ColorDialog colorDialog = new ColorDialog(ColorChooser.this.getShell());
                RGB open = colorDialog.open();
                if (open != null) {
                    ColorChooser.this.preview(open);
                }
            }
        });
    }

    private Control createNamedColorsControl(Composite parent) {
        String[] namedColors;
        ScrolledComposite scrollable = new ScrolledComposite(parent, 2560);
        Composite control = new Composite((Composite)scrollable, 0);
        control.setLayout((Layout)new GridLayout(16, true));
        control.setBackground(BACKGROUND);
        String[] stringArray = namedColors = NamedColorsUtil.getColorNames();
        int n = namedColors.length;
        int n2 = 0;
        while (n2 < n) {
            String colorName = stringArray[n2];
            this.addNamedColor(control, colorName);
            ++n2;
        }
        scrollable.setContent((Control)control);
        scrollable.setExpandVertical(true);
        scrollable.setExpandHorizontal(true);
        scrollable.setMinSize(control.computeSize(-200, -1));
        scrollable.setBackground(BACKGROUND);
        return scrollable;
    }

    private void addNamedColor(Composite control, final String colorName) {
        final CLabel colorLabel = new CLabel(control, 0);
        colorLabel.setBackground(BACKGROUND);
        colorLabel.setToolTipText(colorName);
        Color color = NamedColorsUtil.getColor((String)colorName);
        if (color != null) {
            Display device = Display.getCurrent();
            Image image = new Image((Device)device, 18, 18);
            GC gc = new GC((Drawable)image);
            gc.setBackground(color);
            gc.fillRectangle(0, 0, 18, 18);
            gc.dispose();
            colorLabel.setImage(image);
        }
        final Display display = this.getShell().getDisplay();
        colorLabel.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                if (colorLabel != ColorChooser.this.selection) {
                    colorLabel.setBackground(BACKGROUND);
                }
            }
        });
        colorLabel.addListener(6, new Listener(){

            public void handleEvent(Event event) {
                if (colorLabel != ColorChooser.this.selection) {
                    colorLabel.setBackground(new Color[]{display.getSystemColor(1), display.getSystemColor(22)}, new int[]{100}, true);
                }
            }
        });
        colorLabel.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Control oldSelection = ColorChooser.this.selection;
                if (oldSelection == null || oldSelection != colorLabel) {
                    colorLabel.setBackground(new Color[]{display.getSystemColor(1), display.getSystemColor(15)}, new int[]{100}, true);
                    ColorChooser.this.preview(colorName);
                    ColorChooser.this.selection = colorLabel;
                } else {
                    ColorChooser.this.selection = null;
                    ColorChooser.this.preview(null);
                }
                if (oldSelection != null) {
                    oldSelection.setBackground(BACKGROUND);
                }
            }
        });
    }

    private Control createSystemColorsControl(Composite parent) {
        Composite control = new Composite(parent, 2048);
        control.setLayout((Layout)new GridLayout(16, true));
        control.setBackground(BACKGROUND);
        Collection systemColors = XWTMaps.getColorKeys();
        for (String sysColor : systemColors) {
            this.addSystemColor(control, sysColor);
        }
        return control;
    }

    private void addSystemColor(Composite parent, final String systemColor) {
        final CLabel colorLabel = new CLabel(parent, 0);
        colorLabel.setBackground(BACKGROUND);
        colorLabel.setLayoutData((Object)new GridData(768));
        colorLabel.setToolTipText(systemColor);
        Color color = ResourceManager.resources.getColor(systemColor);
        if (color != null) {
            Display device = Display.getCurrent();
            Image image = new Image((Device)device, 18, 18);
            GC gc = new GC((Drawable)image);
            gc.setBackground(color);
            gc.fillRectangle(0, 0, 18, 18);
            gc.dispose();
            colorLabel.setImage(image);
        }
        final Display display = this.getShell().getDisplay();
        colorLabel.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                if (colorLabel != ColorChooser.this.selection) {
                    colorLabel.setBackground(BACKGROUND);
                }
            }
        });
        colorLabel.addListener(6, new Listener(){

            public void handleEvent(Event event) {
                if (colorLabel != ColorChooser.this.selection) {
                    colorLabel.setBackground(new Color[]{display.getSystemColor(1), display.getSystemColor(22)}, new int[]{100}, true);
                }
            }
        });
        colorLabel.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Control oldSelection = ColorChooser.this.selection;
                if (oldSelection == null || oldSelection != colorLabel) {
                    colorLabel.setBackground(new Color[]{display.getSystemColor(1), display.getSystemColor(15)}, new int[]{100}, true);
                    ColorChooser.this.preview(systemColor);
                    ColorChooser.this.selection = colorLabel;
                } else {
                    ColorChooser.this.selection = null;
                    ColorChooser.this.preview(null);
                }
                if (oldSelection != null) {
                    oldSelection.setBackground(BACKGROUND);
                }
            }
        });
    }

    private Color getColor(Object object) {
        if (object == null) {
            return null;
        }
        Color color = this.colorsMap.get(object);
        if (color != null && !color.isDisposed()) {
            return color;
        }
        if (object instanceof String) {
            String colorStr = ((String)object).trim();
            IConverter c = XWT.findConvertor(String.class, Color.class);
            if (c != null) {
                color = (Color)c.convert((Object)colorStr);
            }
        } else if (object instanceof RGB) {
            color = new Color(null, (RGB)object);
            this.colorsMap.put(object, color);
        } else if (object instanceof Color) {
            color = (Color)object;
        }
        return color;
    }

    public boolean close() {
        Collection<Color> values = this.colorsMap.values();
        for (Color color : values) {
            if (color == null) continue;
            color.dispose();
        }
        this.colorsMap.clear();
        return super.close();
    }

    private void preview(Object object) {
        Color color = this.getColor(object);
        if (color != null && !color.isDisposed()) {
            int red = color.getRed();
            int green = color.getGreen();
            int blue = color.getBlue();
            this.result = object instanceof String ? (String)object : String.valueOf(red) + "," + green + "," + blue;
            this.previewCanvas.setBackground(color);
            this.redText.setText("" + red);
            this.greenText.setText("" + green);
            this.blueText.setText("" + blue);
            this.resultText.setText(this.result);
        } else {
            this.previewCanvas.setBackground(null);
            this.redText.setText("");
            this.greenText.setText("");
            this.blueText.setText("");
            this.resultText.setText("");
        }
    }

    private void createPreviewGrp(Composite parent) {
        Group previewGrp = new Group(parent, 0);
        previewGrp.setText("Selected Color");
        previewGrp.setLayout((Layout)new GridLayout(3, false));
        previewGrp.setLayoutData((Object)new GridData(1808));
        this.previewCanvas = new Canvas((Composite)previewGrp, 2048);
        GridData layoutData = new GridData(1808);
        layoutData.verticalSpan = 4;
        this.previewCanvas.setLayoutData((Object)layoutData);
        this.redText = this.createTextGroup((Composite)previewGrp, "R:");
        this.greenText = this.createTextGroup((Composite)previewGrp, "G:");
        this.blueText = this.createTextGroup((Composite)previewGrp, "B:");
        this.resultText = this.createTextGroup((Composite)previewGrp, "Result:");
    }

    private Text createTextGroup(Composite parent, String name) {
        Label label = new Label(parent, 0x1000000);
        label.setText(name);
        Text text = new Text(parent, 8);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    public String getColor() {
        return this.result;
    }
}

