/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.editor.checkers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.xwt.ui.editor.checkers.AbstractProblemChecker;
import org.eclipse.xwt.vex.dom.DomHelper;
import org.eclipse.xwt.vex.problems.Problem;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementPropertiesChecker
extends AbstractProblemChecker {
    private static final String XMLNS_TAG = "xmlns";

    @Override
    protected void checkProblems(StructuredTextEditor textEditor, String javaName, Node node, List<Problem> problems, boolean includeChindren) {
        NamedNodeMap attributes;
        if (!this.isValid(node)) {
            return;
        }
        NodeList childNodes = node.getChildNodes();
        if (includeChindren && childNodes != null) {
            int length = childNodes.getLength();
            int i = 0;
            while (i < length) {
                Node item = childNodes.item(i);
                if (includeChindren) {
                    this.checkProblems(textEditor, javaName, item, problems, includeChindren);
                }
                ++i;
            }
        }
        if ((attributes = node.getAttributes()) == null) {
            return;
        }
        int attrLength = attributes.getLength();
        if (attrLength == 0) {
            return;
        }
        String nodeName = this.getTagName(node);
        HashMap<String, List<String>> map = null;
        List properties = this.getProperties(nodeName, DomHelper.lookupNamespaceURI((Node)node), true);
        if (properties == null) {
            properties = Collections.EMPTY_LIST;
        }
        int j = 0;
        while (j < attrLength) {
            Node attr = attributes.item(j);
            String attrName = this.getTagName(attr);
            if (attrName != null && !this.isLoadingTag(attrName)) {
                int index = attrName.indexOf(46);
                if (index != -1) {
                    String type = attrName.substring(0, index);
                    String propertyName = attrName.substring(index + 1);
                    if (map == null) {
                        map = new HashMap<String, List<String>>();
                    }
                    this.collectAttachedProperties(type, DomHelper.lookupNamespaceURI((Node)node, (Node)attr), map, true);
                    List attachedProperties = map.get(type);
                    if (attachedProperties == null) {
                        attachedProperties = Collections.EMPTY_LIST;
                    }
                    if (!attachedProperties.contains(propertyName)) {
                        Problem error = this.createProblem(textEditor, node, "Attached Property \"" + propertyName + "\" of \"" + type + "\" doesn't exist", 3);
                        problems.add(error);
                    }
                } else if (!properties.contains(attrName)) {
                    Problem error = this.createProblem(textEditor, node, "Property \"" + attrName + "\" of \"" + nodeName + "\" doesn't exist", 3);
                    problems.add(error);
                }
            }
            ++j;
        }
    }

    private boolean isLoadingTag(String tagName) {
        if (tagName == null || tagName.equals("")) {
            return false;
        }
        if (tagName.indexOf(":") != -1) {
            return true;
        }
        return XMLNS_TAG.endsWith(tagName) || tagName.startsWith(XMLNS_TAG);
    }

    private List<String> getProperties(String nodeName, String namespace, boolean includedEvents) {
        int index = nodeName.indexOf(58);
        String elementName = nodeName.substring(index + 1);
        ArrayList<String> properties = new ArrayList<String>();
        return properties;
    }

    private void collectAttachedProperties(String nodeName, String namespace, HashMap<String, List<String>> map, boolean includedEvents) {
        if (map.containsKey(nodeName)) {
            return;
        }
    }
}

