/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contenttype;

import java.io.IOException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;
import org.eclipse.wst.xml.core.internal.contenttype.AbstractResourceEncodingDetector;
import org.eclipse.wst.xml.core.internal.contenttype.HeadParserToken;
import org.eclipse.wst.xml.core.internal.contenttype.XMLHeadTokenizer;

public class XMLResourceEncodingDetector
extends AbstractResourceEncodingDetector
implements IResourceCharsetDetector {
    private XMLHeadTokenizer fTokenizer;
    private boolean fDeclDetected = false;
    private boolean fInitialWhiteSpace = false;

    private boolean canHandleAsUnicodeStream(String tokenType) {
        boolean canHandleAsUnicodeStream = false;
        if ("UTF83ByteBOM".equals(tokenType)) {
            canHandleAsUnicodeStream = true;
            String enc = "UTF-8";
            this.createEncodingMemento(enc, "detectedStandardUnicodeBytes");
            this.fEncodingMemento.setUTF83ByteBOMUsed(true);
        } else if ("UTF16BE".equals(tokenType) || "UTF16LE".equals(tokenType)) {
            canHandleAsUnicodeStream = true;
            String enc = "UTF-16";
            byte[] bom = "UTF16BE".equals(tokenType) ? IContentDescription.BOM_UTF_16BE : IContentDescription.BOM_UTF_16LE;
            this.createEncodingMemento(enc, "detectedStandardUnicodeBytes");
            this.fEncodingMemento.setUnicodeStream(true);
            this.fEncodingMemento.setUnicodeBOM(bom);
        }
        return canHandleAsUnicodeStream;
    }

    @Override
    public String getSpecDefaultEncoding() {
        return "UTF-8";
    }

    private XMLHeadTokenizer getTokenizer() {
        this.fTokenizer = new XMLHeadTokenizer();
        return this.fTokenizer;
    }

    private boolean isLegalString(String valueTokenType) {
        if (valueTokenType == null) {
            return false;
        }
        return valueTokenType.equals("strval") || valueTokenType.equals("UnDelimitedStringValue") || valueTokenType.equals("InvalidTerminatedStringValue") || valueTokenType.equals("InvalidTermintatedUnDelimitedStringValue");
    }

    @Override
    protected void parseInput() throws IOException {
        XMLHeadTokenizer tokenizer = this.getTokenizer();
        tokenizer.reset(this.fReader);
        HeadParserToken token = null;
        String tokenType = null;
        do {
            String enc;
            if ((tokenType = (token = tokenizer.getNextToken()).getType()) == "XMLDeclStart") {
                this.fDeclDetected = true;
                String declText = token.getText();
                this.fInitialWhiteSpace = !declText.startsWith("<?");
            }
            if (this.canHandleAsUnicodeStream(tokenType) || tokenType != "XMLDelEncoding" || !tokenizer.hasMoreTokens() || !this.isLegalString(tokenType = (token = tokenizer.getNextToken()).getType()) || (enc = token.getText()) == null || enc.length() <= 0) continue;
            this.createEncodingMemento(enc, "foundEncodingInContent");
        } while (tokenizer.hasMoreTokens());
    }

    public boolean isDeclDetected() {
        if (!this.fHeaderParsed) {
            try {
                this.parseInput();
            }
            catch (IOException iOException) {
                this.fDeclDetected = false;
            }
            this.fHeaderParsed = true;
        }
        return this.fDeclDetected;
    }

    public boolean hasInitialWhiteSpace() {
        return this.fInitialWhiteSpace;
    }

    @Override
    protected void resetAll() {
        super.resetAll();
        this.fDeclDetected = false;
        this.fInitialWhiteSpace = false;
    }
}

