/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class IntArrayDialog
extends Dialog {
    private int[] initValue;
    private String[] titles;
    private int[] result;

    public IntArrayDialog(Shell parent, int[] initValue, String[] titles) {
        super(parent);
        this.initValue = initValue;
        this.titles = titles;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.result = new int[this.titles.length];
        if (this.initValue != null) {
            System.arraycopy(this.initValue, 0, this.result, 0, Math.min(this.initValue.length, this.titles.length));
        }
        int i = 0;
        while (i < this.titles.length) {
            this.createItem(composite, this.titles[i], i);
            ++i;
        }
        return composite;
    }

    protected Spinner createItem(Composite parent, String title, final int index) {
        Label label = new Label(parent, 0);
        label.setText(title);
        final Spinner spinner = new Spinner(parent, 2048);
        spinner.setMaximum(9999);
        spinner.setLayoutData((Object)new GridData(768));
        spinner.setSelection(this.result[index]);
        spinner.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IntArrayDialog.this.result[index] = spinner.getSelection();
            }
        });
        label = new Label(parent, 0);
        label.setText("pixels");
        return spinner;
    }

    public int[] getResult() {
        return this.result;
    }
}

