/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.DefaultNamedDomainObjectSet;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.internal.provider.AbstractProvider;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;

public class DefaultTaskCollection<T extends Task>
extends DefaultNamedDomainObjectSet<T>
implements TaskCollection<T> {
    private static final Task.Namer NAMER = new Task.Namer();
    protected final ProjectInternal project;

    public DefaultTaskCollection(Class<T> type, Instantiator instantiator, ProjectInternal project) {
        super(type, instantiator, NAMER);
        this.project = project;
    }

    public DefaultTaskCollection(DefaultTaskCollection<? super T> collection, CollectionFilter<T> filter, Instantiator instantiator, ProjectInternal project) {
        super(collection, filter, instantiator, NAMER);
        this.project = project;
    }

    @Override
    protected <S extends T> DefaultTaskCollection<S> filtered(CollectionFilter<S> filter) {
        return (DefaultTaskCollection)this.getInstantiator().newInstance(DefaultTaskCollection.class, new Object[]{this, filter, this.getInstantiator(), this.project});
    }

    @Override
    public <S extends T> TaskCollection<S> withType(Class<S> type) {
        return this.filtered((CollectionFilter)this.createFilter(type));
    }

    @Override
    public TaskCollection<T> matching(Spec<? super T> spec) {
        return this.filtered(this.createFilter(spec));
    }

    @Override
    public TaskCollection<T> matching(Closure spec) {
        return this.matching((Spec<? super T>)Specs.convertClosureToSpec((Closure)spec));
    }

    public Action<? super T> whenTaskAdded(Action<? super T> action) {
        return this.whenObjectAdded(action);
    }

    public void whenTaskAdded(Closure closure) {
        this.whenObjectAdded(closure);
    }

    @Override
    public String getTypeDisplayName() {
        return "task";
    }

    protected UnknownTaskException createNotFoundException(String name) {
        return new UnknownTaskException(String.format("Task with name '%s' not found in %s.", name, this.project));
    }

    @Override
    public TaskProvider<T> named(String name) throws UnknownTaskException {
        return (TaskProvider)super.named(name);
    }

    @Override
    protected TaskProvider<? extends T> createExistingProvider(String name, T object) {
        TaskInternal taskInternal = (TaskInternal)object;
        TaskIdentity<?> taskIdentity = taskInternal.getTaskIdentity();
        return (TaskProvider)Cast.uncheckedCast((Object)this.getInstantiator().newInstance(ExistingTaskProvider.class, new Object[]{this, object, taskIdentity}));
    }

    public static class ExistingTaskProvider<I extends T>
    extends DefaultTaskProvider<I> {
        private final I task;
        final /* synthetic */ DefaultTaskCollection this$0;

        public ExistingTaskProvider(I task, TaskIdentity<I> identity) {
            this.this$0 = var1_1;
            super(identity);
            this.task = task;
        }

        public void configure(Action<? super I> action) {
            action.execute(this.task);
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        public I getOrNull() {
            return this.task;
        }
    }

    protected abstract class DefaultTaskProvider<I extends Task>
    extends AbstractProvider<I>
    implements Named,
    TaskProvider<I> {
        final TaskIdentity<I> identity;
        boolean removed = false;

        DefaultTaskProvider(TaskIdentity<I> identity) {
            this.identity = identity;
        }

        public String getName() {
            return this.identity.name;
        }

        @Override
        public Class<I> getType() {
            return this.identity.type;
        }

        @Override
        public boolean isPresent() {
            return DefaultTaskCollection.this.findDomainObject(this.identity.name) != null;
        }

        @Override
        public String toString() {
            return String.format("provider(task %s, %s)", this.identity.name, this.identity.type);
        }
    }
}

