/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.AbstractProperty;
import org.gradle.api.internal.provider.ManagedFactories;
import org.gradle.api.internal.provider.MapCollector;
import org.gradle.api.internal.provider.MapCollectors;
import org.gradle.api.internal.provider.MapEntryCollector;
import org.gradle.api.internal.provider.MapPropertyInternal;
import org.gradle.api.internal.provider.MapProviderInternal;
import org.gradle.api.internal.provider.MapSupplier;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValidatingMapEntryCollector;
import org.gradle.api.internal.provider.ValidatingValueCollector;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.Pair;
import org.gradle.internal.evaluation.EvaluationScopeContext;
import org.jetbrains.annotations.Nullable;

public class DefaultMapProperty<K, V>
extends AbstractProperty<Map<K, V>, MapSupplier<K, V>>
implements MapProperty<K, V>,
MapProviderInternal<K, V>,
MapPropertyInternal<K, V> {
    private static final String NULL_KEY_FORBIDDEN_MESSAGE = String.format("Cannot add an entry with a null key to a property of type %s.", Map.class.getSimpleName());
    private static final String NULL_VALUE_FORBIDDEN_MESSAGE = String.format("Cannot add an entry with a null value to a property of type %s.", Map.class.getSimpleName());
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final ValueCollector<K> keyCollector;
    private final MapEntryCollector<K, V> entryCollector;
    private MapSupplier<K, V> defaultValue = this.emptySupplier();

    public DefaultMapProperty(PropertyHost propertyHost, Class<K> keyType, Class<V> valueType) {
        super(propertyHost);
        this.keyType = keyType;
        this.valueType = valueType;
        this.keyCollector = new ValidatingValueCollector<K>(Set.class, keyType, ValueSanitizers.forType(keyType));
        this.entryCollector = new ValidatingMapEntryCollector<K, V>(keyType, valueType, ValueSanitizers.forType(keyType), ValueSanitizers.forType(valueType));
        this.init();
    }

    private void init() {
        this.defaultValue = this.emptySupplier();
        this.init(this.defaultValue, this.noValueSupplier());
    }

    @Override
    public MapSupplier<K, V> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    protected MapSupplier<K, V> getDefaultConvention() {
        return this.noValueSupplier();
    }

    @Override
    protected boolean isDefaultConvention() {
        return this.isNoValueSupplier((MapSupplier)this.getConventionSupplier());
    }

    private MapSupplier<K, V> emptySupplier() {
        return new EmptySupplier();
    }

    private MapSupplier<K, V> noValueSupplier() {
        return (MapSupplier)Cast.uncheckedCast((Object)new NoValueSupplier(ValueSupplier.Value.missing()));
    }

    @Override
    @javax.annotation.Nullable
    public Class<Map<K, V>> getType() {
        return Map.class;
    }

    @Override
    public Class<K> getKeyType() {
        return this.keyType;
    }

    @Override
    public Class<V> getValueType() {
        return this.valueType;
    }

    @Override
    public Class<?> publicType() {
        return MapProperty.class;
    }

    @Override
    public int getFactoryId() {
        return ManagedFactories.MapPropertyManagedFactory.FACTORY_ID;
    }

    public Provider<V> getting(K key) {
        return new EntryProvider(key);
    }

    public MapProperty<K, V> empty() {
        this.setSupplier(this.emptySupplier());
        return this;
    }

    @Override
    public void setFromAnyValue(@javax.annotation.Nullable Object object) {
        if (object == null || object instanceof Map) {
            this.set((Map)object);
        } else if (object instanceof Provider) {
            this.set((Provider)object);
        } else {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", Map.class.getName(), object.getClass().getName()));
        }
    }

    public void set(@javax.annotation.Nullable Map<? extends K, ? extends V> entries) {
        if (entries == null) {
            this.unsetValueAndDefault();
        } else {
            this.setSupplier(this.newCollectingSupplierOf(new MapCollectors.EntriesFromMap<K, V>(entries)));
        }
    }

    public void set(Provider<? extends Map<? extends K, ? extends V>> provider) {
        this.setSupplier(this.newCollectingSupplierOf(new MapCollectors.EntriesFromMapProvider<K, V>(this.checkMapProvider(provider))));
    }

    public MapProperty<K, V> value(@javax.annotation.Nullable Map<? extends K, ? extends V> entries) {
        this.set(entries);
        return this;
    }

    public MapProperty<K, V> value(Provider<? extends Map<? extends K, ? extends V>> provider) {
        this.set(provider);
        return this;
    }

    public void put(K key, V value) {
        this.getConfigurer().put(key, value);
    }

    public void put(K key, Provider<? extends V> providerOfValue) {
        this.getConfigurer().put(key, providerOfValue);
    }

    public void putAll(Map<? extends K, ? extends V> entries) {
        this.getConfigurer().putAll(entries);
    }

    public void putAll(Provider<? extends Map<? extends K, ? extends V>> provider) {
        this.getConfigurer().putAll(provider);
    }

    @Override
    public void insert(K key, Provider<? extends V> providerOfValue) {
        this.withActualValue((Action<Configurer>)((Action)it -> it.put(key, providerOfValue)));
    }

    @Override
    public void insert(K key, V value) {
        this.withActualValue((Action<Configurer>)((Action)it -> it.put(key, value)));
    }

    @Override
    public void insertAll(Provider<? extends Map<? extends K, ? extends V>> provider) {
        this.withActualValue((Action<Configurer>)((Action)it -> it.putAll(provider)));
    }

    @Override
    public void insertAll(Map<? extends K, ? extends V> entries) {
        this.withActualValue((Action<Configurer>)((Action)it -> it.putAll(entries)));
    }

    private void addExplicitCollector(MapCollector<K, V> collector, boolean ignoreAbsent) {
        this.assertCanMutate();
        MapSupplier<K, V> explicitValue = this.getExplicitValue(this.defaultValue);
        this.setSupplier(explicitValue.plus(collector, ignoreAbsent));
    }

    private Configurer getConfigurer() {
        return this.getConfigurer(false);
    }

    private Configurer getConfigurer(boolean ignoreAbsent) {
        return new Configurer(ignoreAbsent);
    }

    protected void withActualValue(Action<Configurer> action) {
        this.setToConventionIfUnset();
        action.execute((Object)this.getConfigurer(true));
    }

    private boolean isNoValueSupplier(MapSupplier<K, V> valueSupplier) {
        return valueSupplier instanceof NoValueSupplier;
    }

    private ProviderInternal<? extends Map<? extends K, ? extends V>> checkMapProvider(@javax.annotation.Nullable Provider<? extends Map<? extends K, ? extends V>> provider) {
        return this.checkMapProvider("value", provider);
    }

    private ProviderInternal<? extends Map<? extends K, ? extends V>> checkMapProvider(String valueKind, @javax.annotation.Nullable Provider<? extends Map<? extends K, ? extends V>> provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Cannot set the %s of a property using a null provider.", valueKind));
        }
        ProviderInternal<Map<K, V>> p = Providers.internal(provider);
        if (p.getType() != null && !Map.class.isAssignableFrom(p.getType())) {
            throw new IllegalArgumentException(String.format("Cannot set the %s of a property of type %s using a provider of type %s.", valueKind, Map.class.getName(), p.getType().getName()));
        }
        if (p instanceof MapProviderInternal) {
            Class providerKeyType = ((MapProviderInternal)p).getKeyType();
            Class providerValueType = ((MapProviderInternal)p).getValueType();
            if (!this.keyType.isAssignableFrom(providerKeyType) || !this.valueType.isAssignableFrom(providerValueType)) {
                throw new IllegalArgumentException(String.format("Cannot set the %s of a property of type %s with key type %s and value type %s using a provider with key type %s and value type %s.", valueKind, Map.class.getName(), this.keyType.getName(), this.valueType.getName(), providerKeyType.getName(), providerValueType.getName()));
            }
        }
        return p;
    }

    public MapProperty<K, V> convention(@javax.annotation.Nullable Map<? extends K, ? extends V> value) {
        if (value == null) {
            this.setConvention(this.noValueSupplier());
        } else {
            this.setConvention(this.newCollectingSupplierOf(new MapCollectors.EntriesFromMap<K, V>(value)));
        }
        return this;
    }

    public MapProperty<K, V> convention(Provider<? extends Map<? extends K, ? extends V>> valueProvider) {
        this.setConvention(this.newCollectingSupplierOf(new MapCollectors.EntriesFromMapProvider(Providers.internal(valueProvider))));
        return this;
    }

    public MapProperty<K, V> unsetConvention() {
        this.discardConvention();
        return this;
    }

    public MapProperty<K, V> unset() {
        return (MapProperty)Cast.uncheckedNonnullCast((Object)super.unset());
    }

    private void unsetValueAndDefault() {
        this.defaultValue = this.noValueSupplier();
        this.unset();
    }

    public void fromState(ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>> value) {
        if (value.isMissing()) {
            this.setSupplier(this.noValueSupplier());
        } else if (value.hasFixedValue()) {
            this.setSupplier(new FixedSupplier((Map)Cast.uncheckedNonnullCast(value.getFixedValue()), (ValueSupplier.SideEffect)Cast.uncheckedCast(value.getSideEffect())));
        } else {
            CollectingSupplier asCollectingProvider = (CollectingSupplier)Cast.uncheckedNonnullCast(value.getChangingValue());
            this.setSupplier(asCollectingProvider);
        }
    }

    public Provider<Set<K>> keySet() {
        return new KeySetProvider();
    }

    public void replace(Transformer<? extends @Nullable Provider<? extends Map<? extends K, ? extends V>>, ? super Provider<Map<K, V>>> transformation) {
        Provider newValue = (Provider)transformation.transform(this.shallowCopy());
        if (newValue != null) {
            this.set(newValue);
        } else {
            this.set((Map)null);
        }
    }

    @Override
    protected String describeContents() {
        return String.format("Map(%s->%s, %s)", this.keyType.getSimpleName(), this.valueType.getSimpleName(), this.describeValue());
    }

    @Override
    protected ValueSupplier.Value<? extends Map<K, V>> calculateValueFrom(EvaluationScopeContext context, MapSupplier<K, V> value, ValueSupplier.ValueConsumer consumer) {
        return value.calculateValue(consumer);
    }

    @Override
    protected MapSupplier<K, V> finalValue(EvaluationScopeContext context, MapSupplier<K, V> value, ValueSupplier.ValueConsumer consumer) {
        ValueSupplier.Value<Map<K, V>> result = value.calculateValue(consumer);
        if (!result.isMissing()) {
            return new FixedSupplier(result.getWithoutSideEffect(), (ValueSupplier.SideEffect)Cast.uncheckedCast(result.getSideEffect()));
        }
        if (result.getPathToOrigin().isEmpty()) {
            return this.noValueSupplier();
        }
        return new NoValueSupplier(result);
    }

    @Override
    protected ValueSupplier.ExecutionTimeValue<? extends Map<K, V>> calculateOwnExecutionTimeValue(EvaluationScopeContext context, MapSupplier<K, V> value) {
        return value.calculateExecutionTimeValue();
    }

    private CollectingSupplier<K, V> newCollectingSupplierOf(MapCollector<K, V> collector) {
        return new CollectingSupplier<K, V>(this.keyCollector, this.entryCollector, collector);
    }

    private static boolean isAbsentIgnoring(MapCollector<?, ?> collector) {
        return collector instanceof AbsentIgnoringCollector;
    }

    private static <K, V> MapCollector<K, V> ignoreAbsentIfNeeded(MapCollector<K, V> collector, boolean ignoreAbsent) {
        if (ignoreAbsent && !DefaultMapProperty.isAbsentIgnoring(collector)) {
            return new AbsentIgnoringCollector(collector);
        }
        return collector;
    }

    private static class CollectingSupplier<K, V>
    extends AbstractMinimalProvider<Map<K, V>>
    implements MapSupplier<K, V> {
        private final ValueCollector<K> keyCollector;
        private final MapEntryCollector<K, V> entryCollector;
        private final List<MapCollector<K, V>> collectors;
        private final int size;

        public CollectingSupplier(ValueCollector<K> keyCollector, MapEntryCollector<K, V> entryCollector, MapCollector<K, V> collector) {
            this(keyCollector, entryCollector, Lists.newArrayList((Object[])new MapCollector[]{collector}), 1);
        }

        public CollectingSupplier(ValueCollector<K> keyCollector, MapEntryCollector<K, V> entryCollector, List<MapCollector<K, V>> collectors, int size) {
            this.keyCollector = keyCollector;
            this.entryCollector = entryCollector;
            this.size = size;
            this.collectors = collectors;
        }

        @Override
        protected ValueSupplier.Value<? extends Map<K, V>> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            return this.calculateValue(consumer);
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            for (MapCollector collector : Lists.reverse(this.getCollectors())) {
                if (!collector.calculatePresence(consumer)) {
                    return false;
                }
                if (!(collector instanceof AbsentIgnoringCollector)) continue;
                return true;
            }
            return true;
        }

        @Override
        @javax.annotation.Nullable
        public Class<Map<K, V>> getType() {
            return Map.class;
        }

        @Override
        public ValueSupplier.Value<? extends Set<K>> calculateKeys(ValueSupplier.ValueConsumer consumer) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            ValueSupplier.Value<Void> compositeResult = ValueSupplier.Value.present();
            for (MapCollector<K, V> collector : this.getCollectors()) {
                ValueSupplier.Value<Void> result = collector.collectKeys(consumer, this.keyCollector, (ImmutableCollection.Builder<K>)builder);
                if (result.isMissing()) {
                    builder = ImmutableSet.builder();
                    compositeResult = result;
                    continue;
                }
                if (compositeResult.isMissing()) {
                    if (DefaultMapProperty.isAbsentIgnoring(collector)) {
                        compositeResult = result;
                        continue;
                    }
                    builder = ImmutableSet.builder();
                    continue;
                }
                compositeResult = compositeResult.withSideEffect(ValueSupplier.SideEffect.fixedFrom(result));
            }
            if (compositeResult.isMissing()) {
                return compositeResult.asType();
            }
            return ValueSupplier.Value.of(ImmutableSet.copyOf((Collection)builder.build())).withSideEffect(ValueSupplier.SideEffect.fixedFrom(compositeResult));
        }

        @Override
        public ValueSupplier.Value<? extends Map<K, V>> calculateValue(ValueSupplier.ValueConsumer consumer) {
            LinkedHashMap entries = new LinkedHashMap();
            ValueSupplier.Value<Void> compositeResult = ValueSupplier.Value.present();
            for (MapCollector<K, V> collector : this.getCollectors()) {
                ValueSupplier.Value<Void> result = collector.collectEntries(consumer, this.entryCollector, entries);
                if (result.isMissing()) {
                    entries.clear();
                    compositeResult = result;
                    continue;
                }
                if (compositeResult.isMissing()) {
                    if (DefaultMapProperty.isAbsentIgnoring(collector)) {
                        compositeResult = result;
                        continue;
                    }
                    entries.clear();
                    continue;
                }
                compositeResult = compositeResult.withSideEffect(ValueSupplier.SideEffect.fixedFrom(result));
            }
            if (compositeResult.isMissing()) {
                return compositeResult.asType();
            }
            return ValueSupplier.Value.of(ImmutableMap.copyOf(entries)).withSideEffect(ValueSupplier.SideEffect.fixedFrom(compositeResult));
        }

        @Override
        public MapSupplier<K, V> plus(MapCollector<K, V> addedCollector, boolean ignoreAbsent) {
            Preconditions.checkState((this.collectors.size() == this.size ? 1 : 0) != 0);
            this.collectors.add(DefaultMapProperty.ignoreAbsentIfNeeded(addedCollector, ignoreAbsent));
            return new CollectingSupplier<K, V>(this.keyCollector, this.entryCollector, this.collectors, this.size + 1);
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Map<K, V>> calculateExecutionTimeValue() {
            List<Pair<MapCollector<K, V>, ValueSupplier.ExecutionTimeValue<Map<K, V>>>> collectorsWithValues = this.collectExecutionTimeValues();
            if (collectorsWithValues.isEmpty()) {
                return ValueSupplier.ExecutionTimeValue.missing();
            }
            List<ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>>> executionTimeValues = collectorsWithValues.stream().map(Pair::getRight).collect(Collectors.toList());
            ValueSupplier.ExecutionTimeValue<Map<K, V>> fixedOrMissing = this.fixedOrMissingValueOf(executionTimeValues);
            if (fixedOrMissing != null) {
                return fixedOrMissing;
            }
            return ValueSupplier.ExecutionTimeValue.changingValue(new CollectingSupplier<K, V>(this.keyCollector, this.entryCollector, collectorsWithValues.stream().map((? super T pair) -> {
                AbsentIgnoringCollector elements = this.toCollector((ValueSupplier.ExecutionTimeValue)pair.getRight());
                return DefaultMapProperty.isAbsentIgnoring((MapCollector)pair.getLeft()) ? new AbsentIgnoringCollector(elements) : elements;
            }).collect(Collectors.toList()), collectorsWithValues.size()));
        }

        private MapCollector<K, V> toCollector(ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>> value) {
            Preconditions.checkArgument((!value.isMissing() ? 1 : 0) != 0, (Object)"Cannot get a collector for the missing value");
            if (value.isChangingValue() || value.hasChangingContent() || value.getSideEffect() != null) {
                return new MapCollectors.EntriesFromMapProvider(value.toProvider());
            }
            return new MapCollectors.EntriesFromMap<K, V>(value.getFixedValue());
        }

        @javax.annotation.Nullable
        private ValueSupplier.ExecutionTimeValue<Map<K, V>> fixedOrMissingValueOf(List<ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>>> values) {
            boolean fixed = true;
            boolean changingContent = false;
            for (ValueSupplier.ExecutionTimeValue<Map<K, V>> value : values) {
                if (value.isMissing()) {
                    return ValueSupplier.ExecutionTimeValue.missing();
                }
                if (value.isChangingValue()) {
                    fixed = false;
                    continue;
                }
                if (!value.hasChangingContent()) continue;
                changingContent = true;
            }
            if (fixed) {
                ValueSupplier.SideEffectBuilder sideEffectBuilder = ValueSupplier.SideEffect.builder();
                ImmutableMap<K, V> entries = this.collectEntries(values, sideEffectBuilder);
                return this.maybeChangingContent(ValueSupplier.ExecutionTimeValue.fixedValue(entries), changingContent).withSideEffect(sideEffectBuilder.build());
            }
            return null;
        }

        @Nonnull
        private List<Pair<MapCollector<K, V>, ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>>>> collectExecutionTimeValues() {
            ArrayList executionTimeValues = new ArrayList();
            ArrayList<Pair> candidates = new ArrayList<Pair>();
            for (MapCollector collector : Lists.reverse(this.getCollectors())) {
                ValueSupplier.ExecutionTimeValue result = collector.calculateExecutionTimeValue();
                if (result.isMissing()) {
                    return Lists.reverse(executionTimeValues);
                }
                if (DefaultMapProperty.isAbsentIgnoring(collector)) {
                    executionTimeValues.addAll(candidates);
                    executionTimeValues.add(Pair.of((Object)collector, result));
                    candidates.clear();
                    continue;
                }
                candidates.add(Pair.of((Object)collector, result));
            }
            executionTimeValues.addAll(candidates);
            return Lists.reverse(executionTimeValues);
        }

        private ImmutableMap<K, V> collectEntries(List<ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>>> values, ValueSupplier.SideEffectBuilder<? super Map<K, V>> sideEffectBuilder) {
            LinkedHashMap entries = new LinkedHashMap();
            for (ValueSupplier.ExecutionTimeValue<Map<K, V>> value : values) {
                this.entryCollector.addAll(value.getFixedValue().entrySet(), entries);
                sideEffectBuilder.add(ValueSupplier.SideEffect.fixedFrom(value));
            }
            return ImmutableMap.copyOf(entries);
        }

        private List<MapCollector<K, V>> getCollectors() {
            return this.collectors.subList(0, this.size);
        }

        private ValueSupplier.ExecutionTimeValue<Map<K, V>> maybeChangingContent(ValueSupplier.ExecutionTimeValue<Map<K, V>> value, boolean changingContent) {
            return changingContent ? value.withChangingContent() : value;
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            final List producers = this.getCollectors().stream().map(ValueSupplier::getProducer).collect(Collectors.toList());
            return new ValueSupplier.ValueProducer(){

                @Override
                public void visitProducerTasks(Action<? super Task> visitor) {
                    producers.forEach(c -> c.visitProducerTasks(visitor));
                }

                @Override
                public boolean isKnown() {
                    return producers.stream().anyMatch(ValueSupplier.ValueProducer::isKnown);
                }

                @Override
                public void visitDependencies(TaskDependencyResolveContext context) {
                    producers.forEach(c -> c.visitDependencies(context));
                }

                @Override
                public void visitContentProducerTasks(Action<? super Task> visitor) {
                    producers.forEach(c -> c.visitContentProducerTasks(visitor));
                }
            };
        }

        @Override
        protected String toStringNoReentrance() {
            StringBuilder sb = new StringBuilder();
            this.getCollectors().forEach(collector -> {
                if (sb.length() > 0) {
                    sb.append(" + ");
                }
                sb.append(collector.toString());
            });
            return sb.toString();
        }
    }

    private class EmptySupplier
    implements MapSupplier<K, V> {
        private EmptySupplier() {
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<? extends Map<K, V>> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(ImmutableMap.of());
        }

        @Override
        public ValueSupplier.Value<? extends Set<K>> calculateKeys(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(ImmutableSet.of());
        }

        @Override
        public MapSupplier<K, V> plus(MapCollector<K, V> collector, boolean ignoreAbsent) {
            return DefaultMapProperty.this.newCollectingSupplierOf(DefaultMapProperty.ignoreAbsentIfNeeded(collector, ignoreAbsent));
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Map<K, V>> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(ImmutableMap.of());
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.noProducer();
        }

        public String toString() {
            return "{}";
        }
    }

    private class NoValueSupplier
    implements MapSupplier<K, V> {
        private final ValueSupplier.Value<? extends Map<K, V>> value;

        public NoValueSupplier(ValueSupplier.Value<? extends Map<K, V>> value) {
            this.value = value.asType();
            assert (value.isMissing());
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return false;
        }

        @Override
        public ValueSupplier.Value<? extends Map<K, V>> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return this.value;
        }

        @Override
        public ValueSupplier.Value<? extends Set<K>> calculateKeys(ValueSupplier.ValueConsumer consumer) {
            return this.value.asType();
        }

        @Override
        public MapSupplier<K, V> plus(MapCollector<K, V> collector, boolean ignoreAbsent) {
            return ignoreAbsent ? DefaultMapProperty.this.newCollectingSupplierOf(DefaultMapProperty.ignoreAbsentIfNeeded(collector, ignoreAbsent)) : this;
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Map<K, V>> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.missing();
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private class EntryProvider
    extends AbstractMinimalProvider<V> {
        private final K key;

        public EntryProvider(K key) {
            this.key = key;
        }

        @Override
        @javax.annotation.Nullable
        public Class<V> getType() {
            return DefaultMapProperty.this.valueType;
        }

        @Override
        protected ValueSupplier.Value<? extends V> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            ValueSupplier.Value result = DefaultMapProperty.this.calculateOwnValue(consumer);
            if (result.isMissing()) {
                return result.asType();
            }
            ValueSupplier.Value resultValue = ValueSupplier.Value.ofNullable(((Map)result.getWithoutSideEffect()).get(this.key));
            return resultValue.withSideEffect(ValueSupplier.SideEffect.fixedFrom(result));
        }
    }

    private class Configurer {
        private final boolean ignoreAbsent;

        public Configurer(boolean ignoreAbsent) {
            this.ignoreAbsent = ignoreAbsent;
        }

        void addCollector(MapCollector<K, V> collector) {
            DefaultMapProperty.this.addExplicitCollector(collector, this.ignoreAbsent);
        }

        public void put(K key, V value) {
            Preconditions.checkNotNull(key, (Object)NULL_KEY_FORBIDDEN_MESSAGE);
            Preconditions.checkNotNull(value, (Object)NULL_VALUE_FORBIDDEN_MESSAGE);
            this.addCollector(new MapCollectors.SingleEntry(key, value));
        }

        public void put(K key, Provider<? extends V> providerOfValue) {
            Preconditions.checkNotNull(key, (Object)NULL_KEY_FORBIDDEN_MESSAGE);
            Preconditions.checkNotNull(providerOfValue, (Object)NULL_VALUE_FORBIDDEN_MESSAGE);
            ProviderInternal p = Providers.internal(providerOfValue);
            if (p.getType() != null && !DefaultMapProperty.this.valueType.isAssignableFrom(p.getType())) {
                throw new IllegalArgumentException(String.format("Cannot add an entry to a property of type %s with values of type %s using a provider of type %s.", Map.class.getName(), DefaultMapProperty.this.valueType.getName(), p.getType().getName()));
            }
            this.addCollector(new MapCollectors.EntryWithValueFromProvider(key, Providers.internal(providerOfValue)));
        }

        public void putAll(Map<? extends K, ? extends V> entries) {
            this.addCollector(new MapCollectors.EntriesFromMap(entries));
        }

        public void putAll(Provider<? extends Map<? extends K, ? extends V>> provider) {
            this.addCollector(new MapCollectors.EntriesFromMapProvider(DefaultMapProperty.this.checkMapProvider(provider)));
        }
    }

    private class FixedSupplier
    implements MapSupplier<K, V> {
        private final Map<K, V> entries;
        private final ValueSupplier.SideEffect<? super Map<K, V>> sideEffect;

        public FixedSupplier(@javax.annotation.Nullable Map<K, V> entries, ValueSupplier.SideEffect<? super Map<K, V>> sideEffect) {
            this.entries = entries;
            this.sideEffect = sideEffect;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<? extends Map<K, V>> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(this.entries).withSideEffect(this.sideEffect);
        }

        @Override
        public ValueSupplier.Value<? extends Set<K>> calculateKeys(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(this.entries.keySet());
        }

        @Override
        public MapSupplier<K, V> plus(MapCollector<K, V> collector, boolean ignoreAbsent) {
            return DefaultMapProperty.this.newCollectingSupplierOf(new FixedValueCollector(this.entries, this.sideEffect)).plus(collector, ignoreAbsent);
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Map<K, V>> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(this.entries).withSideEffect(this.sideEffect);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        public String toString() {
            return this.entries.toString();
        }
    }

    private class KeySetProvider
    extends AbstractMinimalProvider<Set<K>> {
        private KeySetProvider() {
        }

        @Override
        @javax.annotation.Nullable
        public Class<Set<K>> getType() {
            return Set.class;
        }

        @Override
        protected ValueSupplier.Value<? extends Set<K>> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            try (EvaluationScopeContext context = DefaultMapProperty.this.openScope();){
                DefaultMapProperty.this.beforeRead(context, consumer);
                ValueSupplier.Value value = ((MapSupplier)DefaultMapProperty.this.getSupplier(context)).calculateKeys(consumer);
                return value;
            }
        }
    }

    private static class AbsentIgnoringCollector<K, V>
    implements MapCollector<K, V> {
        private final MapCollector<K, V> delegate;

        private AbsentIgnoringCollector(MapCollector<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, MapEntryCollector<K, V> collector, Map<K, V> dest) {
            LinkedHashMap candidates = new LinkedHashMap();
            ValueSupplier.Value<Void> value = this.delegate.collectEntries(consumer, collector, candidates);
            if (value.isMissing()) {
                return ValueSupplier.Value.present();
            }
            dest.putAll(candidates);
            return ValueSupplier.Value.present().withSideEffect(ValueSupplier.SideEffect.fixedFrom(value));
        }

        @Override
        public ValueSupplier.Value<Void> collectKeys(ValueSupplier.ValueConsumer consumer, ValueCollector<K> collector, ImmutableCollection.Builder<K> dest) {
            ImmutableSet.Builder candidateKeys = ImmutableSet.builder();
            ValueSupplier.Value<Void> value = this.delegate.collectKeys(consumer, collector, (ImmutableCollection.Builder<K>)candidateKeys);
            if (value.isMissing()) {
                return ValueSupplier.Value.present();
            }
            dest.addAll((Iterable)candidateKeys.build());
            return value;
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>> calculateExecutionTimeValue() {
            ValueSupplier.ExecutionTimeValue<Map<K, V>> executionTimeValue = this.delegate.calculateExecutionTimeValue();
            return executionTimeValue.isMissing() ? ValueSupplier.ExecutionTimeValue.fixedValue(ImmutableMap.of()) : executionTimeValue;
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return this.delegate.getProducer();
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }
    }

    private static class FixedValueCollector<K, V>
    implements MapCollector<K, V> {
        @javax.annotation.Nullable
        private final ValueSupplier.SideEffect<? super Map<K, V>> sideEffect;
        private final Map<K, V> entries;

        private FixedValueCollector(Map<K, V> entries, @javax.annotation.Nullable ValueSupplier.SideEffect<? super Map<K, V>> sideEffect) {
            this.entries = entries;
            this.sideEffect = sideEffect;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, MapEntryCollector<K, V> collector, Map<K, V> dest) {
            collector.addAll(this.entries.entrySet(), dest);
            return this.sideEffect != null ? ValueSupplier.Value.present().withSideEffect(ValueSupplier.SideEffect.fixed(this.entries, this.sideEffect)) : ValueSupplier.Value.present();
        }

        @Override
        public ValueSupplier.Value<Void> collectKeys(ValueSupplier.ValueConsumer consumer, ValueCollector<K> collector, ImmutableCollection.Builder<K> dest) {
            collector.addAll(this.entries.keySet(), dest);
            return ValueSupplier.Value.present();
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends Map<? extends K, ? extends V>> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(this.entries).withSideEffect(this.sideEffect);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        public String toString() {
            return this.entries.toString();
        }
    }
}

