/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.commands;

import java.util.Enumeration;
import megamek.client.Client;
import megamek.client.commands.ClientCommand;
import megamek.client.ui.IClientCommandHandler;

public class HelpCommand
extends ClientCommand {
    private IClientCommandHandler cmdHandler;

    public HelpCommand(Client client) {
        super(client, "help", "Lists all of the commands available, or gives help on a specific command.  Usage: #help [command]");
        this.cmdHandler = client;
    }

    public String run(String[] stringArray) {
        if (stringArray.length == 1) {
            return "Type #help [command] for help on a specific command.  Commands available: " + this.commandList();
        }
        ClientCommand clientCommand = this.cmdHandler.getCommand(stringArray[1]);
        if (clientCommand == null) {
            return "Command \"" + stringArray[1] + "\" not recognized.  Commands available: " + this.commandList();
        }
        return "#" + clientCommand.getName() + " : " + clientCommand.getHelp();
    }

    private String commandList() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<String> enumeration = this.cmdHandler.getAllCommandNames();
        while (enumeration.hasMoreElements()) {
            ClientCommand clientCommand = this.cmdHandler.getCommand(enumeration.nextElement());
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(clientCommand.getName());
        }
        return stringBuffer.toString();
    }
}

