/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListener;
import megamek.client.ui.AWT.AlertDialog;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.DoneButtoned;
import megamek.client.ui.AWT.MineDensityDialog;
import megamek.client.ui.AWT.SeaMineDepthDialog;
import megamek.client.ui.AWT.StatusBarPhaseDisplay;
import megamek.client.ui.AWT.VibrabombSettingDialog;
import megamek.client.ui.Messages;
import megamek.common.Coords;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Minefield;
import megamek.common.Player;
import megamek.common.event.GameListener;
import megamek.common.event.GameTurnChangeEvent;

public class DeployMinefieldDisplay
extends StatusBarPhaseDisplay
implements BoardViewListener,
ActionListener,
DoneButtoned,
KeyListener,
GameListener {
    private static final long serialVersionUID = 1471981663393324556L;
    public static final String DEPLOY_MINE_CONV = "deployMineConv";
    public static final String DEPLOY_MINE_COM = "deployMineCom";
    public static final String DEPLOY_MINE_VIBRA = "deployMineVibra";
    public static final String DEPLOY_MINE_ACTIVE = "deployMineActive";
    public static final String DEPLOY_MINE_INFERNO = "deployMineInferno";
    public static final String REMOVE_MINES = "removeMines";
    public ClientGUI clientgui;
    private Client client;
    private Panel panButtons;
    private Button butC;
    private Button butM;
    private Button butV;
    private Button butA;
    private Button butI;
    private Button butRemove;
    private Button butUnload;
    private Button butDone;
    private boolean deployM = false;
    private boolean deployC = false;
    private boolean deployV = false;
    private boolean deployA = false;
    private boolean deployI = false;
    private boolean remove = false;
    private Player p;
    private Vector<Minefield> deployedMinefields = new Vector();

    public DeployMinefieldDisplay(ClientGUI clientGUI) {
        this.clientgui = clientGUI;
        this.client = clientGUI.getClient();
        this.client.game.addGameListener(this);
        this.setupStatusBar(Messages.getString("DeployMinefieldDisplay.waitingForDeployMinefieldPhase"));
        this.p = this.client.getLocalPlayer();
        this.butM = new Button(Messages.getString("DeploymentDisplay.buttonMinefield", new Object[]{new Integer(this.p.getNbrMFConventional())}));
        this.butM.addActionListener(this);
        this.butM.setActionCommand(DEPLOY_MINE_CONV);
        this.butM.setEnabled(false);
        this.butC = new Button(Messages.getString("DeploymentDisplay.buttonCommand", new Object[]{new Integer(this.p.getNbrMFCommand())}));
        this.butC.addActionListener(this);
        this.butC.setActionCommand(DEPLOY_MINE_COM);
        this.butC.setEnabled(false);
        this.butUnload = new Button(".");
        this.butUnload.addActionListener(this);
        this.butUnload.setEnabled(false);
        this.butV = new Button(Messages.getString("DeploymentDisplay.buttonVibrabomb", new Object[]{new Integer(this.p.getNbrMFVibra())}));
        this.butV.addActionListener(this);
        this.butV.setActionCommand(DEPLOY_MINE_VIBRA);
        this.butV.setEnabled(false);
        this.butA = new Button(Messages.getString("DeploymentDisplay.buttonActive", new Object[]{new Integer(this.p.getNbrMFActive())}));
        this.butA.addActionListener(this);
        this.butA.setActionCommand(DEPLOY_MINE_ACTIVE);
        this.butA.setEnabled(false);
        this.butI = new Button(Messages.getString("DeploymentDisplay.buttonInferno", new Object[]{new Integer(this.p.getNbrMFInferno())}));
        this.butI.addActionListener(this);
        this.butI.setActionCommand(DEPLOY_MINE_INFERNO);
        this.butI.setEnabled(false);
        this.butRemove = new Button(Messages.getString("DeploymentDisplay.buttonRemove"));
        this.butRemove.addActionListener(this);
        this.butRemove.setActionCommand(REMOVE_MINES);
        this.butRemove.setEnabled(false);
        this.butDone = new Button(Messages.getString("DeployMinefieldDisplay.Done"));
        this.butDone.addActionListener(this);
        this.butDone.setEnabled(false);
        this.panButtons = new Panel();
        this.panButtons.setLayout(new GridLayout(0, 8));
        this.panButtons.add(this.butM);
        this.panButtons.add(this.butC);
        this.panButtons.add(this.butV);
        this.panButtons.add(this.butA);
        this.panButtons.add(this.butI);
        this.panButtons.add(this.butRemove);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.panStatus, gridBagLayout, gridBagConstraints);
        clientGUI.bv.addKeyListener(this);
        this.addKeyListener(this);
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        component.addKeyListener(this);
    }

    private void beginMyTurn() {
        this.p = this.client.getLocalPlayer();
        this.setConventionalEnabled(this.p.getNbrMFConventional());
        this.setCommandEnabled(this.p.getNbrMFCommand());
        this.setVibrabombEnabled(this.p.getNbrMFVibra());
        this.setActiveEnabled(this.p.getNbrMFActive());
        this.setInfernoEnabled(this.p.getNbrMFInferno());
        this.setRemoveMineEnabled(true);
        if (!this.p.hasMinefields()) {
            this.butDone.setEnabled(true);
        }
    }

    private void endMyTurn() {
        this.disableButtons();
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().highlight(null);
        this.clientgui.getBoardView().cursor(null);
    }

    private void disableButtons() {
        this.setConventionalEnabled(0);
        this.setCommandEnabled(0);
        this.setVibrabombEnabled(0);
        this.setActiveEnabled(0);
        this.setInfernoEnabled(0);
        this.setRemoveMineEnabled(false);
        this.butDone.setEnabled(false);
        this.butUnload.setEnabled(false);
    }

    private void deployMinefield(Coords coords) {
        if (!this.client.game.getBoard().contains(coords)) {
            return;
        }
        boolean bl = false;
        IHex iHex = this.client.game.getBoard().getHex(coords);
        if (iHex.containsTerrain(2)) {
            bl = true;
        }
        if (this.remove) {
            if (!this.client.game.containsMinefield(coords)) {
                return;
            }
            Enumeration<Minefield> enumeration = this.client.game.getMinefields(coords).elements();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (enumeration.hasMoreElements()) {
                Minefield minefield = enumeration.nextElement();
                if (minefield.getPlayerId() != this.client.getLocalPlayer().getId()) continue;
                this.butDone.setEnabled(false);
                arrayList.add(minefield);
                this.deployedMinefields.removeElement(minefield);
                if (minefield.getType() == 0) {
                    this.p.setNbrMFConventional(this.p.getNbrMFConventional() + 1);
                    continue;
                }
                if (minefield.getType() == 1) {
                    this.p.setNbrMFCommand(this.p.getNbrMFCommand() + 1);
                    continue;
                }
                if (minefield.getType() == 2) {
                    this.p.setNbrMFVibra(this.p.getNbrMFVibra() + 1);
                    continue;
                }
                if (minefield.getType() == 3) {
                    this.p.setNbrMFActive(this.p.getNbrMFActive() + 1);
                    continue;
                }
                if (minefield.getType() != 5) continue;
                this.p.setNbrMFInferno(this.p.getNbrMFInferno() + 1);
            }
            for (Minefield minefield : arrayList) {
                this.client.game.removeMinefield(minefield);
            }
        } else {
            Minefield minefield;
            Enumeration<Minefield> enumeration = this.client.game.getMinefields(coords).elements();
            while (enumeration.hasMoreElements()) {
                minefield = enumeration.nextElement();
                if (!(this.deployM && minefield.getType() == 0 || this.deployC && minefield.getType() == 1 || this.deployV && minefield.getType() == 2 || this.deployA && minefield.getType() == 3) && (!this.deployI || minefield.getType() != 5)) continue;
                new AlertDialog(this.clientgui.frame, Messages.getString("DeployMinefieldDisplay.IllegalPlacement"), Messages.getString("DeployMinefieldDisplay.DuplicateMinefield")).setVisible(true);
                return;
            }
            if (bl && !this.deployM && !this.deployI) {
                new AlertDialog(this.clientgui.frame, Messages.getString("DeployMinefieldDisplay.IllegalPlacement"), Messages.getString("DeployMinefieldDisplay.WaterPlacement")).setVisible(true);
                return;
            }
            int n = 0;
            if (this.deployM) {
                if (bl) {
                    SeaMineDepthDialog dialog = new SeaMineDepthDialog(this.clientgui.frame, iHex.depth());
                    dialog.setVisible(true);
                    n = dialog.getDepth();
                }
                MineDensityDialog mineDensityDialog = new MineDensityDialog(this.clientgui.frame);
                mineDensityDialog.setVisible(true);
                minefield = Minefield.createMinefield(coords, this.p.getId(), 0, mineDensityDialog.getDensity(), bl, n);
                this.p.setNbrMFConventional(this.p.getNbrMFConventional() - 1);
            } else if (this.deployC) {
                MineDensityDialog mineDensityDialog = new MineDensityDialog(this.clientgui.frame);
                mineDensityDialog.setVisible(true);
                minefield = Minefield.createMinefield(coords, this.p.getId(), 1, mineDensityDialog.getDensity(), bl, n);
                this.p.setNbrMFCommand(this.p.getNbrMFCommand() - 1);
            } else if (this.deployA) {
                MineDensityDialog mineDensityDialog = new MineDensityDialog(this.clientgui.frame);
                mineDensityDialog.setVisible(true);
                minefield = Minefield.createMinefield(coords, this.p.getId(), 3, mineDensityDialog.getDensity());
                this.p.setNbrMFActive(this.p.getNbrMFActive() - 1);
            } else if (this.deployI) {
                MineDensityDialog mineDensityDialog = new MineDensityDialog(this.clientgui.frame);
                mineDensityDialog.setVisible(true);
                minefield = Minefield.createMinefield(coords, this.p.getId(), 5, mineDensityDialog.getDensity(), bl, n);
                this.p.setNbrMFInferno(this.p.getNbrMFInferno() - 1);
            } else if (this.deployV) {
                MineDensityDialog mineDensityDialog = new MineDensityDialog(this.clientgui.frame);
                mineDensityDialog.setVisible(true);
                VibrabombSettingDialog vibrabombSettingDialog = new VibrabombSettingDialog(this.clientgui.frame);
                vibrabombSettingDialog.setVisible(true);
                minefield = Minefield.createMinefield(coords, this.p.getId(), 2, mineDensityDialog.getDensity(), vibrabombSettingDialog.getSetting());
                this.p.setNbrMFVibra(this.p.getNbrMFVibra() - 1);
            } else {
                return;
            }
            this.client.game.addMinefield(minefield);
            this.deployedMinefields.addElement(minefield);
            this.clientgui.bv.refreshDisplayables();
        }
        if (this.p.getNbrMFConventional() == 0 && this.p.getNbrMFCommand() == 0 && this.p.getNbrMFVibra() == 0 && this.p.getNbrMFActive() == 0 && this.p.getNbrMFInferno() == 0) {
            this.butDone.setEnabled(true);
        }
        this.setConventionalEnabled(this.p.getNbrMFConventional());
        this.setCommandEnabled(this.p.getNbrMFCommand());
        this.setVibrabombEnabled(this.p.getNbrMFVibra());
        this.setActiveEnabled(this.p.getNbrMFActive());
        this.setInfernoEnabled(this.p.getNbrMFInferno());
        if (this.p.getNbrMFConventional() == 0) {
            this.deployM = false;
        }
        if (this.p.getNbrMFCommand() == 0) {
            this.deployC = false;
        }
        if (this.p.getNbrMFVibra() == 0) {
            this.deployV = false;
        }
        if (this.p.getNbrMFActive() == 0) {
            this.deployA = false;
        }
        if (this.p.getNbrMFInferno() == 0) {
            this.deployI = false;
        }
    }

    public void hexMoused(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (boardViewEvent.getType() != 2) {
            return;
        }
        if (!this.client.isMyTurn() || (boardViewEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        this.clientgui.getBoardView().select(boardViewEvent.getCoords());
        this.deployMinefield(boardViewEvent.getCoords());
    }

    public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        this.endMyTurn();
        if (this.client.isMyTurn()) {
            this.beginMyTurn();
            this.setStatusBarText(Messages.getString("DeployMinefieldDisplay.its_your_turn"));
        } else {
            this.setStatusBarText(Messages.getString("DeployMinefieldDisplay.its_others_turn", new Object[]{gameTurnChangeEvent.getPlayer().getName()}));
        }
    }

    public void gamePhaseChange(GameTurnChangeEvent gameTurnChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && this.client.game.getPhase() != IGame.Phase.PHASE_DEPLOY_MINEFIELDS) {
            this.endMyTurn();
        }
        if (this.client.game.getPhase() == IGame.Phase.PHASE_DEPLOY_MINEFIELDS) {
            this.setStatusBarText(Messages.getString("DeployMinefieldDisplay.waitingForDeploymentPhase"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.statusBarActionPerformed(actionEvent, this.client)) {
            return;
        }
        if (!this.client.isMyTurn()) {
            return;
        }
        if (actionEvent.getSource().equals(this.butDone)) {
            this.endMyTurn();
            this.client.sendDeployMinefields(this.deployedMinefields);
            this.client.sendPlayerInfo();
        }
        if (actionEvent.getActionCommand().equals(DEPLOY_MINE_CONV)) {
            this.deployM = true;
            this.deployC = false;
            this.deployV = false;
            this.deployA = false;
            this.deployI = false;
            this.remove = false;
        }
        if (actionEvent.getActionCommand().equals(DEPLOY_MINE_COM)) {
            this.deployM = false;
            this.deployC = true;
            this.deployV = false;
            this.deployA = false;
            this.deployI = false;
            this.remove = false;
        }
        if (actionEvent.getActionCommand().equals(DEPLOY_MINE_VIBRA)) {
            this.deployM = false;
            this.deployC = false;
            this.deployV = true;
            this.deployA = false;
            this.deployI = false;
            this.remove = false;
        }
        if (actionEvent.getActionCommand().equals(DEPLOY_MINE_ACTIVE)) {
            this.deployM = false;
            this.deployC = false;
            this.deployV = false;
            this.deployA = true;
            this.deployI = false;
            this.remove = false;
        }
        if (actionEvent.getActionCommand().equals(DEPLOY_MINE_INFERNO)) {
            this.deployM = false;
            this.deployC = false;
            this.deployV = false;
            this.deployA = false;
            this.deployI = true;
            this.remove = false;
        }
        if (actionEvent.getActionCommand().equals(REMOVE_MINES)) {
            this.deployM = false;
            this.deployC = false;
            this.deployV = false;
            this.deployA = false;
            this.deployI = false;
            this.remove = true;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void setConventionalEnabled(int n) {
        this.butM.setLabel(Messages.getString("DeploymentDisplay.buttonMinefield", new Object[]{new Integer(n)}));
        this.butM.setEnabled(n > 0);
        this.clientgui.getMenuBar().setDeployConventionalEnabled(n);
    }

    private void setCommandEnabled(int n) {
        this.butC.setLabel(Messages.getString("DeploymentDisplay.buttonCommand", new Object[]{new Integer(n)}));
        this.butC.setEnabled(n > 0);
        this.clientgui.getMenuBar().setDeployCommandEnabled(n);
    }

    private void setVibrabombEnabled(int n) {
        this.butV.setLabel(Messages.getString("DeploymentDisplay.buttonVibrabomb", new Object[]{new Integer(n)}));
        this.butV.setEnabled(n > 0);
        this.clientgui.getMenuBar().setDeployVibrabombEnabled(n);
    }

    private void setActiveEnabled(int n) {
        this.butA.setLabel(Messages.getString("DeploymentDisplay.buttonActive", new Object[]{new Integer(n)}));
        this.butA.setEnabled(n > 0);
        this.clientgui.getMenuBar().setDeployActiveEnabled(n);
    }

    private void setInfernoEnabled(int n) {
        this.butI.setLabel(Messages.getString("DeploymentDisplay.buttonInferno", new Object[]{new Integer(n)}));
        this.butI.setEnabled(n > 0);
        this.clientgui.getMenuBar().setDeployInfernoEnabled(n);
    }

    private void setRemoveMineEnabled(boolean bl) {
        this.butRemove.setEnabled(bl);
    }

    public Button getDoneButton() {
        return this.butDone;
    }

    public void removeAllListeners() {
        this.client.game.removeGameListener(this);
        this.clientgui.getBoardView().removeBoardViewListener(this);
    }
}

