/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import megamek.client.ui.AWT.boardview3d.BoardModel;
import megamek.client.ui.AWT.boardview3d.C;
import megamek.client.ui.AWT.boardview3d.HexModel;
import megamek.common.Coords;
import megamek.common.IHex;

class CursorModel
extends HexModel {
    public CursorModel(Color3f color3f) {
        this.setTransform(new Transform3D(C.nullRot, new Vector3d(), 1.0));
        this.setCapability(18);
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(color3f, 2));
        appearance.setCapability(9);
        appearance.setLineAttributes(C.defLine);
        Shape3D shape3D = new Shape3D((Geometry)border, appearance);
        shape3D.setAppearance(appearance);
        this.addChild((Node)shape3D);
    }

    public void setColor(Color3f color3f) {
        ((Shape3D)this.getChild(0)).getAppearance().setColoringAttributes(new ColoringAttributes(color3f, 2));
    }

    public void move(Coords coords, IHex iHex) {
        if (coords == null || iHex == null) {
            this.hide();
            return;
        }
        Vector3d vector3d = new Vector3d((Tuple3d)BoardModel.getHexLocation(coords, iHex.getElevation()));
        vector3d.z += 0.4;
        Transform3D transform3D = new Transform3D(C.nullRot, vector3d, 1.0);
        this.setTransform(transform3D);
    }

    public void hide() {
        this.setTransform(new Transform3D(C.nullRot, new Vector3d(), 0.0));
    }
}

