/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.AmmoType;
import megamek.common.EquipmentType;

public class BombType
extends AmmoType {
    public static final int B_HE = 0;
    public static final int B_CLUSTER = 1;
    public static final int B_LG = 2;
    public static final int B_RL = 3;
    public static final int B_TAG = 4;
    public static final int B_AAA = 5;
    public static final int B_AS = 6;
    public static final int B_ASEW = 7;
    public static final int B_ARROW = 8;
    public static final int B_HOMING = 9;
    public static final int B_INFERNO = 10;
    public static final int B_LAA = 11;
    public static final int B_THUNDER = 12;
    public static final int B_TORPEDO = 13;
    public static final int B_ALAMO = 14;
    public static final int B_NUM = 15;
    public static final String[] bombNames = new String[]{"HE Bomb", "Cluster Bomb", "Laser-guided Bomb", "Rocket", "TAG", "AAA Missile", "AS Missile", "ASEW Missile", "Arrow IV Missile", "Arrow IV Homing Missile", "Inferno Bomb", "LAA Missile", "Thunder Bomb", "Torpedo Bomb", "Alamo Missile"};
    public static final String[] bombInternalNames = new String[]{"HEBomb", "ClusterBomb", "LGBomb", "RocketBomb", "TAGBomb", "AAAMissile Ammo", "ASMissile Ammo", "ASEWMissile Ammo", "ArrowIVMissile Ammo", "ArrowIVHomingMissile Ammo", "InfernoBomb", "LAAMissile Ammo", "ThunderBomb", "TorpedoBomb", "AlamoMissile Ammo"};
    public static final String[] bombWeaponNames = new String[]{null, null, null, "BombRL", "BombTAG", "AAAMissile", "ASMissile", "ASEWMissile", "BombArrowIV", "BombArrowIV", null, "LAAMissile", null, null, "AlamoMissile"};
    public static final int[] bombCosts = new int[]{1, 1, 1, 1, 1, 5, 6, 6, 5, 5, 1, 1, 1, 1, 10};
    private int bombType;

    public static String getBombName(int n) {
        if (n >= 15 || n < 0) {
            return "Unknown bomb type";
        }
        return bombNames[n];
    }

    public static String getBombWeaponName(int n) {
        if (n >= 15 || n < 0) {
            return "Unknown bomb weapon";
        }
        return bombWeaponNames[n];
    }

    public static String getBombInternalName(int n) {
        if (n >= 15 || n < 0) {
            return "Unknown bomb type";
        }
        return bombInternalNames[n];
    }

    public static int getBombCost(int n) {
        if (n >= 15 || n < 0) {
            return 0;
        }
        return bombCosts[n];
    }

    public int getBombType() {
        return this.bombType;
    }

    public static void initializeTypes() {
        EquipmentType.addType(BombType.createHighExplosiveBomb());
        EquipmentType.addType(BombType.createClusterBomb());
        EquipmentType.addType(BombType.createLaserGuidedBomb());
        EquipmentType.addType(BombType.createRocketBomb());
        EquipmentType.addType(BombType.createTAGBomb());
        EquipmentType.addType(BombType.createAAAMissileBomb());
        EquipmentType.addType(BombType.createASMissileBomb());
        EquipmentType.addType(BombType.createASEWMissileBomb());
        EquipmentType.addType(BombType.createArrowIVBomb());
        EquipmentType.addType(BombType.createArrowIVHomingBomb());
        EquipmentType.addType(BombType.createInfernoBomb());
        EquipmentType.addType(BombType.createLAAMissileBomb());
        EquipmentType.addType(BombType.createThunderBomb());
        EquipmentType.addType(BombType.createTorpedoBomb());
        EquipmentType.addType(BombType.createAlamoBomb());
    }

    private static BombType createHighExplosiveBomb() {
        BombType bombType = new BombType();
        bombType.techLevel = 4;
        bombType.name = "HE Bomb";
        bombType.shortName = "HEBomb";
        bombType.setInternalName(BombType.getBombInternalName(0));
        bombType.damagePerShot = 10;
        bombType.rackSize = 1;
        bombType.ammoType = 76;
        bombType.bombType = 0;
        bombType.shots = 1;
        bombType.bv = 0.0;
        bombType.cost = 0.0;
        return bombType;
    }

    private static BombType createClusterBomb() {
        BombType bombType = new BombType();
        bombType.techLevel = 4;
        bombType.name = "Cluster Bomb";
        bombType.shortName = "ClusterBomb";
        bombType.setInternalName(BombType.getBombInternalName(1));
        bombType.damagePerShot = 5;
        bombType.rackSize = 1;
        bombType.ammoType = 76;
        bombType.bombType = 1;
        bombType.shots = 1;
        bombType.bv = 0.0;
        bombType.cost = 0.0;
        return bombType;
    }

    private static BombType createLaserGuidedBomb() {
        BombType bombType = new BombType();
        bombType.techLevel = 4;
        bombType.name = "Laser-Guided Bomb";
        bombType.shortName = "LGBomb";
        bombType.setInternalName(BombType.getBombInternalName(2));
        bombType.damagePerShot = 10;
        bombType.rackSize = 1;
        bombType.ammoType = 76;
        bombType.bombType = 2;
        bombType.shots = 1;
        bombType.bv = 0.0;
        bombType.cost = 0.0;
        return bombType;
    }

    private static BombType createTAGBomb() {
        BombType bombType = new BombType();
        bombType.techLevel = 4;
        bombType.name = "TAGBomb";
        bombType.shortName = "TAGBomb";
        bombType.setInternalName(BombType.getBombInternalName(4));
        bombType.damagePerShot = 0;
        bombType.rackSize = 1;
        bombType.ammoType = 76;
        bombType.bombType = 4;
        bombType.shots = 1;
        bombType.bv = 0.0;
        bombType.cost = 0.0;
        return bombType;
    }

    private static BombType createRocketBomb() {
        BombType bombType = new BombType();
        bombType.techLevel = 1;
        bombType.name = "RL 10 Ammo (bomb)";
        bombType.setInternalName(BombType.getBombInternalName(3));
        bombType.damagePerShot = 1;
        bombType.rackSize = 10;
        bombType.ammoType = 81;
        bombType.bombType = 3;
        bombType.shots = 1;
        bombType.bv = 0.0;
        bombType.cost = 0.0;
        return bombType;
    }

    private static BombType createAAAMissileBomb() {
        BombType bombType = new BombType();
        bombType.techLevel = 5;
        bombType.name = "AAA Missile Ammo";
        bombType.setInternalName(BombType.getBombInternalName(5));
        bombType.damagePerShot = 20;
        bombType.rackSize = 1;
        bombType.ammoType = 77;
        bombType.bombType = 5;
        bombType.shots = 1;
        bombType.bv = 0.0;
        bombType.cost = 0.0;
        return bombType;
    }

    private static BombType createASMissileBomb() {
        BombType bombType = new BombType();
        bombType.techLevel = 7;
        bombType.name = "Anti-Ship Missile Ammo";
        bombType.setInternalName(BombType.getBombInternalName(6));
        bombType.damagePerShot = 20;
        bombType.rackSize = 1;
        bombType.ammoType = 78;
        bombType.bombType = 6;
        bombType.shots = 1;
        bombType.bv = 0.0;
        bombType.cost = 0.0;
        return bombType;
    }

    private static BombType createASEWMissileBomb() {
        BombType bombType = new BombType();
        bombType.techLevel = 5;
        bombType.name = "Anti-Ship (EW) Missile Ammo";
        bombType.setInternalName(BombType.getBombInternalName(7));
        bombType.damagePerShot = 0;
        bombType.rackSize = 1;
        bombType.ammoType = 79;
        bombType.bombType = 7;
        bombType.shots = 1;
        bombType.bv = 0.0;
        bombType.cost = 0.0;
        return bombType;
    }

    private static BombType createArrowIVBomb() {
        BombType bombType = new BombType();
        bombType.techLevel = 5;
        bombType.name = "Arrow IV Ammo (Bomb)";
        bombType.shortName = "Arrow IV (Bomb)";
        bombType.setInternalName(BombType.getBombInternalName(8));
        bombType.damagePerShot = 1;
        bombType.rackSize = 20;
        bombType.ammoType = 82;
        bombType.bombType = 8;
        bombType.shots = 1;
        bombType.bv = 0.0;
        bombType.cost = 0.0;
        return bombType;
    }

    private static BombType createArrowIVHomingBomb() {
        BombType bombType = new BombType();
        bombType.techLevel = 5;
        bombType.name = "Arrow IV Homing Ammo (Bomb)";
        bombType.shortName = "Arrow IV Homing (Bomb)";
        bombType.setInternalName(BombType.getBombInternalName(9));
        bombType.damagePerShot = 1;
        bombType.rackSize = 20;
        bombType.ammoType = 82;
        bombType.bombType = 9;
        bombType.munitionType = 0x2000000000L;
        bombType.shots = 1;
        bombType.bv = 0.0;
        bombType.cost = 0.0;
        return bombType;
    }

    private static BombType createInfernoBomb() {
        BombType bombType = new BombType();
        bombType.techLevel = 5;
        bombType.name = "Inferno Bomb";
        bombType.shortName = "InfernoBomb";
        bombType.setInternalName(BombType.getBombInternalName(10));
        bombType.damagePerShot = 5;
        bombType.rackSize = 1;
        bombType.ammoType = 76;
        bombType.bombType = 10;
        bombType.shots = 1;
        bombType.bv = 0.0;
        bombType.cost = 0.0;
        return bombType;
    }

    private static BombType createLAAMissileBomb() {
        BombType bombType = new BombType();
        bombType.techLevel = 5;
        bombType.name = "LAA Missile Ammo";
        bombType.setInternalName(BombType.getBombInternalName(11));
        bombType.damagePerShot = 6;
        bombType.rackSize = 1;
        bombType.ammoType = 80;
        bombType.bombType = 11;
        bombType.shots = 1;
        bombType.bv = 0.0;
        bombType.cost = 0.0;
        return bombType;
    }

    private static BombType createThunderBomb() {
        BombType bombType = new BombType();
        bombType.techLevel = 5;
        bombType.name = "Thunder Bomb";
        bombType.shortName = "ThunderBomb";
        bombType.setInternalName(BombType.getBombInternalName(12));
        bombType.damagePerShot = 20;
        bombType.rackSize = 1;
        bombType.ammoType = 76;
        bombType.bombType = 12;
        bombType.shots = 1;
        bombType.bv = 0.0;
        bombType.cost = 0.0;
        return bombType;
    }

    private static BombType createTorpedoBomb() {
        BombType bombType = new BombType();
        bombType.techLevel = 5;
        bombType.name = "Torpedo Bomb";
        bombType.shortName = "TorpedoBomb";
        bombType.setInternalName(BombType.getBombInternalName(13));
        bombType.damagePerShot = 10;
        bombType.rackSize = 1;
        bombType.ammoType = 76;
        bombType.bombType = 13;
        bombType.shots = 1;
        bombType.bv = 0.0;
        bombType.cost = 0.0;
        return bombType;
    }

    private static BombType createAlamoBomb() {
        BombType bombType = new BombType();
        bombType.techLevel = 7;
        bombType.name = "Alamo Missile Ammo";
        bombType.setInternalName(BombType.getBombInternalName(14));
        bombType.damagePerShot = 10;
        bombType.rackSize = 1;
        bombType.ammoType = 63;
        bombType.bombType = 14;
        bombType.shots = 1;
        bombType.bv = 0.0;
        bombType.cost = 0.0;
        bombType.flags |= 0x200L;
        bombType.capital = true;
        return bombType;
    }
}

