/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.IGame;
import megamek.common.Mounted;
import megamek.common.RangeType;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.WeaponHandler;
import megamek.server.Server;

public class BayWeaponHandler
extends WeaponHandler {
    private static final long serialVersionUID = -1618484541772117621L;

    public BayWeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    protected int calcAttackValue() {
        int n = this.ae.getPosition().distance(this.target.getPosition());
        double d = 0.0;
        int n2 = RangeType.rangeBracket(n, this.wtype.getATRanges(), true);
        for (int n3 : this.weapon.getBayWeapons()) {
            Mounted mounted = this.ae.getEquipment(n3);
            if (mounted.isBreached() || mounted.isDestroyed() || mounted.isJammed()) continue;
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (n2 == 1) {
                d += weaponType.getShortAV();
                continue;
            }
            if (n2 == 2) {
                d += weaponType.getMedAV();
                continue;
            }
            if (n2 == 3) {
                d += weaponType.getLongAV();
                continue;
            }
            if (n2 != 4) continue;
            d += weaponType.getExtAV();
        }
        return (int)Math.ceil(d);
    }

    protected void addHeat() {
        if (this.toHit.getValue() != Integer.MAX_VALUE) {
            if (this.game.getOptions().booleanOption("heat_by_bay")) {
                for (int n : this.weapon.getBayWeapons()) {
                    Mounted mounted = this.ae.getEquipment(n);
                    this.ae.heatBuildup += mounted.getCurrentHeat();
                }
            } else {
                boolean bl;
                int n = this.weapon.getLocation();
                if (!this.ae.hasArcFired(n, bl = this.weapon.isRearMounted())) {
                    this.ae.heatBuildup += this.ae.getHeatInArc(n, bl);
                    this.ae.setArcFired(n, bl);
                }
            }
        }
    }
}

