/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Enumeration;
import java.util.Vector;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.FighterSquadron;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenLauncherHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = -2536312899803153911L;

    public ScreenLauncherHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    public boolean handle(IGame.Phase phase, Vector<Report> vector) {
        if (!this.cares(phase)) {
            return true;
        }
        this.r = new Report(3115);
        this.r.indent();
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.wtype.getName());
        this.r.messageId = 3120;
        this.r.add(this.target.getDisplayName(), true);
        vector.addElement(this.r);
        if (this.toHit.getValue() == Integer.MAX_VALUE) {
            this.r = new Report(3135);
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
            return false;
        }
        if (this.toHit.getValue() == 0x7FFFFFFE) {
            this.r = new Report(3140);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else if (this.toHit.getValue() == Integer.MIN_VALUE) {
            this.r = new Report(3145);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        }
        this.addHeat();
        Coords coords = this.target.getPosition();
        this.server.deliverScreen(coords, vector);
        Enumeration<Entity> enumeration = this.game.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (entity instanceof FighterSquadron) {
                for (Entity entity2 : ((FighterSquadron)entity).getFighters()) {
                    ToHitData toHitData = new ToHitData();
                    toHitData.setHitTable(0);
                    HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), 0);
                    hitData.setCapital(false);
                    vector.addAll(this.server.damageEntity(entity2, hitData, this.attackValue));
                    this.server.creditKill(entity2, this.ae);
                }
                continue;
            }
            ToHitData toHitData = new ToHitData();
            toHitData.setHitTable(0);
            HitData hitData = entity.rollHitLocation(toHitData.getHitTable(), 0);
            hitData.setCapital(false);
            vector.addAll(this.server.damageEntity(entity, hitData, this.attackValue));
            this.server.creditKill(entity, this.ae);
        }
        return false;
    }
}

