/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.dita.markdown;

import com.elovirta.dita.markdown.SaxWriter;
import com.elovirta.dita.markdown.renderer.NodeRendererContext;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.vladsch.flexmark.ext.yaml.front.matter.AbstractYamlFrontMatterVisitor;
import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterBlock;
import com.vladsch.flexmark.util.ast.Node;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.XMLUtils;
import org.xml.sax.Attributes;

public class MetadataSerializerImpl {
    private final Set<String> knownKeys;

    public MetadataSerializerImpl(Boolean idFromYaml) {
        ImmutableSet.Builder keys = ImmutableSet.builder().add((Object[])new String[]{Constants.TOPIC_AUTHOR.localName, Constants.TOPIC_SOURCE.localName, Constants.TOPIC_PUBLISHER.localName, Constants.TOPIC_PERMISSIONS.localName, Constants.TOPIC_AUDIENCE.localName, Constants.TOPIC_CATEGORY.localName, Constants.TOPIC_RESOURCEID.localName, Constants.TOPIC_KEYWORD.localName});
        if (idFromYaml.booleanValue()) {
            keys.add((Object)"id");
        }
        this.knownKeys = keys.build();
    }

    public static Attributes buildAtts(DitaClass cls) {
        return new XMLUtils.AttributesBuilder().add("class", cls.toString()).build();
    }

    public void render(YamlFrontMatterBlock node, NodeRendererContext context, SaxWriter html) {
        AbstractYamlFrontMatterVisitor v = new AbstractYamlFrontMatterVisitor();
        v.visit(node);
        Map header = v.getData();
        this.write(header, Constants.TOPIC_AUTHOR, html);
        this.write(header, Constants.TOPIC_SOURCE, html);
        this.write(header, Constants.TOPIC_PUBLISHER, html);
        this.write(header, Constants.TOPIC_PERMISSIONS, "view", html);
        if (header.containsKey(Constants.TOPIC_AUDIENCE.localName) || header.containsKey(Constants.TOPIC_CATEGORY.localName) || header.containsKey(Constants.TOPIC_KEYWORD.localName)) {
            html.startElement((Node)node, Constants.TOPIC_METADATA, MetadataSerializerImpl.buildAtts(Constants.TOPIC_METADATA));
            this.write(header, Constants.TOPIC_AUDIENCE, "type", html);
            this.write(header, Constants.TOPIC_CATEGORY, html);
            if (header.containsKey(Constants.TOPIC_KEYWORD.localName)) {
                html.startElement((Node)node, Constants.TOPIC_KEYWORDS, MetadataSerializerImpl.buildAtts(Constants.TOPIC_KEYWORDS));
                this.write(header, Constants.TOPIC_KEYWORD, html);
                html.endElement();
            }
            html.endElement();
        }
        this.write(header, Constants.TOPIC_RESOURCEID, "appid", html);
        List keys = Sets.difference(header.keySet(), this.knownKeys).stream().sorted().collect(Collectors.toList());
        for (String key : keys) {
            for (String val : (List)header.get(key)) {
                html.startElement((Node)node, Constants.TOPIC_DATA.localName, new XMLUtils.AttributesBuilder().add("class", Constants.TOPIC_DATA.toString()).add("name", key).add("value", val).build());
                html.endElement();
            }
        }
    }

    private void write(Map<String, List<String>> header, DitaClass elem, SaxWriter html) {
        if (header.containsKey(elem.localName)) {
            for (String v : header.get(elem.localName)) {
                html.startElement(null, elem, MetadataSerializerImpl.buildAtts(elem));
                if (v != null) {
                    html.characters(v);
                }
                html.endElement();
            }
        }
    }

    private void write(Map<String, List<String>> header, DitaClass elem, String attr, SaxWriter html) {
        if (header.containsKey(elem.localName)) {
            for (String v : header.get(elem.localName)) {
                html.startElement(null, elem, new XMLUtils.AttributesBuilder().add("class", elem.toString()).add(attr, v).build());
                html.endElement();
            }
        }
    }
}

