/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.ant.types;

import java.net.URI;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileNameMapper;
import org.dita.dost.ant.ExtensibleAntInvoker;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;

public class JobMapper
implements FileNameMapper {
    private Type type = Type.RESULT;
    private Job job;
    private String extension;

    public void setProject(Project project) {
        this.job = ExtensibleAntInvoker.getJob(project);
    }

    public void setFrom(String from) {
    }

    public void setTo(String extension) {
        this.extension = extension.charAt(0) == '.' ? extension : "." + extension;
    }

    public void setExtension(String extension) {
        this.extension = extension.charAt(0) == '.' ? extension : "." + extension;
    }

    public void setType(TypeAttribute attr) {
        this.type = Type.valueOf(attr.getValue().toUpperCase());
    }

    public String[] mapFileName(String sourceFileName) {
        URI uri = URLUtils.toURI(sourceFileName);
        Job.FileInfo fi = this.job.getFileInfo(uri);
        if (fi == null) {
            fi = this.job.getFileInfo(this.job.getInputDir().resolve(uri));
        }
        String res = switch (this.type) {
            case Type.TEMP -> fi.file.getPath();
            case Type.RESULT -> {
                if (fi.result == null) {
                    yield sourceFileName;
                }
                URI base = this.job.getInputDir();
                URI rel = base.relativize(fi.result);
                yield URLUtils.toFile(rel).getPath();
            }
            default -> throw new IllegalArgumentException();
        };
        return new String[]{this.extension != null ? FilenameUtils.removeExtension((String)res) + this.extension : res};
    }

    private static enum Type {
        TEMP,
        RESULT;

    }

    public static class TypeAttribute
    extends EnumeratedAttribute {
        public String[] getValues() {
            return Arrays.stream(Type.values()).map(t -> t.toString().toLowerCase()).collect(Collectors.toList()).toArray(new String[Type.values().length]);
        }
    }
}

