/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.ant.types;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.URLResource;
import org.dita.dost.ant.ExtensibleAntInvoker;
import org.dita.dost.store.ant.types.StoreResource;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;

public class JobSourceSet
extends AbstractFileSet
implements ResourceCollection {
    private final SelectorElem include = new SelectorElem();
    private final List<SelectorElem> includes = new ArrayList<SelectorElem>();
    private final List<SelectorElem> excludes = new ArrayList<SelectorElem>();
    private Collection<Resource> res;
    private boolean isFilesystemOnly = true;

    private Collection<Resource> getResults() {
        if (this.res == null) {
            if (!this.include.isEmpty()) {
                this.includes.add(this.include);
            }
            Job job = this.getJob();
            this.res = new ArrayList<Resource>();
            for (Job.FileInfo f : job.getFileInfo(this::filter)) {
                this.log("Scanning for " + f.file.getPath(), 3);
                File tempFile = new File(job.tempDirURI.resolve(f.uri));
                if (job.getStore().exists(tempFile.toURI())) {
                    this.log("Found temporary directory file " + tempFile, 3);
                    this.res.add(new StoreResource(job, job.tempDirURI.relativize(f.uri)));
                    continue;
                }
                if (f.src != null && Objects.equals(f.src.getScheme(), "file")) {
                    File srcFile = new File(URLUtils.setQuery(f.src, null));
                    if (srcFile.exists()) {
                        this.log("Found source directory file " + srcFile, 3);
                        File rel = FileUtils.getRelativePath(new File(new File(job.getInputDir()), "dummy"), srcFile);
                        this.res.add((Resource)new FileResource(URLUtils.toFile(job.getInputDir()), rel.getPath()));
                        continue;
                    }
                    this.log("File " + f.src + " not found", 0);
                    continue;
                }
                if (f.src != null && Objects.equals(f.src.getScheme(), "data")) {
                    this.log("Ignore data URI", 3);
                    continue;
                }
                this.log("Found source URI " + f.src, 3);
                try {
                    JobResource r = new JobResource(job.getInputDir().toURL(), f.uri.toString());
                    this.res.add((Resource)r);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
                this.isFilesystemOnly = false;
            }
        }
        return this.res;
    }

    @VisibleForTesting
    Job getJob() {
        Job job = ExtensibleAntInvoker.getJob(this.getProject());
        if (job == null) {
            throw new IllegalStateException();
        }
        return job;
    }

    public Iterator<Resource> iterator() {
        return this.getResults().iterator();
    }

    public int size() {
        return this.getResults().size();
    }

    public boolean isFilesystemOnly() {
        this.getResults();
        return this.isFilesystemOnly;
    }

    public void setFormat(String format) {
        this.include.setFormat(format);
    }

    public void setConref(boolean conref) {
        this.include.setConref(conref);
    }

    public void setInput(boolean isInput) {
        this.include.setInput(isInput);
    }

    public void setInputResource(boolean isInputResource) {
        this.include.setInputResource(isInputResource);
    }

    public void setProcessingRole(String processingRole) {
        this.include.setProcessingRole(processingRole);
    }

    public void addConfiguredIncludes(SelectorElem include) {
        this.includes.add(include);
    }

    public void addConfiguredExcludes(SelectorElem exclude) {
        this.excludes.add(exclude);
    }

    @VisibleForTesting
    public boolean filter(Job.FileInfo f) {
        for (SelectorElem excl : this.excludes) {
            if (!this.filter(f, excl)) continue;
            return false;
        }
        if (this.includes.isEmpty()) {
            return true;
        }
        for (SelectorElem incl : this.includes) {
            if (!this.filter(f, incl)) continue;
            return true;
        }
        return false;
    }

    private boolean filter(Job.FileInfo f, SelectorElem incl) {
        String format = f.format != null ? f.format : "dita";
        return !(!incl.formats.isEmpty() && !incl.formats.contains(format) || incl.hasConref != null && f.hasConref != incl.hasConref || incl.isInput != null && f.isInput != incl.isInput || incl.isInputResource != null && f.isInputResource != incl.isInputResource || incl.isResourceOnly != null && f.isResourceOnly != incl.isResourceOnly);
    }

    public static class SelectorElem {
        private Set<String> formats = Collections.emptySet();
        private Boolean hasConref;
        private Boolean isInput;
        private Boolean isInputResource;
        private Boolean isResourceOnly;

        public SelectorElem() {
        }

        public SelectorElem(Set<String> formats, Boolean hasConref, Boolean isInput, Boolean isInputResource, Boolean isResourceOnly) {
            this.formats = formats != null ? formats : Collections.emptySet();
            this.hasConref = hasConref;
            this.isInput = isInput;
            this.isInputResource = isInputResource;
            this.isResourceOnly = isResourceOnly;
        }

        public void setFormat(String format) {
            ImmutableSet.Builder builder = ImmutableSet.builder().add((Object)format);
            if (format.equals("image")) {
                FileUtils.supportedImageExtensions.stream().map(ext -> ext.substring(1)).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
            }
            this.formats = builder.build();
        }

        public void setConref(boolean conref) {
            this.hasConref = conref;
        }

        public void setInput(boolean isInput) {
            this.isInput = isInput;
        }

        public void setInputResource(boolean isInputResource) {
            this.isInputResource = isInputResource;
        }

        public void setProcessingRole(String processingRole) {
            this.isResourceOnly = processingRole.equals("resource-only");
        }

        public boolean isEmpty() {
            return this.formats.isEmpty() && this.hasConref == null && this.isInput == null && this.isInputResource == null && this.isResourceOnly == null;
        }
    }

    private static class JobResource
    extends URLResource {
        private final String relPath;

        public JobResource(URL baseURL, String relPath) {
            this.setBaseURL(baseURL);
            this.setRelativePath(relPath);
            this.relPath = relPath;
        }

        public synchronized String getName() {
            if (this.isReference()) {
                return ((JobResource)((Object)this.getCheckedRef(((Object)((Object)this)).getClass(), this.getDataTypeName(), this.getProject()))).getName();
            }
            return this.relPath;
        }
    }
}

