/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dita.dost.invoker.Arguments;
import org.dita.dost.invoker.ConversionArguments;
import org.dita.dost.invoker.DeliverablesArguments;
import org.dita.dost.invoker.InstallArguments;
import org.dita.dost.invoker.PluginsArguments;
import org.dita.dost.invoker.TranstypesArguments;
import org.dita.dost.invoker.UninstallArguments;
import org.dita.dost.invoker.VersionArguments;
import org.dita.dost.platform.Plugins;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Element;

final class ArgumentParser {
    private static final Map<String, String> TRUTHY_VALUES = ImmutableMap.builder().put((Object)"true", (Object)"false").put((Object)"TRUE", (Object)"FALSE").put((Object)"yes", (Object)"no").put((Object)"YES", (Object)"NO").put((Object)"1", (Object)"0").put((Object)"on", (Object)"off").put((Object)"ON", (Object)"OFF").build();
    private static Map<String, Arguments.Argument> PLUGIN_ARGUMENTS;

    ArgumentParser() {
    }

    static Arguments.Argument mergeArguments(Arguments.Argument a, Arguments.Argument b) {
        if (a instanceof Arguments.EnumArgument && b instanceof Arguments.EnumArgument) {
            ImmutableSet vals = ImmutableSet.builder().addAll(((Arguments.EnumArgument)a).values).addAll(((Arguments.EnumArgument)b).values).build();
            return new Arguments.EnumArgument(a.property, a.desc, (Set<String>)vals);
        }
        return a;
    }

    static Arguments.Argument getArgument(Element param) {
        String name = param.getAttribute("name");
        String type = param.getAttribute("type");
        String desc = param.getAttribute("desc");
        switch (type) {
            case "file": {
                return new Arguments.FileArgument(name, desc);
            }
            case "enum": {
                Set<String> vals = XMLUtils.getChildElements(param).stream().map(XMLUtils::getText).collect(Collectors.toSet());
                if (vals.size() == 2) {
                    for (Map.Entry<String, String> pair : TRUTHY_VALUES.entrySet()) {
                        if (!vals.contains(pair.getKey()) || !vals.contains(pair.getValue())) continue;
                        return new Arguments.BooleanArgument(name, desc, pair.getKey(), pair.getValue());
                    }
                }
                return new Arguments.EnumArgument(name, desc, vals);
            }
        }
        return new Arguments.StringArgument(name, desc);
    }

    static synchronized Map<String, Arguments.Argument> getPluginArguments() {
        if (PLUGIN_ARGUMENTS == null) {
            List params = XMLUtils.toList(Plugins.getPluginConfiguration().getElementsByTagName("param"));
            PLUGIN_ARGUMENTS = params.stream().map(ArgumentParser::getArgument).collect(Collectors.toMap(arg -> "--" + arg.property, arg -> arg, ArgumentParser::mergeArguments));
        }
        return PLUGIN_ARGUMENTS;
    }

    public Arguments processArgs(String[] arguments) {
        for (String subcommand : arguments) {
            switch (this.getName(subcommand)) {
                case "plugins": {
                    return new PluginsArguments().parse(arguments);
                }
                case "version": {
                    return new VersionArguments().parse(arguments);
                }
                case "transtypes": {
                    return new TranstypesArguments().parse(arguments);
                }
                case "deliverables": {
                    return new DeliverablesArguments().parse(arguments);
                }
                case "install": {
                    return new InstallArguments().parse(arguments);
                }
                case "uninstall": {
                    return new UninstallArguments().parse(arguments);
                }
            }
        }
        return new ConversionArguments().parse(arguments);
    }

    private String getName(String subcommand) {
        int start = subcommand.startsWith("--") ? 2 : (subcommand.startsWith("-") ? 1 : 0);
        int end = subcommand.indexOf(61);
        return subcommand.substring(start, end != -1 ? end : subcommand.length());
    }
}

