/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.DOMDestination;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.GenListModuleReader;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.ChainedURIResolver;
import org.dita.dost.util.Constants;
import org.dita.dost.util.Job;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

final class MaprefModule
extends AbstractPipelineModuleImpl {
    private Processor processor;
    private XsltExecutable templates;

    MaprefModule() {
    }

    private void init(AbstractPipelineInput input) {
        this.processor = this.xmlUtils.getProcessor();
        XsltCompiler xsltCompiler = this.processor.newXsltCompiler();
        xsltCompiler.setErrorReporter(XMLUtils.toErrorReporter(this.logger));
        File style = new File(input.getAttribute("style"));
        try {
            this.templates = xsltCompiler.compile((Source)new StreamSource(style));
        }
        catch (SaxonApiException e) {
            throw new RuntimeException("Failed to compile stylesheet '" + style.getAbsolutePath() + "': " + e.getMessage(), e);
        }
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        Collection<Job.FileInfo> fileInfos;
        if (this.fileInfoFilter == null) {
            this.fileInfoFilter = fileInfo -> fileInfo.format != null && fileInfo.format.equals("ditamap");
        }
        if ((fileInfos = this.job.getFileInfo(this.fileInfoFilter)).isEmpty()) {
            return null;
        }
        this.init(input);
        for (Job.FileInfo fileInfo2 : fileInfos) {
            this.processMap(fileInfo2);
        }
        for (Job.FileInfo fileInfo2 : fileInfos) {
            this.replace(fileInfo2);
        }
        try {
            this.job.write();
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to serialize job configuration: " + e.getMessage(), e);
        }
        return null;
    }

    private void processMap(Job.FileInfo input) throws DITAOTException {
        Document doc;
        File inputFile = new File(this.job.tempDirURI.resolve(input.uri));
        File outputFile = new File(inputFile.getAbsolutePath() + ".temp");
        this.logger.info("Processing " + inputFile.toURI());
        try {
            doc = XMLUtils.getDocumentBuilder().newDocument();
            XsltTransformer transformer = this.templates.load();
            transformer.setErrorReporter(XMLUtils.toErrorReporter(this.logger));
            transformer.setURIResolver((URIResolver)new ChainedURIResolver(this.job.getStore(), (URIResolver)CatalogUtils.getCatalogResolver()));
            transformer.setMessageListener(XMLUtils.toMessageListener(this.logger, this.processingMode));
            transformer.setParameter(new QName("file-being-processed"), XdmItem.makeValue((Object)inputFile.getName()));
            Source source = this.job.getStore().getSource(inputFile.toURI());
            transformer.setSource(source);
            DOMDestination serializer = new DOMDestination((Node)doc);
            serializer.setDestinationBaseURI(inputFile.toURI());
            transformer.setDestination((Destination)serializer);
            transformer.transform();
        }
        catch (UncheckedXPathException e) {
            throw new DITAOTException("Failed to merge map " + inputFile, e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SaxonApiException e) {
            try {
                throw e.getCause();
            }
            catch (XPathException cause) {
                throw new DITAOTException("Failed to merge map " + inputFile + ": " + cause.getMessageAndLocation(), e);
            }
            catch (Throwable throwable) {
                throw new DITAOTException("Failed to merge map " + inputFile + ": " + e.getMessage(), e);
            }
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to merge map " + inputFile + ": " + e.getMessage(), e);
        }
        Job.FileInfo updated = this.collectJobInfo(input, doc);
        this.job.add(updated);
        try {
            doc.setDocumentURI(outputFile.toURI().toString());
            this.job.getStore().writeDocument(doc, outputFile.toURI());
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to serialize map " + inputFile + ": " + e.getMessage(), e);
        }
    }

    private Job.FileInfo collectJobInfo(Job.FileInfo fileInfo, Document doc) {
        Job.FileInfo.Builder builder = new Job.FileInfo.Builder(fileInfo);
        List elements = XMLUtils.toList(doc.getElementsByTagName("*"));
        if (!fileInfo.hasConref) {
            builder.hasConref(elements.stream().anyMatch(e -> e.hasAttribute("conref") || e.hasAttribute("conkeyref")));
        }
        if (!fileInfo.hasKeyref) {
            builder.hasKeyref(elements.stream().anyMatch(e -> {
                if (Constants.SUBJECTSCHEME_SUBJECTDEF.matches((Node)e)) {
                    return false;
                }
                for (String attr : GenListModuleReader.KEYREF_ATTRS) {
                    if (!e.hasAttribute(attr)) continue;
                    return true;
                }
                return false;
            }));
        }
        return builder.build();
    }

    private void replace(Job.FileInfo input) throws DITAOTException {
        File inputFile = new File(this.job.tempDirURI.resolve(input.uri + ".temp"));
        File outputFile = new File(this.job.tempDirURI.resolve(input.uri));
        try {
            this.job.getStore().move(inputFile.toURI(), outputFile.toURI());
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to replace temporary file " + inputFile + ": " + e.getMessage(), e);
        }
    }
}

