/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.DOMDestination;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.UncheckedXPathException;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.ChainedURIResolver;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.DitaLinksWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class MoveLinksModule
extends AbstractPipelineModuleImpl {
    MoveLinksModule() {
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        Document doc;
        Job.FileInfo fi = this.job.getFileInfo(f -> f.isInput).iterator().next();
        if (!"ditamap".equals(fi.format)) {
            return null;
        }
        File inputFile = new File(this.job.tempDirURI.resolve(fi.uri));
        File styleFile = new File(input.getAttribute("style"));
        try {
            XsltCompiler xsltCompiler = this.xmlUtils.getProcessor().newXsltCompiler();
            XsltTransformer transformer = xsltCompiler.compile((Source)new StreamSource(styleFile)).load();
            transformer.setErrorReporter(XMLUtils.toErrorReporter(this.logger));
            transformer.setURIResolver((URIResolver)new ChainedURIResolver(this.job.getStore(), (URIResolver)CatalogUtils.getCatalogResolver()));
            transformer.setMessageListener(XMLUtils.toMessageListener(this.logger, this.processingMode));
            if (input.getAttribute("include.rellinks") != null) {
                transformer.setParameter(new QName("include.rellinks"), XdmItem.makeValue((Object)input.getAttribute("include.rellinks")));
            }
            transformer.setParameter(new QName("INPUTMAP"), XdmItem.makeValue((Object)this.job.getInputMap()));
            Source source = this.job.getStore().getSource(inputFile.toURI());
            doc = XMLUtils.getDocumentBuilder().newDocument();
            DOMDestination result = new DOMDestination((Node)doc);
            transformer.setSource(source);
            transformer.setDestination((Destination)result);
            transformer.transform();
        }
        catch (UncheckedXPathException e) {
            throw new DITAOTException("Failed to read links from " + inputFile, e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to read links from " + inputFile + ": " + e.getMessage(), e);
        }
        Map<File, Map<String, Element>> mapSet = this.getMapping(doc);
        if (!mapSet.isEmpty()) {
            DitaLinksWriter linkInserter = new DitaLinksWriter();
            linkInserter.setLogger(this.logger);
            linkInserter.setJob(this.job);
            for (Map.Entry<File, Map<String, Element>> entry : mapSet.entrySet()) {
                URI uri = inputFile.toURI().resolve(URLUtils.toURI(entry.getKey().getPath()));
                this.logger.info("Processing " + uri);
                linkInserter.setLinks(entry.getValue());
                linkInserter.setCurrentFile(uri);
                try {
                    linkInserter.write(new File(uri));
                }
                catch (DITAOTException e) {
                    this.logger.error("Failed to insert links: " + e.getMessage(), e);
                }
            }
        }
        return null;
    }

    private Map<File, Map<String, Element>> getMapping(Document doc) {
        HashMap<File, Map<String, Element>> map = new HashMap<File, Map<String, Element>>();
        NodeList maplinks = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < maplinks.getLength(); ++i) {
            Node n = maplinks.item(i);
            if (n.getNodeType() != 1) continue;
            Element maplink = (Element)n;
            URI href = URLUtils.toURI(maplink.getAttribute("href"));
            File path = URLUtils.toFile(URLUtils.stripFragment(href));
            String fragment = href.getFragment();
            if (fragment == null) {
                fragment = "#";
            }
            Map m = map.computeIfAbsent(path, k -> new HashMap());
            Element stub = m.computeIfAbsent(fragment, k -> doc.createElement("stub"));
            Node c = maplink.getFirstChild();
            while (c != null) {
                Node nextSibling = c.getNextSibling();
                stub.appendChild(maplink.removeChild(c));
                c = nextSibling;
            }
        }
        return map;
    }
}

