/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.streams.Steps;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.module.filter.SubjectScheme;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.DitaValReader;
import org.dita.dost.reader.SubjectSchemeReader;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.Job;
import org.dita.dost.writer.ProfilingFilter;
import org.dita.dost.writer.SubjectSchemeFilter;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public final class ProfileModule
extends AbstractPipelineModuleImpl {
    private FilterUtils filterUtils;
    private ProfilingFilter writer;
    private SubjectSchemeFilter subjectSchemeFilter;

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        this.init(input);
        for (Job.FileInfo f : this.job.getFileInfo(this.fileInfoFilter)) {
            URI file = this.job.tempDirURI.resolve(f.uri);
            this.logger.info("Processing {0}", file);
            try {
                this.job.getStore().transform(file, this.getProcessingPipe(file));
                if (this.writer.hasElementOutput()) continue;
                this.logger.info("All content in {0} was filtered out", file);
                this.job.remove(f);
                this.job.getStore().delete(file);
            }
            catch (Exception e) {
                this.logger.error("Failed to profile " + file + ": " + e.getMessage(), e);
            }
        }
        try {
            this.job.write();
        }
        catch (IOException e) {
            throw new DITAOTException(e);
        }
        return null;
    }

    private List<XMLFilter> getProcessingPipe(URI fileToParse) {
        ArrayList<XMLFilter> res = new ArrayList<XMLFilter>();
        this.writer.setCurrentFile(fileToParse);
        res.add(this.writer);
        if (this.subjectSchemeFilter != null) {
            res.add(this.subjectSchemeFilter);
        }
        return res;
    }

    private void init(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        String transtype = input.getAttribute("transtype");
        File ditavalFile = Optional.of(new File(this.job.tempDir, "ditaot.generated.ditaval")).filter(File::exists).orElse(null);
        DitaValReader ditaValReader = new DitaValReader();
        ditaValReader.setLogger(this.logger);
        ditaValReader.setJob(this.job);
        if (ditavalFile != null) {
            ditaValReader.read(ditavalFile.toURI());
            this.filterUtils = new FilterUtils(Configuration.printTranstype.contains(transtype), ditaValReader.getFilterMap(), ditaValReader.getForegroundConflictColor(), ditaValReader.getBackgroundConflictColor());
        } else {
            this.filterUtils = new FilterUtils(Configuration.printTranstype.contains(transtype));
        }
        this.filterUtils.setLogger(this.logger);
        this.initSubjectScheme();
        this.writer = new ProfilingFilter();
        this.writer.setLogger(this.logger);
        this.writer.setJob(this.job);
        this.writer.setFilterUtils(this.filterUtils);
    }

    private void initSubjectScheme() throws DITAOTException {
        XdmNode doc = this.getMapDocument();
        if (doc != null) {
            SubjectSchemeReader subjectSchemeReader = new SubjectSchemeReader();
            subjectSchemeReader.setLogger(this.logger);
            subjectSchemeReader.setJob(this.job);
            List enumerationDefList = doc.select(Steps.descendant(Constants.SUBJECTSCHEME_ENUMERATIONDEF::matches)).toList();
            if (!enumerationDefList.isEmpty()) {
                this.logger.info("Loading subject schemes");
                enumerationDefList.stream().map(enumerationDef -> Map.entry(enumerationDef.select(Steps.ancestor(Constants.SUBMAP::matches)).findFirst().orElse(doc.getOutermostElement()), enumerationDef)).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList()))).forEach((schemeRoot, enumerationDefs) -> {
                    Map<String, SubjectScheme.SubjectDefinition> subjectDefinitions = subjectSchemeReader.getSubjectDefinition((XdmNode)schemeRoot);
                    for (XdmNode enumerationDef : enumerationDefs) {
                        subjectSchemeReader.processEnumerationDef(subjectDefinitions, enumerationDef);
                    }
                });
                SubjectScheme subjectSchemeMap = subjectSchemeReader.getSubjectSchemeMap();
                if (!subjectSchemeMap.subjectSchemeMap().isEmpty()) {
                    this.filterUtils = this.filterUtils.refine(subjectSchemeMap);
                }
                this.subjectSchemeFilter = new SubjectSchemeFilter();
                this.subjectSchemeFilter.setJob(this.job);
                this.subjectSchemeFilter.setLogger(this.logger);
                this.subjectSchemeFilter.setValidateMap(subjectSchemeReader.getValidValuesMap());
                this.subjectSchemeFilter.setDefaultValueMap(subjectSchemeReader.getDefaultValueMap());
            }
        }
    }

    private XdmNode getMapDocument() throws DITAOTException {
        Collection<Job.FileInfo> fis = this.job.getFileInfo(f -> f.isInput && Objects.equals(f.format, "ditamap"));
        if (fis.isEmpty()) {
            return null;
        }
        Job.FileInfo fi = fis.iterator().next();
        URI currentFile = this.job.tempDirURI.resolve(fi.uri);
        try {
            this.logger.debug("Reading {0}", currentFile);
            return this.job.getStore().getImmutableNode(currentFile);
        }
        catch (IOException e) {
            throw new DITAOTException(new SAXException("Failed to parse " + currentFile, e));
        }
    }
}

