/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module.reader;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.streams.Predicates;
import net.sf.saxon.s9api.streams.Steps;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.exception.UncheckedDITAOTException;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.filter.SubjectScheme;
import org.dita.dost.module.reader.AbstractReaderModule;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.GenListModuleReader;
import org.dita.dost.reader.SubjectSchemeReader;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.writer.DebugFilter;
import org.dita.dost.writer.NormalizeFilter;
import org.dita.dost.writer.ProfilingFilter;
import org.dita.dost.writer.ValidationFilter;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public final class TopicReaderModule
extends AbstractReaderModule {
    static final net.sf.saxon.s9api.QName QNAME_HREF = new net.sf.saxon.s9api.QName("href");
    static final net.sf.saxon.s9api.QName QNAME_CONREF = new net.sf.saxon.s9api.QName("conref");
    static final net.sf.saxon.s9api.QName QNAME_SCOPE = new net.sf.saxon.s9api.QName("scope");
    static final net.sf.saxon.s9api.QName QNAME_FORMAT = new net.sf.saxon.s9api.QName("format");
    static final net.sf.saxon.s9api.QName QNAME_CLASS = new net.sf.saxon.s9api.QName("class");
    static final net.sf.saxon.s9api.QName QNAME_ORIG_FORMAT = new net.sf.saxon.s9api.QName("http://dita-ot.sourceforge.net/ns/201007/dita-ot", "orig-format");
    private Map<QName, Map<String, Set<String>>> validateMap = Map.of();
    private Map<QName, Map<String, String>> defaultValueMap = Map.of();

    public TopicReaderModule() {
        this.formatFilter = v -> !Objects.equals(v, "ditamap") && !Objects.equals(v, "ditaval");
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        try {
            this.parseInputParameters(input);
            this.init();
            this.readResourceFiles();
            this.readStartFile();
            this.processWaitList();
            this.handleConref();
            this.outputResult();
            this.job.write();
        }
        catch (RuntimeException | DITAOTException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DITAOTException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    void init() throws DITAOTException {
        super.init();
        this.initSubjectScheme();
    }

    private void initSubjectScheme() throws DITAOTException {
        XdmNode doc = this.getMapDocument();
        if (doc != null) {
            SubjectSchemeReader subjectSchemeReader = new SubjectSchemeReader();
            subjectSchemeReader.setLogger(this.logger);
            subjectSchemeReader.setJob(this.job);
            List enumerationDefList = doc.select(Steps.descendant(Constants.SUBJECTSCHEME_ENUMERATIONDEF::matches)).toList();
            if (!enumerationDefList.isEmpty()) {
                this.logger.info("Loading subject schemes");
                enumerationDefList.stream().map(enumerationDef -> Map.entry(enumerationDef.select(Steps.ancestor(Constants.SUBMAP::matches)).findFirst().orElse(doc.getOutermostElement()), enumerationDef)).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList()))).forEach((schemeRoot, enumerationDefs) -> {
                    Map<String, SubjectScheme.SubjectDefinition> subjectDefinitions = subjectSchemeReader.getSubjectDefinition((XdmNode)schemeRoot);
                    for (XdmNode enumerationDef : enumerationDefs) {
                        subjectSchemeReader.processEnumerationDef(subjectDefinitions, enumerationDef);
                    }
                });
                SubjectScheme subjectSchemeMap = subjectSchemeReader.getSubjectSchemeMap();
                if (this.filterUtils != null) {
                    this.filterUtils = this.filterUtils.refine(subjectSchemeMap);
                }
                this.validateMap = subjectSchemeReader.getValidValuesMap();
                this.defaultValueMap = subjectSchemeReader.getDefaultValueMap();
            }
        }
    }

    @Override
    void readResourceFiles() throws DITAOTException {
        if (!this.resources.isEmpty()) {
            for (URI resource : this.resources) {
                this.additionalResourcesSet.add(resource);
                Job.FileInfo fi = this.job.getFileInfo(resource);
                if (fi == null) {
                    this.addToWaitList(new GenListModuleReader.Reference(resource));
                    continue;
                }
                if ("ditamap".equals(fi.format)) {
                    this.getStartDocuments(fi).forEach(this::addToWaitList);
                    continue;
                }
                if (GenListModuleReader.isFormatDita(fi.format)) {
                    fi.format = "dita";
                    this.job.add(fi);
                }
                this.addToWaitList(new GenListModuleReader.Reference(resource, fi.format));
            }
            this.processWaitList();
            this.additionalResourcesSet.addAll(this.hrefTargetSet);
            this.additionalResourcesSet.addAll(this.conrefTargetSet);
            this.additionalResourcesSet.addAll(this.nonConrefCopytoTargetSet);
            this.additionalResourcesSet.addAll(this.outDitaFilesSet);
            this.additionalResourcesSet.addAll(this.conrefpushSet);
            this.additionalResourcesSet.addAll(this.keyrefSet);
            this.additionalResourcesSet.addAll(this.resourceOnlySet);
            this.additionalResourcesSet.addAll(this.fullTopicSet);
            this.additionalResourcesSet.addAll(this.fullMapSet);
            this.additionalResourcesSet.addAll(this.conrefSet);
            this.resourceOnlySet.clear();
        }
    }

    private XdmNode getMapDocument() throws DITAOTException {
        Job.FileInfo fi = this.job.getFileInfo(f -> f.isInput).iterator().next();
        if (fi == null || GenListModuleReader.isFormatDita(fi.format)) {
            return null;
        }
        URI currentFile = this.job.tempDirURI.resolve(fi.uri);
        try {
            this.logger.debug("Reading " + currentFile);
            return this.job.getStore().getImmutableNode(currentFile);
        }
        catch (IOException e) {
            throw new DITAOTException(new SAXException("Failed to parse " + currentFile, e));
        }
    }

    @Override
    public void readStartFile() throws DITAOTException {
        Job.FileInfo fi = this.job.getFileInfo(f -> f.isInput).iterator().next();
        URI rootFile = this.job.getInputFile();
        if (fi == null) {
            this.addToWaitList(new GenListModuleReader.Reference(rootFile, this.getFormatFromPath(rootFile)));
        } else if ("ditamap".equals(fi.format)) {
            this.getStartDocuments(fi).forEach(this::addToWaitList);
        } else {
            if (fi.format == null) {
                fi.format = "dita";
                this.job.add(fi);
            }
            this.addToWaitList(new GenListModuleReader.Reference(rootFile, fi.format));
        }
    }

    private List<GenListModuleReader.Reference> getStartDocuments(Job.FileInfo startFileInfo) throws DITAOTException {
        ArrayList<GenListModuleReader.Reference> res = new ArrayList<GenListModuleReader.Reference>();
        assert (startFileInfo.src != null);
        URI tmp = this.job.tempDirURI.resolve(startFileInfo.uri);
        try {
            this.logger.info("Reading " + tmp);
            XdmNode source = this.job.getStore().getImmutableNode(tmp);
            Predicate<XdmNode> isTopicref = xdmItem -> Constants.MAP_TOPICREF.matches(xdmItem.getAttributeValue(QNAME_CLASS));
            source.select(Steps.descendant(isTopicref)).forEach(xdmItem -> {
                URI href = this.getHref((XdmNode)xdmItem);
                if (href != null) {
                    Job.FileInfo fi = this.job.getFileInfo(startFileInfo.src.resolve(href));
                    if (fi == null) {
                        fi = this.job.getFileInfo(tmp.resolve(href));
                    }
                    if (fi != null && fi.src != null) {
                        String format = xdmItem.getAttributeValue(QNAME_ORIG_FORMAT);
                        if (format == null) {
                            format = xdmItem.getAttributeValue(QNAME_FORMAT);
                        }
                        res.add(new GenListModuleReader.Reference(fi.src, format));
                        this.nonConrefCopytoTargetSet.add(fi.src);
                    }
                }
            });
            source.select(Steps.descendant((Predicate)Predicates.hasAttribute((String)"conref"))).forEach(xdmItem -> this.getConref((XdmNode)xdmItem).ifPresent(href -> {
                Job.FileInfo fi = this.job.getFileInfo(startFileInfo.src.resolve((URI)href));
                if (fi == null) {
                    fi = this.job.getFileInfo(tmp.resolve((URI)href));
                }
                if (fi != null && fi.src != null) {
                    String format = xdmItem.getAttributeValue(QNAME_ORIG_FORMAT);
                    if (format == null) {
                        format = xdmItem.getAttributeValue(QNAME_FORMAT);
                    }
                    res.add(new GenListModuleReader.Reference(fi.src, format));
                    this.conrefTargetSet.add(fi.src);
                }
            }));
        }
        catch (IOException e) {
            throw new DITAOTException(e);
        }
        return res;
    }

    private URI getHref(XdmNode in) {
        URI href = URLUtils.toURI(in.getAttributeValue(QNAME_HREF));
        if (href == null) {
            return null;
        }
        String scope = in.getAttributeValue(QNAME_SCOPE);
        if (!DitaUtils.isLocalScope(scope)) {
            return null;
        }
        String format = in.getAttributeValue(QNAME_FORMAT);
        if (format != null && !"dita".equals(format)) {
            return null;
        }
        return URLUtils.stripFragment(href);
    }

    private Optional<URI> getConref(XdmNode in) {
        return Optional.ofNullable(URLUtils.toURI(in.getAttributeValue(QNAME_CONREF))).map(URLUtils::stripFragment);
    }

    @Override
    List<XMLFilter> getProcessingPipe(URI fileToParse) {
        assert (fileToParse.isAbsolute());
        ArrayList<XMLFilter> pipe = new ArrayList<XMLFilter>();
        if (this.genDebugInfo) {
            DebugFilter debugFilter = new DebugFilter();
            debugFilter.setLogger(this.logger);
            debugFilter.setCurrentFile(this.currentFile);
            pipe.add(debugFilter);
        }
        if (this.filterUtils != null) {
            ProfilingFilter profilingFilter = new ProfilingFilter();
            profilingFilter.setLogger(this.logger);
            profilingFilter.setJob(this.job);
            profilingFilter.setFilterUtils(this.filterUtils);
            profilingFilter.setCurrentFile(fileToParse);
            pipe.add(profilingFilter);
        }
        ValidationFilter validationFilter = new ValidationFilter();
        validationFilter.setLogger(this.logger);
        validationFilter.setValidateMap(this.validateMap);
        validationFilter.setCurrentFile(fileToParse);
        validationFilter.setJob(this.job);
        validationFilter.setProcessingMode(this.processingMode);
        pipe.add(validationFilter);
        NormalizeFilter normalizeFilter = new NormalizeFilter();
        normalizeFilter.setLogger(this.logger);
        pipe.add(normalizeFilter);
        pipe.add(this.topicFragmentFilter);
        this.listFilter.setCurrentFile(fileToParse);
        this.listFilter.setErrorHandler(new DITAOTXMLErrorHandler(fileToParse.toString(), this.logger, this.processingMode));
        pipe.add(this.listFilter);
        this.ditaWriterFilter.setDefaultValueMap(this.defaultValueMap);
        this.ditaWriterFilter.setCurrentFile(this.currentFile);
        this.ditaWriterFilter.setOutputFile(this.outputFile);
        pipe.add(this.ditaWriterFilter);
        return pipe;
    }

    @Override
    void categorizeReferenceFile(GenListModuleReader.Reference file) {
        if (this.listFilter.getCoderefTargets().contains(file.filename)) {
            return;
        }
        if (this.formatFilter.test(file.format)) {
            if (GenListModuleReader.isFormatDita(file.format) && !this.job.crawlTopics() && !this.listFilter.getConrefTargets().contains(file.filename)) {
                return;
            }
            if (GenListModuleReader.isFormatDita(file.format) && (!this.job.getOnlyTopicInMap() || this.listFilter.getConrefTargets().contains(file.filename))) {
                this.addToWaitList(file);
            } else if ("image".equals(file.format)) {
                this.formatSet.add(file);
                if (!URLUtils.exists(file.filename)) {
                    if (this.processingMode == Configuration.Mode.STRICT) {
                        throw new UncheckedDITAOTException(MessageUtils.getMessage("DOTX008E", file.filename.toString()).toException());
                    }
                    this.logger.warn(MessageUtils.getMessage("DOTX008E", file.filename.toString()).toString());
                }
            } else {
                this.htmlSet.put((Object)file.format, (Object)file.filename);
            }
        }
    }
}

