/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dita.dost.platform.ExtensionPoint;
import org.dita.dost.platform.PluginRequirement;
import org.dita.dost.platform.Value;
import org.dita.dost.util.FileUtils;
import org.w3c.dom.Element;

final class Features {
    private String id;
    private final File pluginDir;
    private final File ditaDir;
    private final Map<String, ExtensionPoint> extensionPoints;
    private final Hashtable<String, List<String>> featureTable;
    private final List<PluginRequirement> requireList;
    private final Hashtable<String, String> metaTable;
    private final List<Value> templateList;

    public Features(File pluginDir, File ditaDir) {
        this.pluginDir = pluginDir;
        this.ditaDir = ditaDir;
        this.extensionPoints = new HashMap<String, ExtensionPoint>();
        this.featureTable = new Hashtable(16);
        this.requireList = new ArrayList<PluginRequirement>(8);
        this.metaTable = new Hashtable(16);
        this.templateList = new ArrayList<Value>(8);
    }

    public File getPluginDir() {
        return this.pluginDir;
    }

    public File getDitaDir() {
        return this.ditaDir;
    }

    void setPluginId(String id) {
        this.id = id;
    }

    String getPluginId() {
        return this.id;
    }

    Map<String, ExtensionPoint> getExtensionPoints() {
        return Collections.unmodifiableMap(this.extensionPoints);
    }

    public List<String> getFeature(String id) {
        return this.featureTable.get(id);
    }

    public Map<String, List<String>> getAllFeatures() {
        return this.featureTable;
    }

    void addExtensionPoint(ExtensionPoint extensionPoint) {
        this.extensionPoints.put(extensionPoint.id, extensionPoint);
    }

    public final void addFeature(String id, Element elem) {
        boolean isFile;
        String value = elem.getAttribute("file");
        if (!value.isEmpty()) {
            isFile = true;
        } else {
            value = elem.getAttribute("value");
            isFile = "file".equals(elem.getAttribute("type"));
        }
        StringTokenizer valueTokenizer = new StringTokenizer(value, ",");
        ArrayList<Object> valueBuffer = new ArrayList<Object>();
        if (this.featureTable.containsKey(id)) {
            valueBuffer.addAll((Collection)this.featureTable.get(id));
        }
        while (valueTokenizer.hasMoreElements()) {
            String valueElement = valueTokenizer.nextToken();
            if (valueElement == null || valueElement.trim().length() == 0) continue;
            if (isFile && !FileUtils.isAbsolutePath(valueElement)) {
                if (id.equals("ant.import")) {
                    valueBuffer.add("${dita.plugin." + this.id + ".dir}" + File.separator + valueElement.trim());
                    continue;
                }
                valueBuffer.add(this.pluginDir + File.separator + valueElement.trim());
                continue;
            }
            valueBuffer.add(valueElement.trim());
        }
        this.featureTable.put(id, valueBuffer);
    }

    public void addRequire(String id) {
        PluginRequirement requirement = new PluginRequirement();
        requirement.addPlugins(id);
        this.requireList.add(requirement);
    }

    public void addRequire(String id, String importance) {
        PluginRequirement requirement = new PluginRequirement();
        requirement.addPlugins(id);
        if (importance != null) {
            requirement.setRequired(importance.equals("required"));
        }
        this.requireList.add(requirement);
    }

    public Iterator<PluginRequirement> getRequireListIter() {
        return this.requireList.iterator();
    }

    public void addMeta(String type, String value) {
        this.metaTable.put(type, value);
    }

    public String getMeta(String type) {
        return this.metaTable.get(type);
    }

    public void addTemplate(Value file) {
        this.templateList.add(file);
    }

    public List<Value> getAllTemplates() {
        return this.templateList;
    }
}

