/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.dita.dost.platform.Features;
import org.dita.dost.platform.ImportAction;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

final class ImportPluginCatalogAction
extends ImportAction {
    private static final String PLUGIN_URI_SCHEME = "plugin";

    @Override
    public void getResult(ContentHandler buf) throws SAXException {
        File basePluginDir = ((Features)this.featureTable.get("org.dita.base")).getPluginDir();
        for (Map.Entry e : this.featureTable.entrySet()) {
            Features f = (Features)e.getValue();
            String name = "plugin:" + (String)e.getKey() + ":";
            StringBuilder location = new StringBuilder();
            List<String> baseDirValues = f.getFeature("dita.basedir-resource-directory");
            if (Boolean.parseBoolean(baseDirValues == null || baseDirValues.isEmpty() ? null : baseDirValues.get(0))) {
                location.append("./");
            } else if (f.getPluginDir().getAbsolutePath().startsWith(f.getDitaDir().getAbsolutePath())) {
                location.append(FileUtils.getRelativeUnixPath(new File(basePluginDir, "plugin.xml").toURI().toString(), f.getPluginDir().toURI().toString()));
            } else {
                location.append(f.getPluginDir().toURI());
            }
            if (location.length() > 0 && !location.substring(location.length() - 1).equals("/")) {
                location.append("/");
            }
            buf.startElement("urn:oasis:names:tc:entity:xmlns:xml:catalog", "rewriteURI", "rewriteURI", new XMLUtils.AttributesBuilder().add("uriStartString", name).add("rewritePrefix", location.toString()).build());
            buf.endElement("urn:oasis:names:tc:entity:xmlns:xml:catalog", "rewriteURI", "rewriteURI");
        }
    }
}

