/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.net.URI;
import org.dita.dost.platform.Features;
import org.dita.dost.platform.ImportAction;
import org.dita.dost.platform.Value;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

final class ImportXSLAction
extends ImportAction {
    ImportXSLAction() {
    }

    @Override
    public void getResult(ContentHandler buf) throws SAXException {
        for (Value value : this.valueSet) {
            URI href = this.getHref(value);
            buf.startElement("http://www.w3.org/1999/XSL/Transform", "import", "xsl:import", new XMLUtils.AttributesBuilder().add("href", href.toString()).build());
            buf.endElement("http://www.w3.org/1999/XSL/Transform", "import", "xsl:import");
        }
    }

    private URI getHref(Value value) {
        URI pluginDir = ((Features)this.featureTable.get(value.id())).getPluginDir().toURI();
        URI templateFile = URLUtils.toFile(value.value()).toURI().normalize();
        URI template = pluginDir.relativize(templateFile);
        if (value.id() == null || template.isAbsolute()) {
            String templateFilePath = (String)this.paramTable.get("template");
            return URLUtils.toURI(FileUtils.getRelativeUnixPath(templateFilePath, value.value()));
        }
        return URI.create("plugin:" + value.id() + ":" + template);
    }
}

