/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.io.FilenameUtils;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.index.IndexTermCollection;
import org.dita.dost.index.IndexTermTarget;
import org.dita.dost.index.TopicrefElement;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class DitamapIndexTermReader
extends AbstractXMLReader {
    private final Stack<Object> elementStack = new Stack();
    private final List<String> indexTermSpecList = new ArrayList<String>(16);
    private final List<String> topicrefSpecList = new ArrayList<String>(16);
    private final List<String> indexSeeSpecList = new ArrayList<String>(16);
    private final List<String> indexSeeAlsoSpecList = new ArrayList<String>(16);
    private String mapPath = null;
    private final IndexTermCollection result;
    private boolean indexMoved = true;

    public DitamapIndexTermReader(IndexTermCollection result, boolean indexMoved) {
        this.result = result;
        this.indexMoved = indexMoved;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        Object temp = new String(ch, start, length);
        if (ch[start] == '\n' || ((String)temp).startsWith(Constants.LINE_SEPARATOR)) {
            temp = " " + ((String)temp).substring(1);
        }
        char[] chars = ((String)temp).toCharArray();
        int flag = 10;
        StringBuilder sb = new StringBuilder();
        for (int n : chars) {
            if (n == 32) {
                if (flag == 32) continue;
                sb.append((char)n);
                flag = n;
                continue;
            }
            sb.append((char)n);
            flag = n;
        }
        temp = sb.toString();
        if (this.elementStack.empty() || !(this.elementStack.peek() instanceof IndexTerm)) {
            return;
        }
        IndexTerm indexTerm = (IndexTerm)this.elementStack.peek();
        indexTerm.setTermName(StringUtils.setOrAppend(indexTerm.getTermName(), (String)temp, false));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.topicrefSpecList.contains(localName)) {
            this.elementStack.pop();
            return;
        }
        if (this.indexTermSpecList.contains(localName) && this.needPushTerm()) {
            Object obj;
            IndexTerm indexTerm = (IndexTerm)this.elementStack.pop();
            if (indexTerm.getTermName() == null || indexTerm.getTermName().trim().equals("")) {
                if (indexTerm.getEndAttribute() != null && !indexTerm.hasSubTerms()) {
                    return;
                }
                indexTerm.setTermName("***");
                this.logger.warn(MessageUtils.getMessage("DOTJ014W", new String[0]).toString());
            }
            if (indexTerm.getTermKey() == null) {
                indexTerm.setTermKey(indexTerm.getTermName());
            }
            if ((obj = this.elementStack.peek()) instanceof TopicrefElement) {
                if (((TopicrefElement)obj).getHref() != null) {
                    this.genTargets(indexTerm, (TopicrefElement)obj);
                    this.result.addTerm(indexTerm);
                }
            } else {
                IndexTerm parentTerm = (IndexTerm)obj;
                parentTerm.addSubTerm(indexTerm);
            }
        }
        if (this.indexSeeSpecList.contains(localName) || this.indexSeeAlsoSpecList.contains(localName)) {
            Object object;
            IndexTerm term = (IndexTerm)this.elementStack.pop();
            if (term.getTermKey() == null) {
                term.setTermKey(term.getTermFullName());
            }
            if ((object = this.elementStack.peek()) instanceof IndexTerm) {
                IndexTerm parentTerm = (IndexTerm)object;
                parentTerm.addSubTerm(term);
            }
        }
    }

    private void genTargets(IndexTerm indexTerm, TopicrefElement obj) {
        String targetURI;
        IndexTermTarget target = new IndexTermTarget();
        String href = obj.getHref();
        StringBuilder buffer = new StringBuilder();
        if (!href.contains("://") && !FileUtils.isAbsolutePath(href)) {
            if (this.mapPath != null && this.mapPath.length() != 0) {
                buffer.append(this.mapPath);
                buffer.append("/");
            }
            buffer.append(href);
            targetURI = new File(FilenameUtils.normalize((String)buffer.toString())).getPath();
        } else {
            targetURI = href;
        }
        if (obj.getNavTitle() != null) {
            target.setTargetName(obj.getNavTitle());
        } else {
            target.setTargetName(href);
        }
        target.setTargetURI(targetURI);
        this.assignTarget(indexTerm, target);
    }

    private void assignTarget(IndexTerm indexTerm, IndexTermTarget target) {
        if (indexTerm.isLeaf()) {
            indexTerm.addTarget(target);
        }
        if (indexTerm.hasSubTerms()) {
            for (IndexTerm subTerm : indexTerm.getSubTerms()) {
                this.assignTarget(subTerm, target);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String classAttr = attributes.getValue("class");
        if (classAttr != null && Constants.TOPIC_INDEXTERM.matches(classAttr) && !this.indexTermSpecList.contains(localName)) {
            this.indexTermSpecList.add(localName);
        }
        if (classAttr != null && Constants.MAP_TOPICREF.matches(classAttr) && !this.topicrefSpecList.contains(localName)) {
            this.topicrefSpecList.add(localName);
        }
        if (classAttr != null && Constants.INDEXING_D_INDEX_SEE.matches(classAttr) && !this.indexSeeSpecList.contains(localName)) {
            this.indexSeeSpecList.add(localName);
        }
        if (classAttr != null && Constants.INDEXING_D_INDEX_SEE_ALSO.matches(classAttr) && !this.indexSeeAlsoSpecList.contains(localName)) {
            this.indexSeeAlsoSpecList.add(localName);
        }
        if (this.topicrefSpecList.contains(localName)) {
            String href = attributes.getValue("href");
            String format = attributes.getValue("format");
            String navtitle = attributes.getValue("navtitle");
            TopicrefElement topicref = new TopicrefElement();
            topicref.setHref(href);
            topicref.setFormat(format);
            topicref.setNavTitle(navtitle);
            this.elementStack.push(topicref);
            return;
        }
        this.parseIndexTerm(localName, attributes);
        this.parseIndexSee(localName);
        this.parseIndexSeeAlso(localName);
    }

    private void parseIndexSeeAlso(String localName) {
        if (this.indexSeeAlsoSpecList.contains(localName) && this.needPushTerm()) {
            IndexTerm parentTerm;
            IndexTerm indexTerm = new IndexTerm();
            if (!this.elementStack.isEmpty() && this.elementStack.peek() instanceof IndexTerm && (parentTerm = (IndexTerm)this.elementStack.peek()).hasSubTerms()) {
                parentTerm.updateSubTerm();
            }
            indexTerm.setTermPrefix(IndexTerm.IndexTermPrefix.SEE_ALSO);
            this.elementStack.push(indexTerm);
        }
    }

    private void parseIndexSee(String localName) {
        if (this.indexSeeSpecList.contains(localName) && this.needPushTerm()) {
            IndexTerm parentTerm;
            IndexTerm indexTerm = new IndexTerm();
            indexTerm.setTermPrefix(IndexTerm.IndexTermPrefix.SEE);
            if (!this.elementStack.isEmpty() && this.elementStack.peek() instanceof IndexTerm && (parentTerm = (IndexTerm)this.elementStack.peek()).hasSubTerms()) {
                parentTerm.updateSubTerm();
                indexTerm.setTermPrefix(IndexTerm.IndexTermPrefix.SEE_ALSO);
            }
            this.elementStack.push(indexTerm);
        }
    }

    private void parseIndexTerm(String localName, Attributes attributes) {
        if (this.indexTermSpecList.contains(localName) && this.needPushTerm()) {
            IndexTerm parentTerm;
            IndexTerm indexTerm = new IndexTerm();
            indexTerm.setStartAttribute(attributes.getValue("end"));
            indexTerm.setEndAttribute(attributes.getValue("end"));
            if (!this.elementStack.isEmpty() && this.elementStack.peek() instanceof IndexTerm && (parentTerm = (IndexTerm)this.elementStack.peek()).hasSubTerms()) {
                parentTerm.updateSubTerm();
            }
            this.elementStack.push(indexTerm);
        }
    }

    private boolean needPushTerm() {
        if (this.elementStack.empty()) {
            return false;
        }
        Object object = this.elementStack.peek();
        if (object instanceof TopicrefElement) {
            TopicrefElement elem = (TopicrefElement)object;
            if (this.indexMoved && (elem.getFormat() == null || elem.getFormat().equals("dita") || elem.getFormat().equals("ditamap"))) {
                return false;
            }
        }
        return true;
    }

    public void setMapPath(String mappath) {
        this.mapPath = mappath;
    }
}

