/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class DitaIndexWriter
extends AbstractXMLWriter {
    private boolean hasMetadataTillNow = false;
    private boolean hasPrologTillNow = false;
    private String indexEntries = null;
    private List<String> matchList = null;
    private OutputStreamWriter output = null;
    private final XMLReader reader;
    private boolean startTopic = false;
    private final List<String> topicIdList = new ArrayList<String>(16);
    private boolean hasWritten = false;
    private int topicLevel = -1;

    public DitaIndexWriter() {
        try {
            this.reader = XMLUtils.getXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize XML parser: " + e.getMessage(), e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.writeCharacters(ch, start, length);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    private boolean checkMatch() {
        if (this.matchList == null) {
            return true;
        }
        int matchSize = this.matchList.size();
        int ancestorSize = this.topicIdList.size();
        List<String> tail = this.topicIdList.subList(ancestorSize - matchSize, ancestorSize);
        return this.matchList.equals(tail);
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.output.flush();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.startTopic) {
            this.topicIdList.remove(this.topicIdList.size() - 1);
        }
        try {
            if (!this.hasMetadataTillNow && Constants.TOPIC_PROLOG.localName.equals(qName) && this.startTopic && !this.hasWritten) {
                this.writeStartElement(Constants.TOPIC_METADATA.localName, new XMLUtils.AttributesBuilder().add("class", Constants.TOPIC_METADATA.toString()).build());
                this.output.write(this.indexEntries);
                this.writeEndElement(Constants.TOPIC_METADATA.localName);
                this.hasMetadataTillNow = true;
                this.hasWritten = true;
            }
            this.writeEndElement(qName);
            if (!this.hasPrologTillNow && this.startTopic && !this.hasWritten) {
                this.writeStartElement(Constants.TOPIC_PROLOG.localName, new XMLUtils.AttributesBuilder().add("class", Constants.TOPIC_PROLOG.toString()).build());
                this.writeStartElement(Constants.TOPIC_METADATA.localName, new XMLUtils.AttributesBuilder().add("class", Constants.TOPIC_METADATA.toString()).build());
                this.output.write(this.indexEntries);
                this.writeEndElement(Constants.TOPIC_METADATA.localName);
                this.writeEndElement(Constants.TOPIC_PROLOG.localName);
                this.hasPrologTillNow = true;
                this.hasWritten = true;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    private boolean hasMetadata(String qName) {
        return !this.hasPrologTillNow || this.hasMetadataTillNow || !Constants.TOPIC_RESOURCEID.localName.equals(qName);
    }

    private boolean hasProlog(Attributes atts) {
        if (atts.getValue("class") != null && !this.hasPrologTillNow) {
            if (atts.getValue("class").contains(Constants.TOPIC_BODY.matcher)) {
                return false;
            }
            if (atts.getValue("class").contains(Constants.TOPIC_RELATED_LINKS.matcher)) {
                return false;
            }
            if (atts.getValue("class").contains(Constants.TOPIC_TOPIC.matcher)) {
                if (this.topicLevel > 0) {
                    ++this.topicLevel;
                } else if (this.topicLevel == -1) {
                    this.topicLevel = 1;
                } else {
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.writeCharacters(ch, start, length);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.writeProcessingInstruction(target, data);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    public void setIndexEntries(String indexEntries) {
        this.indexEntries = indexEntries;
    }

    private void setMatch(String match) {
        int index = 0;
        this.matchList = new ArrayList<String>(16);
        while (index != -1) {
            int end = match.indexOf("/", index);
            if (end == -1) {
                this.matchList.add(match.substring(index));
                index = end;
                continue;
            }
            this.matchList.add(match.substring(index, end));
            index = end + 1;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (this.topicLevel != -1 && !this.hasProlog(atts) && this.startTopic && !this.hasWritten) {
                this.writeStartElement(Constants.TOPIC_PROLOG.localName, new XMLUtils.AttributesBuilder().add("class", Constants.TOPIC_PROLOG.toString()).build());
                this.writeStartElement(Constants.TOPIC_METADATA.localName, new XMLUtils.AttributesBuilder().add("class", Constants.TOPIC_METADATA.toString()).build());
                this.output.write(this.indexEntries);
                this.writeEndElement(Constants.TOPIC_METADATA.localName);
                this.writeEndElement(Constants.TOPIC_PROLOG.localName);
                this.hasPrologTillNow = true;
                this.hasWritten = true;
            }
            if (!this.startTopic && !"dita".equals(qName)) {
                if (atts.getValue("id") != null) {
                    this.topicIdList.add(atts.getValue("id"));
                } else {
                    this.topicIdList.add("null");
                }
                if (this.topicIdList.size() >= this.matchList.size()) {
                    this.startTopic = this.checkMatch();
                }
            }
            if (!this.hasMetadata(qName) && this.startTopic && !this.hasWritten) {
                this.writeStartElement(Constants.TOPIC_METADATA.localName, new XMLUtils.AttributesBuilder().add("class", Constants.TOPIC_METADATA.toString()).build());
                this.output.write(this.indexEntries);
                this.writeEndElement(Constants.TOPIC_METADATA.localName);
                this.hasMetadataTillNow = true;
                this.hasWritten = true;
            }
            this.writeStartElement(qName, atts);
            if (atts.getValue("class") != null) {
                if (atts.getValue("class").contains(Constants.TOPIC_METADATA.matcher) && this.startTopic && !this.hasWritten) {
                    this.hasMetadataTillNow = true;
                    this.output.write(this.indexEntries);
                    this.hasWritten = true;
                }
                if (atts.getValue("class").contains(Constants.TOPIC_PROLOG.matcher)) {
                    this.hasPrologTillNow = true;
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File outputFilename) {
        String filename = outputFilename.getAbsolutePath();
        File inputFile = null;
        File outputFile = null;
        try {
            String file;
            if (filename.endsWith("#")) {
                filename = filename.substring(0, filename.length() - 1);
            }
            if (filename.lastIndexOf("#") != -1) {
                file = filename.substring(0, filename.lastIndexOf("#"));
                String topic = filename.substring(filename.lastIndexOf("#") + 1);
                this.setMatch(topic);
                this.startTopic = false;
            } else {
                file = filename;
                this.matchList = null;
                this.startTopic = true;
            }
            this.hasPrologTillNow = false;
            this.hasMetadataTillNow = false;
            this.hasWritten = false;
            inputFile = new File(file);
            outputFile = new File(file + ".temp");
            this.output = new OutputStreamWriter(this.job.getStore().getOutputStream(outputFile.toURI()), StandardCharsets.UTF_8);
            this.topicIdList.clear();
            this.reader.setErrorHandler(new DITAOTXMLErrorHandler(file, this.logger, Configuration.Mode.STRICT));
            this.reader.parse(file);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
        finally {
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
        }
        try {
            FileUtils.deleteQuietly(inputFile);
            FileUtils.moveFile(outputFile, inputFile);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Failed to replace " + inputFile + ": " + e.getMessage());
        }
    }

    private void writeStartElement(String qName, Attributes atts) throws IOException {
        int attsLen = atts.getLength();
        this.output.write("<" + qName);
        for (int i = 0; i < attsLen; ++i) {
            String attQName = atts.getQName(i);
            String attValue = XMLUtils.escapeXML(atts.getValue(i));
            this.output.write(" " + attQName + "=\"" + attValue + "\"");
        }
        this.output.write(">");
    }

    private void writeEndElement(String qName) throws IOException {
        this.output.write("</" + qName + ">");
    }

    private void writeCharacters(char[] ch, int start, int length) throws IOException {
        this.output.write(XMLUtils.escapeXML(ch, start, length));
    }

    private void writeProcessingInstruction(String target, String data) throws IOException {
        String pi = data != null ? target + " " + data : target;
        this.output.write("<?" + pi + "?>");
    }
}

