/*
 * Decompiled with CFR 0.152.
 */
package org.ditang.relaxng.defaults;

import com.thaiopensource.relaxng.pattern.DefaultValuesExtractor;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ditang.relaxng.defaults.OxygenRelaxNGSchemaReader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class RelaxNGDefaultValues {
    private final ErrorHandler eh;
    private final Resolver resolver;
    private final boolean keepSchema;
    private DefaultValuesCollector defaultValuesCollector = null;
    private boolean hasUpdateErrors;
    private OxygenRelaxNGSchemaReader.SchemaWrapper schema;

    protected RelaxNGDefaultValues(Resolver resolver, ErrorHandler eh) {
        this(resolver, eh, false);
    }

    protected RelaxNGDefaultValues(Resolver resolver, ErrorHandler eh, boolean keepSchema) {
        this.resolver = resolver;
        this.eh = eh;
        this.keepSchema = keepSchema;
    }

    protected abstract SchemaReader getSchemaReader();

    public void update(InputSource in) throws SAXException {
        this.defaultValuesCollector = null;
        PropertyMapBuilder builder = new PropertyMapBuilder();
        builder.put(ValidateProperty.RESOLVER, (Object)this.resolver);
        builder.put(ValidateProperty.ERROR_HANDLER, (Object)this.eh);
        PropertyMap properties = builder.toPropertyMap();
        try {
            OxygenRelaxNGSchemaReader.SchemaWrapper sw = (OxygenRelaxNGSchemaReader.SchemaWrapper)this.getSchemaReader().createSchema(in, properties);
            if (this.keepSchema) {
                this.schema = sw;
            }
            Pattern start = sw.getStart();
            this.defaultValuesCollector = new DefaultValuesCollector(start);
            this.hasUpdateErrors = false;
        }
        catch (Exception e) {
            this.hasUpdateErrors = true;
            this.eh.warning(new SAXParseException("Error loading defaults: " + e.getMessage(), null, e));
        }
    }

    public boolean hasUpdateErrors() {
        return this.hasUpdateErrors;
    }

    public List<Attribute> getDefaultAttributes(String localName, String namespace) {
        if (this.defaultValuesCollector != null) {
            return this.defaultValuesCollector.getDefaultAttributes(localName, namespace);
        }
        return null;
    }

    public Validator createValidator(PropertyMap properties) {
        return this.schema.createValidator(properties);
    }

    public boolean isKeepSchema() {
        return this.keepSchema;
    }

    class DefaultValuesCollector
    implements DefaultValuesExtractor.DefaultValuesListener {
        private final HashMap<String, List<Attribute>> defaults = new HashMap();

        public DefaultValuesCollector(Pattern start) {
            new DefaultValuesExtractor((DefaultValuesExtractor.DefaultValuesListener)this).parsePattern(start);
        }

        private String getKey(String elementLocalName, String elementNamespace) {
            return elementLocalName + "#" + (elementNamespace == null ? "" : elementNamespace);
        }

        private List<Attribute> getDefaultAttributes(String elementLocalName, String elementNamespace) {
            return this.defaults.get(this.getKey(elementLocalName, elementNamespace));
        }

        public void defaultValue(String elementLocalName, String elementNamespace, String attributeLocalName, String attributeNamepsace, String value) {
            String key = this.getKey(elementLocalName, elementNamespace);
            List list = this.defaults.computeIfAbsent(key, k -> new ArrayList());
            list.add(new Attribute(attributeLocalName, attributeNamepsace, value));
        }
    }

    class Attribute {
        final String localName;
        final String namespace;
        final String value;

        public Attribute(String localName, String namespace, String value) {
            this.localName = localName;
            this.namespace = namespace;
            this.value = value;
        }
    }
}

