/*
 * Decompiled with CFR 0.152.
 */
package org.ditang.relaxng.defaults;

import com.thaiopensource.resolver.BasicResolver;
import com.thaiopensource.resolver.Identifier;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.ResolverException;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.ditang.relaxng.defaults.RNCDefaultValues;
import org.ditang.relaxng.defaults.RNGDefaultValues;
import org.ditang.relaxng.defaults.RelaxNGDefaultValues;
import org.ditang.relaxng.defaults.pool.RNGDefaultsEnabledGrammarPool;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class RelaxNGDefaultsComponent
implements XMLDocumentHandler,
XMLComponent,
XMLDocumentSource {
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final String[] RECOGNIZED_FEATURES = new String[0];
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[0];
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/error-handler", "http://apache.org/xml/properties/internal/entity-resolver"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, null, null};
    private XMLDocumentHandler documentHandler;
    private XMLDocumentSource documentSource;
    private boolean detecting = false;
    private String schema = null;
    private String type = null;
    private String baseSystemId = null;
    private RelaxNGDefaultValues defaults;
    private NamespaceContext context;
    private SymbolTable fSymbolTable;
    private XMLEntityResolver fResolver;
    public static final boolean DEBUG = false;
    private Resolver resolver;
    private final XMLGrammarPool grammarPool;
    private boolean validate = false;
    private Validator validator;
    private XMLLocator locator;
    private XMLErrorHandler errorHandler;
    private final Stack<Set<String>> prefixMappingStack = new Stack();
    private static final String NS_MAPPING_DEFAULT = "xmlns";
    private static final String NS_MAPPING_PREFIX = "xmlns:";

    public RelaxNGDefaultsComponent(Resolver resolver, XMLGrammarPool grammarPool) {
        this.resolver = resolver;
        this.grammarPool = grammarPool;
        if (this.resolver == null) {
            this.resolver = new Resolver(){

                public void resolve(Identifier id, Input input) throws IOException, ResolverException {
                    if (RelaxNGDefaultsComponent.this.fResolver != null) {
                        String expanded = id.getUriReference();
                        try {
                            expanded = new URL(new URL(id.getBase()), id.getUriReference()).toString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        XMLResourceIdentifierImpl identifier = new XMLResourceIdentifierImpl(null, id.getUriReference(), id.getBase(), expanded);
                        XMLInputSource resolved = RelaxNGDefaultsComponent.this.fResolver.resolveEntity((XMLResourceIdentifier)identifier);
                        if (resolved != null) {
                            input.setUri(resolved.getSystemId());
                            input.setByteStream(resolved.getByteStream());
                            input.setCharacterStream(resolved.getCharacterStream());
                            input.setEncoding(resolved.getEncoding());
                        }
                    }
                }

                public void open(Input input) throws IOException, ResolverException {
                    BasicResolver.getInstance().open(input);
                }
            };
        }
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        this.baseSystemId = null;
        this.detecting = false;
        this.schema = null;
        this.type = null;
        this.context = null;
        this.defaults = null;
        this.validator = null;
        this.prefixMappingStack.clear();
        this.locator = null;
        this.fSymbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        this.fResolver = (XMLEntityResolver)componentManager.getProperty(ENTITY_RESOLVER);
    }

    public void startDocument(XMLLocator locator, String enc, NamespaceContext nc, Augmentations aug) throws XNIException {
        this.locator = locator;
        this.context = nc;
        this.baseSystemId = locator.getBaseSystemId();
        this.detecting = true;
        this.schema = null;
        this.type = null;
        if (this.documentHandler != null) {
            this.documentHandler.startDocument(locator, enc, nc, aug);
        }
    }

    public void startElement(QName name, XMLAttributes atts, Augmentations aug) throws XNIException {
        boolean oldDetecting = this.detecting;
        this.onStartElement(name, atts);
        if (this.documentHandler != null) {
            this.documentHandler.startElement(name, atts, aug);
        }
        if (this.validator != null) {
            try {
                if (this.detecting != oldDetecting) {
                    this.triggerStartDocumentToValidator();
                }
                this.startElementToValidator(name, atts);
            }
            catch (SAXException e) {
                throw new XNIException((Exception)e);
            }
        }
    }

    private void startElementToValidator(QName name, XMLAttributes atts) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        HashSet<String> prefixes = null;
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            String qName = atts.getQName(i);
            if (qName.startsWith(NS_MAPPING_PREFIX) || qName.equals(NS_MAPPING_DEFAULT)) {
                String value;
                if (prefixes == null) {
                    prefixes = new HashSet<String>();
                }
                if ((value = atts.getValue(i)) == null) {
                    value = "";
                }
                String prefix = "";
                if (qName.startsWith(NS_MAPPING_PREFIX)) {
                    prefix = qName.substring(NS_MAPPING_PREFIX.length());
                }
                this.validator.getContentHandler().startPrefixMapping(prefix, value);
                prefixes.add(prefix);
                continue;
            }
            attrs.addAttribute(atts.getURI(i) != null ? atts.getURI(i) : "", atts.getLocalName(i), atts.getQName(i), atts.getType(i), atts.getValue(i));
        }
        this.prefixMappingStack.push(prefixes);
        this.validator.getContentHandler().startElement(name.uri != null ? name.uri : "", name.localpart, name.rawname, attrs);
    }

    private void triggerStartDocumentToValidator() throws SAXException {
        if (this.locator != null) {
            this.validator.getContentHandler().setDocumentLocator(new Locator(){

                @Override
                public String getSystemId() {
                    return RelaxNGDefaultsComponent.this.locator.getExpandedSystemId();
                }

                @Override
                public String getPublicId() {
                    return RelaxNGDefaultsComponent.this.locator.getPublicId();
                }

                @Override
                public int getLineNumber() {
                    return RelaxNGDefaultsComponent.this.locator.getLineNumber();
                }

                @Override
                public int getColumnNumber() {
                    return RelaxNGDefaultsComponent.this.locator.getColumnNumber();
                }
            });
        }
        this.validator.getContentHandler().startDocument();
    }

    private void onStartElement(QName name, XMLAttributes atts) {
        if (this.detecting) {
            if ("http://relaxng.org/ns/structure/1.0".equals(name.uri)) {
                this.defaults = null;
            } else {
                this.loadDefaults();
            }
            this.detecting = false;
        }
        if (this.defaults != null) {
            this.checkAndAddDefaults(name, atts);
        }
    }

    private void loadDefaults() {
        this.defaults = null;
        ErrorHandler eh = new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                if (RelaxNGDefaultsComponent.this.validate) {
                    if (RelaxNGDefaultsComponent.this.errorHandler != null) {
                        RelaxNGDefaultsComponent.this.errorHandler.warning("", "", new XMLParseException(RelaxNGDefaultsComponent.this.locator, exception.getMessage(), (Exception)exception));
                    } else {
                        throw exception;
                    }
                }
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                if (RelaxNGDefaultsComponent.this.validate) {
                    if (RelaxNGDefaultsComponent.this.errorHandler != null) {
                        RelaxNGDefaultsComponent.this.errorHandler.error("", "", new XMLParseException(RelaxNGDefaultsComponent.this.locator, exception.getMessage(), (Exception)exception));
                    } else {
                        throw exception;
                    }
                }
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                if (RelaxNGDefaultsComponent.this.validate) {
                    if (RelaxNGDefaultsComponent.this.errorHandler != null) {
                        RelaxNGDefaultsComponent.this.errorHandler.fatalError("", "", new XMLParseException(RelaxNGDefaultsComponent.this.locator, exception.getMessage(), (Exception)exception));
                    } else {
                        throw exception;
                    }
                }
            }
        };
        if (this.schema != null && ("xml".equals(this.type) || "compact".equals(this.type))) {
            Identifier id = new Identifier(this.schema, this.baseSystemId);
            Input input = new Input();
            try {
                this.resolver.resolve(id, input);
            }
            catch (ResolverException | IOException throwable) {
                // empty catch block
            }
            InputSource in = null;
            if (input.isResolved()) {
                in = new InputSource(input.getUri());
                in.setByteStream(input.getByteStream());
                in.setCharacterStream(input.getCharacterStream());
                in.setEncoding(input.getEncoding());
            } else {
                String expanded = this.schema;
                try {
                    expanded = new URL(new URL(this.baseSystemId), this.schema).toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                in = new InputSource(expanded);
            }
            try {
                RelaxNGDefaultValues cachedDefaults;
                RNGDefaultsEnabledGrammarPool pool = null;
                if (this.grammarPool instanceof RNGDefaultsEnabledGrammarPool) {
                    pool = (RNGDefaultsEnabledGrammarPool)this.grammarPool;
                }
                RelaxNGDefaultValues relaxNGDefaultValues = cachedDefaults = pool != null ? pool.getRngDefaultValues(in.getSystemId()) : null;
                if (cachedDefaults != null && (cachedDefaults.isKeepSchema() || !this.validate)) {
                    this.defaults = cachedDefaults;
                } else {
                    this.defaults = "xml".equals(this.type) ? new RNGDefaultValues(this.resolver, eh, this.validate) : new RNCDefaultValues(this.resolver, eh, this.validate);
                    this.defaults.update(in);
                    if (pool != null && !this.defaults.hasUpdateErrors()) {
                        pool.putRngDefaultValues(in.getSystemId(), this.defaults);
                    }
                }
                if (this.validate && this.defaults != null) {
                    PropertyMapBuilder builder = new PropertyMapBuilder();
                    builder.put(ValidateProperty.RESOLVER, (Object)this.resolver);
                    builder.put(ValidateProperty.ERROR_HANDLER, (Object)eh);
                    this.validator = this.defaults.createValidator(builder.toPropertyMap());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void checkAndAddDefaults(QName name, XMLAttributes atts) {
        List<RelaxNGDefaultValues.Attribute> def = this.defaults.getDefaultAttributes(name.localpart, name.uri);
        if (def != null) {
            for (RelaxNGDefaultValues.Attribute a : def) {
                boolean alreadyDeclared = false;
                boolean bl = alreadyDeclared = atts.getIndex(a.namespace, a.localName) >= 0;
                if (!alreadyDeclared && "".equals(a.namespace)) {
                    boolean bl2 = alreadyDeclared = atts.getIndex(null, a.localName) >= 0;
                }
                if (alreadyDeclared) continue;
                Object prefix = null;
                Object rawname = a.localName;
                if (a.namespace != null && a.namespace.length() > 0) {
                    prefix = this.context.getPrefix(a.namespace);
                    if (prefix == null) {
                        for (int i = 0; i < atts.getLength(); ++i) {
                            String attname = atts.getQName(i);
                            if (!attname.startsWith(NS_MAPPING_PREFIX) || !a.namespace.equals(atts.getValue(i))) continue;
                            prefix = attname.substring(6);
                        }
                    }
                    if (prefix != null && ((String)prefix).length() > 0) {
                        rawname = (String)prefix + ":" + a.localName;
                        if (atts.getIndex((String)rawname) >= 0) continue;
                        QName attName = new QName(this.fSymbolTable.addSymbol((String)prefix), this.fSymbolTable.addSymbol(a.localName), this.fSymbolTable.addSymbol((String)rawname), this.fSymbolTable.addSymbol(a.namespace));
                        atts.addAttribute(attName, "CDATA", a.value);
                        int attrIndex = atts.getIndex(attName.uri, attName.localpart);
                        atts.setSpecified(attrIndex, false);
                        continue;
                    }
                    int k = 1;
                    prefix = "http://dita.oasis-open.org/architecture/2005/".equals(a.namespace) ? "ditaarch" : "ns" + k;
                    while (this.context.getURI((String)prefix) != null || atts.getValue(NS_MAPPING_PREFIX + (String)prefix) != null) {
                        prefix = "ns" + ++k;
                    }
                    rawname = (String)prefix + ":" + a.localName;
                    QName attNs = new QName(this.fSymbolTable.addSymbol(NS_MAPPING_DEFAULT), this.fSymbolTable.addSymbol((String)prefix), this.fSymbolTable.addSymbol(NS_MAPPING_PREFIX + (String)prefix), this.fSymbolTable.addSymbol("http://www.w3.org/2000/xmlns/"));
                    atts.addAttribute(attNs, "CDATA", a.namespace);
                    this.context.declarePrefix((String)prefix, a.namespace);
                    QName attName = new QName(this.fSymbolTable.addSymbol((String)prefix), this.fSymbolTable.addSymbol(a.localName), this.fSymbolTable.addSymbol((String)rawname), this.fSymbolTable.addSymbol(a.namespace));
                    atts.addAttribute(attName, "CDATA", a.value);
                    int attrIndex = atts.getIndex(attName.uri, attName.localpart);
                    atts.setSpecified(attrIndex, false);
                    continue;
                }
                String attname = this.fSymbolTable.addSymbol(a.localName);
                QName attName = new QName(null, attname, attname, null);
                atts.addAttribute(attName, "CDATA", a.value);
                int attrIndex = atts.getIndex(attname);
                atts.setSpecified(attrIndex, false);
            }
        }
    }

    public void xmlDecl(String arg0, String arg1, String arg2, Augmentations arg3) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.xmlDecl(arg0, arg1, arg2, arg3);
        }
    }

    public void doctypeDecl(String arg0, String arg1, String arg2, Augmentations arg3) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.doctypeDecl(arg0, arg1, arg2, arg3);
        }
    }

    public void comment(XMLString arg0, Augmentations arg1) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.comment(arg0, arg1);
        }
    }

    public void processingInstruction(String name, XMLString content, Augmentations arg2) throws XNIException {
        String data;
        boolean detectedSchema = false;
        if (this.detecting && this.schema == null && "oxygen".equals(name)) {
            data = content.toString();
            this.schema = this.getFromPIDataPseudoAttribute(data, "RNGSchema", true);
            this.type = this.getFromPIDataPseudoAttribute(data, "type", true);
            detectedSchema = true;
        }
        if (this.detecting && this.schema == null && "xml-model".equals(name)) {
            data = content.toString();
            this.schema = this.getFromPIDataPseudoAttribute(data, "href", true);
            this.type = this.getFromPIDataPseudoAttribute(data, "type", true);
            String schemaTypeNs = this.getFromPIDataPseudoAttribute(data, "schematypens", true);
            if (this.schema != null) {
                if (this.schema.toLowerCase().endsWith(".rng")) {
                    if (this.nullOrValue(schemaTypeNs, "http://relaxng.org/ns/structure/1.0") && this.nullOrValue(this.type, "application/xml")) {
                        this.type = "xml";
                    } else {
                        this.schema = null;
                    }
                } else if (this.schema.toLowerCase().endsWith(".rnc")) {
                    if (this.nullOrValue(schemaTypeNs, "http://relaxng.org/ns/structure/1.0") && this.nullOrValue(this.type, "application/relax-ng-compact-syntax")) {
                        this.type = "compact";
                    } else {
                        this.schema = null;
                    }
                } else if ("http://relaxng.org/ns/structure/1.0".equals(schemaTypeNs) && this.nullOrValue(this.type, "application/xml")) {
                    this.type = "xml";
                } else if ("application/relax-ng-compact-syntax".equals(this.type) && this.nullOrValue(schemaTypeNs, "http://relaxng.org/ns/structure/1.0")) {
                    this.type = "compact";
                } else {
                    this.schema = null;
                }
            }
            detectedSchema = true;
        }
        if (this.documentHandler != null && !detectedSchema) {
            this.documentHandler.processingInstruction(name, content, arg2);
        }
    }

    private boolean nullOrValue(String test, String value) {
        if (test == null) {
            return true;
        }
        return test.equals(value);
    }

    private String getFromPIDataPseudoAttribute(String data, String name, boolean unescapeValue) {
        int pos = 0;
        while (pos <= data.length() - 4) {
            int nextQuote = -1;
            for (int q = pos; q < data.length(); ++q) {
                if (data.charAt(q) != '\"' && data.charAt(q) != '\'') continue;
                nextQuote = q;
                break;
            }
            if (nextQuote < 0) {
                return null;
            }
            int closingQuote = data.indexOf(data.charAt(nextQuote), nextQuote + 1);
            if (closingQuote < 0) {
                return null;
            }
            int nextName = data.indexOf(name, pos);
            if (nextName < 0) {
                return null;
            }
            if (nextName < nextQuote) {
                boolean found = true;
                for (int s = nextName + name.length(); s < nextQuote; ++s) {
                    char c = data.charAt(s);
                    if (Character.isWhitespace(c) || c == '=') continue;
                    found = false;
                    break;
                }
                if (found) {
                    String val = data.substring(nextQuote + 1, closingQuote);
                    return unescapeValue ? this.unescape(val) : val;
                }
            }
            pos = closingQuote + 1;
        }
        return null;
    }

    private String unescape(String value) {
        if (value.indexOf(38) < 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '&') {
                if (i + 2 < value.length() && value.charAt(i + 1) == '#') {
                    int digit;
                    int x;
                    int charval;
                    if (value.charAt(i + 2) == 'x') {
                        charval = 0;
                        for (x = i + 3; x < value.length() && value.charAt(x) != ';'; ++x) {
                            digit = "0123456789abcdef".indexOf(value.charAt(x));
                            if (digit < 0) {
                                digit = "0123456789ABCDEF".indexOf(value.charAt(x));
                            }
                            if (digit < 0) {
                                return null;
                            }
                            charval = charval * 16 + digit;
                        }
                        char hexchar = (char)charval;
                        sb.append(hexchar);
                        i = x;
                        continue;
                    }
                    charval = 0;
                    for (x = i + 2; x < value.length() && value.charAt(x) != ';'; ++x) {
                        digit = "0123456789".indexOf(value.charAt(x));
                        if (digit < 0) {
                            return null;
                        }
                        charval = charval * 10 + digit;
                    }
                    char decchar = (char)charval;
                    sb.append(decchar);
                    i = x;
                    continue;
                }
                if (value.substring(i + 1).startsWith("lt;")) {
                    sb.append('<');
                    i += 3;
                    continue;
                }
                if (value.substring(i + 1).startsWith("gt;")) {
                    sb.append('>');
                    i += 3;
                    continue;
                }
                if (value.substring(i + 1).startsWith("amp;")) {
                    sb.append('&');
                    i += 4;
                    continue;
                }
                if (value.substring(i + 1).startsWith("quot;")) {
                    sb.append('\"');
                    i += 5;
                    continue;
                }
                if (value.substring(i + 1).startsWith("apos;")) {
                    sb.append('\'');
                    i += 5;
                    continue;
                }
                return null;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void emptyElement(QName name, XMLAttributes atts, Augmentations arg2) throws XNIException {
        this.onStartElement(name, atts);
        if (this.documentHandler != null) {
            this.documentHandler.emptyElement(name, atts, arg2);
        }
        if (this.validator != null) {
            try {
                this.startElementToValidator(name, atts);
                this.endElementToValidator(name);
            }
            catch (SAXException e) {
                throw new XNIException((Exception)e);
            }
        }
    }

    private void endElementToValidator(QName name) throws SAXException {
        Set<String> prefixes;
        this.validator.getContentHandler().endElement(name.uri != null ? name.uri : "", name.localpart, name.rawname);
        if (!this.prefixMappingStack.isEmpty() && (prefixes = this.prefixMappingStack.pop()) != null) {
            for (String prefix : prefixes) {
                this.validator.getContentHandler().endPrefixMapping(prefix);
            }
        }
    }

    public void startGeneralEntity(String arg0, XMLResourceIdentifier arg1, String arg2, Augmentations arg3) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.startGeneralEntity(arg0, arg1, arg2, arg3);
        }
    }

    public void textDecl(String arg0, String arg1, Augmentations arg2) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.textDecl(arg0, arg1, arg2);
        }
    }

    public void endGeneralEntity(String arg0, Augmentations arg1) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endGeneralEntity(arg0, arg1);
        }
    }

    public void characters(XMLString arg0, Augmentations arg1) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.characters(arg0, arg1);
        }
        if (this.validator != null) {
            try {
                this.validator.getContentHandler().characters(arg0.ch, arg0.offset, arg0.length);
            }
            catch (SAXException e) {
                throw new XNIException((Exception)e);
            }
        }
    }

    public void ignorableWhitespace(XMLString arg0, Augmentations arg1) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.ignorableWhitespace(arg0, arg1);
        }
        if (this.validator != null) {
            try {
                this.validator.getContentHandler().ignorableWhitespace(arg0.ch, arg0.offset, arg0.length);
            }
            catch (SAXException e) {
                throw new XNIException((Exception)e);
            }
        }
    }

    public void endElement(QName arg0, Augmentations arg1) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endElement(arg0, arg1);
        }
        if (this.validator != null) {
            try {
                this.endElementToValidator(arg0);
            }
            catch (SAXException e) {
                throw new XNIException((Exception)e);
            }
        }
    }

    public void startCDATA(Augmentations arg0) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.startCDATA(arg0);
        }
    }

    public void endCDATA(Augmentations arg0) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endCDATA(arg0);
        }
    }

    public void endDocument(Augmentations arg0) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endDocument(arg0);
        }
        if (this.validator != null) {
            try {
                this.validator.getContentHandler().endDocument();
            }
            catch (SAXException e) {
                throw new XNIException((Exception)e);
            }
        }
    }

    public void setDocumentSource(XMLDocumentSource arg0) {
        this.documentSource = arg0;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.documentSource;
    }

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public void setFeature(String feature, boolean value) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (propertyId.startsWith("http://apache.org/xml/properties/")) {
            int suffixLength = propertyId.length() - "http://apache.org/xml/properties/".length();
            if (suffixLength == "internal/symbol-table".length() && propertyId.endsWith("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)value;
            } else if (suffixLength == "internal/entity-resolver".length() && propertyId.endsWith("internal/entity-resolver")) {
                this.fResolver = (XMLEntityResolver)value;
            } else if (suffixLength == "internal/error-handler".length() && propertyId.endsWith("internal/error-handler")) {
                this.errorHandler = (XMLErrorHandler)value;
            }
        }
    }

    public Boolean getFeatureDefault(String featureId) {
        for (int i = 0; i < RECOGNIZED_FEATURES.length; ++i) {
            if (!RECOGNIZED_FEATURES[i].equals(featureId)) continue;
            return FEATURE_DEFAULTS[i];
        }
        return null;
    }

    public Object getPropertyDefault(String propertyId) {
        for (int i = 0; i < RECOGNIZED_PROPERTIES.length; ++i) {
            if (!RECOGNIZED_PROPERTIES[i].equals(propertyId)) continue;
            return PROPERTY_DEFAULTS[i];
        }
        return null;
    }

    public void setDocumentHandler(XMLDocumentHandler handler) {
        this.documentHandler = handler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }

    public void setValidate(boolean relaxNGValidation) {
        this.validate = relaxNGValidation;
    }
}

