/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.io.FilenameUtils;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.DitaValReader;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.ProfilingFilter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.XMLFilter;

public class BranchFilterModule
extends AbstractPipelineModuleImpl {
    private static final String SKIP_FILTER = "skip-filter";
    private static final String BRANCH_COPY_TO = "filter-copy-to";
    private final DitaValReader ditaValReader;
    private TempFileNameScheme tempFileNameScheme;
    private final Map<URI, FilterUtils> filterCache = new HashMap<URI, FilterUtils>();
    private URI map;
    protected URI currentFile;
    private final Set<URI> filtered = new HashSet<URI>();
    private final Set<URI> renamedTopics = new HashSet<URI>();
    private final Set<URI> sameNameTopics = new HashSet<URI>();
    private final Set<URI> filteredTopics = new HashSet<URI>();

    public BranchFilterModule() {
        this.ditaValReader = new DitaValReader();
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        super.setLogger(logger);
        this.ditaValReader.setLogger(logger);
    }

    @Override
    public void setJob(Job job) {
        super.setJob(job);
        this.ditaValReader.setJob(job);
        try {
            this.tempFileNameScheme = (TempFileNameScheme)Class.forName(job.getProperty("temp-file-name-scheme")).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.tempFileNameScheme.setBaseDir(job.getInputDir());
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        Collection<Job.FileInfo> fis = this.job.getFileInfo(fi -> fi.isInput || fi.isInputResource);
        for (Job.FileInfo fi2 : fis) {
            this.processMap(fi2.uri);
        }
        try {
            this.job.write();
        }
        catch (IOException e) {
            throw new DITAOTException("Failed to serialize job configuration: " + e.getMessage(), e);
        }
        return null;
    }

    protected void processMap(URI map) {
        Document doc;
        assert (!map.isAbsolute());
        this.map = map;
        this.currentFile = this.job.tempDirURI.resolve(map);
        this.logger.info("Processing " + String.valueOf(this.currentFile));
        try {
            this.logger.debug("Reading " + String.valueOf(this.currentFile));
            doc = this.job.getStore().getDocument(this.currentFile);
        }
        catch (IOException e) {
            this.logger.error("Failed to parse " + String.valueOf(this.currentFile), e);
            return;
        }
        this.logger.debug("Split branches and generate copy-to");
        this.splitBranches(doc.getDocumentElement(), Branch.EMPTY);
        this.logger.debug("Filter map");
        this.filterBranches(doc.getDocumentElement());
        this.logger.debug("Rewrite duplicate topic references");
        this.rewriteDuplicates(doc.getDocumentElement());
        this.logger.debug("Filter topics and generate copies");
        this.generateCopies(doc.getDocumentElement(), Collections.emptyList());
        this.logger.debug("Remove obsolete references");
        this.removeObsoleteReferences();
        this.logger.debug("Filter existing topics");
        this.filterTopics(doc.getDocumentElement(), Collections.emptyList());
        this.logger.debug("Writing " + String.valueOf(this.currentFile));
        try {
            doc.setDocumentURI(this.currentFile.toString());
            this.job.getStore().writeDocument(doc, this.currentFile);
        }
        catch (IOException e) {
            this.logger.error("Failed to serialize " + map.toString() + ": " + e.getMessage(), e);
        }
    }

    private void rewriteDuplicates(Element root) {
        HashMap<URI, Map> refs = new HashMap<URI, Map>();
        for (Element element : this.getTopicrefs(root)) {
            Attr attr = element.getAttributeNode(BRANCH_COPY_TO);
            if (attr == null && (attr = element.getAttributeNode("copy-to")) == null) {
                attr = element.getAttributeNode("href");
            }
            if (attr == null) continue;
            URI h = URLUtils.stripFragment(this.map.resolve(attr.getValue()));
            Map attrsMap = refs.computeIfAbsent(h, k -> new HashMap());
            Set<URI> currentFilter = this.getBranchFilters(element);
            List attrs = attrsMap.computeIfAbsent(currentFilter, k -> new ArrayList());
            attrs.add(attr);
        }
        for (Map.Entry entry : refs.entrySet()) {
            Map attrsMaps = (Map)entry.getValue();
            if (attrsMaps.size() <= 1) continue;
            if (attrsMaps.containsKey(Collections.EMPTY_LIST)) {
                attrsMaps.remove(Collections.EMPTY_LIST);
            } else {
                Set first = (Set)attrsMaps.keySet().iterator().next();
                attrsMaps.remove(first);
            }
            int i = 1;
            for (Map.Entry attrsMap : attrsMaps.entrySet()) {
                String suffix = "-" + i;
                List attrs = (List)attrsMap.getValue();
                for (Attr attr : attrs) {
                    URI absTarget;
                    Job.FileInfo hrefFileInfo;
                    URI dstUri;
                    String gen = BranchFilterModule.addSuffix(attr.getValue(), suffix);
                    this.logger.info(MessageUtils.getMessage("DOTJ065I", attr.getValue(), gen).setLocation(attr.getOwnerElement()).toString());
                    if (attr.getName().equals(BRANCH_COPY_TO)) {
                        attr.setValue(gen);
                    } else {
                        attr.getOwnerElement().setAttribute(BRANCH_COPY_TO, gen);
                    }
                    if ((dstUri = URLUtils.stripFragment(this.map.resolve(gen))) == null || (hrefFileInfo = this.job.getFileInfo(absTarget = URLUtils.stripFragment(this.currentFile.resolve(attr.getValue())))) == null) continue;
                    URI newResult = BranchFilterModule.addSuffix(hrefFileInfo.result, suffix);
                    Job.FileInfo.Builder dstBuilder = new Job.FileInfo.Builder(hrefFileInfo).uri(dstUri).result(newResult);
                    if (hrefFileInfo.format == null) {
                        dstBuilder.format("dita");
                    }
                    Job.FileInfo dstFileInfo = dstBuilder.build();
                    this.job.add(dstFileInfo);
                }
                ++i;
            }
        }
    }

    private Set<URI> getBranchFilters(Element e) {
        HashSet<URI> res = new HashSet<URI>();
        Element current = e;
        while (current != null) {
            Node parent;
            List<Element> ditavalref = XMLUtils.getChildElements(current, Constants.DITAVAREF_D_DITAVALREF);
            if (!ditavalref.isEmpty()) {
                res.add(URLUtils.toURI(ditavalref.get(0).getAttribute("href")));
            }
            if ((parent = current.getParentNode()) == null || parent.getNodeType() != 1) break;
            current = (Element)parent;
        }
        return res;
    }

    private static String addSuffix(String href, String suffix) {
        int idx = href.lastIndexOf(".");
        return idx != -1 ? href.substring(0, idx) + suffix + href.substring(idx) : href + suffix;
    }

    private static URI addSuffix(URI href, String suffix) {
        return URI.create(BranchFilterModule.addSuffix(href.toString(), suffix));
    }

    private List<Element> getTopicrefs(Element root) {
        ArrayList<Element> res = new ArrayList<Element>();
        NodeList all = root.getElementsByTagName("*");
        for (int i = 0; i < all.getLength(); ++i) {
            Element elem = (Element)all.item(i);
            if (!Constants.MAP_TOPICREF.matches(elem) || !this.isDitaFormat(elem.getAttributeNode("format")) || elem.getAttribute("scope").equals("external")) continue;
            res.add(elem);
        }
        return res;
    }

    private boolean isDitaFormat(Attr formatAttr) {
        return formatAttr == null || this.isDitaFormat(formatAttr.getNodeValue());
    }

    private boolean isDitaFormat(String formatAttr) {
        return formatAttr == null || "dita".equals(formatAttr) || "ditamap".equals(formatAttr);
    }

    private void filterBranches(Element root) {
        String domains = root.getAttribute("domains");
        String specializations = root.getAttribute("specializations");
        QName[][] props = !domains.isEmpty() ? StringUtils.getExtProps(domains) : StringUtils.getExtPropsFromSpecializations(specializations);
        this.filterBranches(root, Collections.emptyList(), props);
    }

    private void filterBranches(Element elem, List<FilterUtils> filters, QName[][] props) {
        FilterUtils f2;
        List<FilterUtils> fs = this.combineFilterUtils(elem, filters);
        boolean exclude = false;
        Iterator<FilterUtils> iterator = fs.iterator();
        while (iterator.hasNext() && !(exclude = (f2 = iterator.next()).needExclude(elem, props))) {
        }
        if (exclude) {
            this.addToFilteredSet(elem);
            elem.getParentNode().removeChild(elem);
        } else {
            List<Element> childElements = XMLUtils.getChildElements(elem);
            Set flags = fs.stream().flatMap(f -> f.getFlags(elem, props).stream()).map(f -> f.adjustPath(this.currentFile, this.job)).collect(Collectors.toSet());
            for (FilterUtils.Flag flag : flags) {
                Element startElement = (Element)elem.getOwnerDocument().importNode(flag.getStartFlag(), true);
                Node firstChild = elem.getFirstChild();
                if (firstChild != null) {
                    elem.insertBefore(startElement, firstChild);
                } else {
                    elem.appendChild(startElement);
                }
                Element endElement = (Element)elem.getOwnerDocument().importNode(flag.getEndFlag(), true);
                elem.appendChild(endElement);
            }
            for (Element child : childElements) {
                this.filterBranches(child, fs, props);
            }
        }
    }

    private void addToFilteredSet(Element elem) {
        String copyTo = elem.getAttribute(BRANCH_COPY_TO);
        String href = elem.getAttribute("href");
        if (!copyTo.isEmpty()) {
            URI dstUri = this.map.resolve(copyTo);
            this.filteredTopics.add(dstUri);
        }
        if (!href.isEmpty()) {
            URI srcUri = this.map.resolve(href);
            this.filteredTopics.add(srcUri);
        }
        for (Element child : XMLUtils.getChildElements(elem)) {
            this.addToFilteredSet(child);
        }
    }

    private List<FilterUtils> combineFilterUtils(Element topicref, List<FilterUtils> filters) {
        List<Element> ditavalRefs = XMLUtils.getChildElements(topicref, Constants.DITAVAREF_D_DITAVALREF);
        assert (ditavalRefs.size() <= 1);
        if (!ditavalRefs.isEmpty()) {
            ArrayList<FilterUtils> fs = new ArrayList<FilterUtils>(filters);
            FilterUtils f = this.getFilterUtils(ditavalRefs.get(0));
            if (f != null) {
                fs = new ArrayList<FilterUtils>(fs);
                fs.add(f);
            }
            return fs;
        }
        return filters;
    }

    private void generateCopies(Element topicref, List<FilterUtils> filters) {
        List<FilterUtils> fs = this.combineFilterUtils(topicref, filters);
        String copyTo = topicref.getAttribute(BRANCH_COPY_TO);
        String href = topicref.getAttribute("href");
        if (!copyTo.isEmpty()) {
            URI dstUri = this.map.resolve(copyTo);
            URI dstAbsUri = this.job.tempDirURI.resolve(dstUri);
            URI srcUri = this.map.resolve(href);
            URI srcAbsUri = this.job.tempDirURI.resolve(srcUri);
            Job.FileInfo srcFileInfo = this.job.getFileInfo(URLUtils.removeFragment(srcUri));
            if (srcFileInfo != null) {
                this.renamedTopics.add(srcUri);
                this.logger.info("Filtering " + String.valueOf(srcAbsUri) + " to " + String.valueOf(dstAbsUri));
                ProfilingFilter writer = new ProfilingFilter();
                writer.setLogger(this.logger);
                writer.setJob(this.job);
                writer.setFilterUtils(fs);
                writer.setCurrentFile(dstAbsUri);
                List<XMLFilter> pipe = Collections.singletonList(writer);
                try {
                    this.job.getStore().transform(URLUtils.removeFragment(srcAbsUri), URLUtils.removeFragment(dstAbsUri), pipe);
                }
                catch (DITAOTException e) {
                    this.logger.error("Failed to filter " + String.valueOf(srcAbsUri) + " to " + String.valueOf(dstAbsUri) + ": " + e.getMessage(), e);
                }
                topicref.setAttribute("href", copyTo);
                topicref.removeAttribute(BRANCH_COPY_TO);
                topicref.setAttribute(SKIP_FILTER, Boolean.TRUE.toString());
            }
        } else if (!href.isEmpty()) {
            URI srcUri = this.map.resolve(href);
            this.sameNameTopics.add(srcUri);
        }
        for (Element child : XMLUtils.getChildElements(topicref, Constants.MAP_TOPICREF)) {
            if (Constants.DITAVAREF_D_DITAVALREF.matches(child)) continue;
            this.generateCopies(child, fs);
        }
    }

    private void removeObsoleteReferences() {
        for (URI file : this.renamedTopics) {
            if (this.sameNameTopics.contains(file) || this.job.getFileInfo(file) == null) continue;
            this.job.remove(this.job.getFileInfo(file));
        }
        for (URI file : this.filteredTopics) {
            if (this.sameNameTopics.contains(file) || this.job.getFileInfo(file) == null) continue;
            this.job.remove(this.job.getFileInfo(file));
        }
    }

    private void filterTopics(Element topicref, List<FilterUtils> filters) {
        List<FilterUtils> fs = this.combineFilterUtils(topicref, filters);
        String href = topicref.getAttribute("href");
        Attr skipFilter = topicref.getAttributeNode(SKIP_FILTER);
        URI srcAbsUri = URLUtils.setFragment(this.job.tempDirURI.resolve(this.map.resolve(href)), null);
        if (!(fs.isEmpty() || skipFilter != null || this.filtered.contains(srcAbsUri) || href.isEmpty() || "external".equals(topicref.getAttribute("scope")) || "resource-only".equals(topicref.getAttribute("processing-role")) || !this.isDitaFormat(topicref.getAttributeNode("format")))) {
            ProfilingFilter writer = new ProfilingFilter();
            writer.setLogger(this.logger);
            writer.setJob(this.job);
            writer.setFilterUtils(fs);
            writer.setCurrentFile(srcAbsUri);
            List<XMLFilter> pipe = Collections.singletonList(writer);
            this.logger.info("Filtering " + String.valueOf(srcAbsUri));
            try {
                this.job.getStore().transform(srcAbsUri, pipe);
            }
            catch (DITAOTException e) {
                this.logger.error("Failed to filter " + String.valueOf(srcAbsUri) + ": " + e.getMessage(), e);
            }
            this.filtered.add(srcAbsUri);
        }
        if (skipFilter != null) {
            topicref.removeAttributeNode(skipFilter);
        }
        for (Element child : XMLUtils.getChildElements(topicref, Constants.MAP_TOPICREF)) {
            if (Constants.DITAVAREF_D_DITAVALREF.matches(child)) continue;
            this.filterTopics(child, fs);
        }
    }

    private FilterUtils getFilterUtils(Element ditavalRef) {
        if (ditavalRef.getAttribute("href").isEmpty()) {
            return null;
        }
        URI href = URLUtils.toURI(ditavalRef.getAttribute("href"));
        URI tmp = this.currentFile.resolve(href);
        Job.FileInfo fi = this.job.getFileInfo(tmp);
        URI ditaval = fi.src;
        FilterUtils f = this.filterCache.get(ditaval);
        if (f == null) {
            this.ditaValReader.filterReset();
            this.logger.info("Reading " + String.valueOf(ditaval));
            this.ditaValReader.read(ditaval);
            Map<FilterUtils.FilterKey, FilterUtils.Action> filterMap = this.ditaValReader.getFilterMap();
            f = new FilterUtils(filterMap, this.ditaValReader.getForegroundConflictColor(), this.ditaValReader.getBackgroundConflictColor());
            f.setLogger(this.logger);
            this.filterCache.put(ditaval, f);
        }
        return f;
    }

    void splitBranches(Element elem, Branch filter) {
        List<Element> ditavalRefs = XMLUtils.getChildElements(elem, Constants.DITAVAREF_D_DITAVALREF);
        if (ditavalRefs.size() > 0) {
            int i;
            for (Element branch : ditavalRefs) {
                elem.removeChild(branch);
            }
            ArrayList<Element> branches = new ArrayList<Element>(ditavalRefs.size());
            branches.add(elem);
            Node next = elem.getNextSibling();
            for (i = 1; i < ditavalRefs.size(); ++i) {
                Element clone = (Element)elem.cloneNode(true);
                if (next != null) {
                    elem.getParentNode().insertBefore(clone, next);
                } else {
                    elem.getParentNode().appendChild(clone);
                }
                branches.add(clone);
            }
            for (i = 0; i < branches.size(); ++i) {
                Element branch = (Element)branches.get(i);
                Element ditavalref = ditavalRefs.get(i);
                branch.appendChild(ditavalref);
                Branch currentFilter = filter.merge(ditavalref);
                this.processAttributes(branch, currentFilter);
                Branch childFilter = new Branch(currentFilter.resourcePrefix, currentFilter.resourceSuffix, Optional.empty(), Optional.empty());
                for (Element child : XMLUtils.getChildElements(branch, Constants.MAP_TOPICREF)) {
                    if (Constants.DITAVAREF_D_DITAVALREF.matches(child)) continue;
                    this.splitBranches(child, childFilter);
                }
            }
        } else {
            this.processAttributes(elem, filter);
            for (Element child : XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF)) {
                this.splitBranches(child, filter);
            }
        }
    }

    private void processAttributes(Element elem, Branch filter) {
        if (filter.resourcePrefix.isPresent() || filter.resourceSuffix.isPresent()) {
            String href = elem.getAttribute("href");
            String copyTo = elem.getAttribute("copy-to");
            String scope = elem.getAttribute("scope");
            if (!(href.isEmpty() && copyTo.isEmpty() || scope.equals("external"))) {
                Job.FileInfo hrefFileInfo = this.job.getFileInfo(this.currentFile.resolve(href));
                if (this.isDitaFormat(hrefFileInfo.format)) {
                    Job.FileInfo copyToFileInfo = !copyTo.isEmpty() ? this.job.getFileInfo(this.currentFile.resolve(copyTo)) : null;
                    URI dstSource = BranchFilterModule.generateCopyTo((copyToFileInfo != null ? copyToFileInfo : hrefFileInfo).result, filter);
                    URI dstTemp = this.tempFileNameScheme.generateTempFileName(dstSource);
                    String dstPathFromMap = !copyTo.isEmpty() ? FilenameUtils.getPath((String)copyTo) : FilenameUtils.getPath((String)href);
                    Job.FileInfo.Builder dstBuilder = new Job.FileInfo.Builder(hrefFileInfo).result(dstSource).uri(dstTemp);
                    if (dstBuilder.build().format == null) {
                        dstBuilder.format("dita");
                    }
                    if (hrefFileInfo.src == null && href != null && copyToFileInfo != null) {
                        dstBuilder.src(copyToFileInfo.src);
                    }
                    Job.FileInfo dstFileInfo = dstBuilder.build();
                    elem.setAttribute(BRANCH_COPY_TO, dstPathFromMap + FilenameUtils.getName((String)dstTemp.toString()));
                    if (!copyTo.isEmpty()) {
                        elem.removeAttribute("copy-to");
                    }
                    this.job.add(dstFileInfo);
                }
            }
        }
        if (filter.keyscopePrefix.isPresent() || filter.keyscopeSuffix.isPresent()) {
            StringBuilder buf = new StringBuilder();
            String keyscope = elem.getAttribute("keyscope");
            if (!keyscope.isEmpty()) {
                for (String key : keyscope.trim().split("\\s+")) {
                    filter.keyscopePrefix.ifPresent(buf::append);
                    buf.append(key);
                    filter.keyscopeSuffix.ifPresent(buf::append);
                    buf.append(' ');
                }
            } else {
                filter.keyscopePrefix.ifPresent(buf::append);
                filter.keyscopeSuffix.ifPresent(buf::append);
            }
            elem.setAttribute("keyscope", buf.toString().trim());
        }
    }

    static URI generateCopyTo(URI href, Branch filter) {
        StringBuilder buf = new StringBuilder(href.toString());
        Optional<String> suffix = filter.resourceSuffix;
        suffix.ifPresent(s -> {
            int sep = buf.lastIndexOf("/");
            int i = buf.lastIndexOf(".");
            if (i != -1 && (sep == -1 || i > sep)) {
                buf.insert(i, (String)s);
            } else {
                buf.append((String)s);
            }
        });
        Optional<String> prefix = filter.resourcePrefix;
        prefix.ifPresent(s -> {
            int i = buf.lastIndexOf("/");
            if (i != -1) {
                buf.insert(i + 1, (String)s);
            } else {
                buf.insert(0, (String)s);
            }
        });
        return URLUtils.toURI(buf.toString());
    }

    public static class Branch {
        public static final Branch EMPTY = new Branch();
        public final Optional<String> resourcePrefix;
        public final Optional<String> resourceSuffix;
        public final Optional<String> keyscopePrefix;
        public final Optional<String> keyscopeSuffix;

        private Branch() {
            this.resourcePrefix = Optional.empty();
            this.resourceSuffix = Optional.empty();
            this.keyscopePrefix = Optional.empty();
            this.keyscopeSuffix = Optional.empty();
        }

        public Branch(Optional<String> resourcePrefix, Optional<String> resourceSuffix, Optional<String> keyscopePrefix, Optional<String> keyscopeSuffix) {
            this.resourcePrefix = resourcePrefix;
            this.resourceSuffix = resourceSuffix;
            this.keyscopePrefix = keyscopePrefix;
            this.keyscopeSuffix = keyscopeSuffix;
        }

        public String toString() {
            return "{" + String.valueOf(this.resourcePrefix) + "," + String.valueOf(this.resourceSuffix) + ";" + String.valueOf(this.keyscopePrefix) + ", " + String.valueOf(this.keyscopeSuffix) + "}";
        }

        public Branch merge(Element ditavalref) {
            return new Branch(this.getPrefix(ditavalref, this.resourcePrefix), this.getSuffix(ditavalref, this.resourceSuffix), this.getKeyscopePrefix(ditavalref, this.keyscopePrefix), this.getKeyscopeSuffix(ditavalref, this.keyscopeSuffix));
        }

        private Optional<String> get(Element ditavalref, DitaClass cls) {
            for (Element ditavalmeta : XMLUtils.getChildElements(ditavalref, Constants.DITAVAREF_D_DITAVALMETA)) {
                Optional<Element> childElements = XMLUtils.getChildElement(ditavalmeta, cls);
                if (!childElements.isPresent()) continue;
                return Optional.of(XMLUtils.getStringValue(childElements.get()));
            }
            return Optional.empty();
        }

        private Optional<String> getPrefix(Element ditavalref, Optional<String> oldValue) {
            Optional<String> v = this.get(ditavalref, Constants.DITAVAREF_D_DVR_RESOURCEPREFIX);
            return v.map(s -> Optional.of(oldValue.orElse("") + s)).orElse(oldValue);
        }

        private Optional<String> getSuffix(Element ditavalref, Optional<String> oldValue) {
            Optional<String> v = this.get(ditavalref, Constants.DITAVAREF_D_DVR_RESOURCESUFFIX);
            return v.map(s -> Optional.of(s + oldValue.orElse(""))).orElse(oldValue);
        }

        private Optional<String> getKeyscopePrefix(Element ditavalref, Optional<String> oldValue) {
            Optional<String> v = this.get(ditavalref, Constants.DITAVAREF_D_DVR_KEYSCOPEPREFIX);
            return v.map(s -> Optional.of(oldValue.orElse("") + s)).orElse(oldValue);
        }

        private Optional<String> getKeyscopeSuffix(Element ditavalref, Optional<String> oldValue) {
            Optional<String> v = this.get(ditavalref, Constants.DITAVAREF_D_DVR_KEYSCOPESUFFIX);
            return v.map(s -> Optional.of(s + oldValue.orElse(""))).orElse(oldValue);
        }
    }
}

