/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LinkFilter
extends AbstractXMLFilter {
    private URI destFile;
    private URI base;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Attributes res = atts;
        if (this.hasLocalDitaLink(atts)) {
            AttributesImpl resAtts = new AttributesImpl(atts);
            int i = atts.getIndex("imageref");
            if (i == -1) {
                i = atts.getIndex("href");
            }
            if (i == -1) {
                i = atts.getIndex("data");
            }
            if (i != -1) {
                URI resHref = this.getHref(URLUtils.toURI(atts.getValue(i)));
                XMLUtils.addOrSetAttribute(resAtts, atts.getQName(i), resHref.toString());
                res = resAtts;
            }
        }
        this.getContentHandler().startElement(uri, localName, qName, res);
    }

    private boolean hasLocalDitaLink(Attributes atts) {
        boolean notExternal;
        boolean hasHref = atts.getIndex("href") != -1;
        boolean bl = notExternal = !"external".equals(atts.getValue("scope"));
        if (hasHref && notExternal) {
            return true;
        }
        URI data = URLUtils.toURI(atts.getValue("data"));
        if (data != null && !data.isAbsolute()) {
            return true;
        }
        URI imageref = URLUtils.toURI(atts.getValue("imageref"));
        return imageref != null && !imageref.isAbsolute();
    }

    @VisibleForTesting
    URI getHref(URI target) {
        if (target.getFragment() != null && (target.getPath() == null || target.getPath().equals(""))) {
            return target;
        }
        URI targetAbs = URLUtils.stripFragment(this.currentFile.resolve(target));
        Job.FileInfo targetFileInfo = this.job.getFileInfo(targetAbs);
        Job.FileInfo sourceFileInfo = this.job.getFileInfo(this.currentFile);
        if (targetFileInfo != null && sourceFileInfo != null) {
            URI relTarget = URLUtils.getRelativePath(sourceFileInfo.result, targetFileInfo.result);
            return URLUtils.setFragment(relTarget, target.getFragment());
        }
        return target;
    }

    public void setDestFile(URI destFile) {
        assert (destFile.isAbsolute());
        this.destFile = destFile;
    }

    @Override
    public void setJob(Job job) {
        super.setJob(job);
        this.base = job.getInputDir();
    }
}

