/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.builder.IBasedSegmentBuilder;
import org.jetbrains.annotations.NotNull;

public interface BasedUtils {
    public static void generateSegments(IBasedSegmentBuilder<?> segments, @NotNull BasedSequence chars) {
        int baseStart = -1;
        int baseEnd = -1;
        boolean hadSequence = false;
        StringBuilder stringBuilder = null;
        int iMax = chars.length();
        for (int i = 0; i < iMax; ++i) {
            int offset = chars.getIndexOffset(i);
            if (offset >= 0) {
                if (baseStart == -1) {
                    if (stringBuilder != null) {
                        if (!hadSequence) {
                            segments.appendAnchor(chars.getStartOffset());
                            hadSequence = true;
                        }
                        segments.append(stringBuilder.toString());
                        stringBuilder = null;
                    }
                    baseStart = offset;
                } else if (offset > baseEnd + 1) {
                    segments.append(baseStart, baseEnd + 1);
                    baseStart = offset;
                }
                baseEnd = offset;
                continue;
            }
            if (baseStart != -1) {
                segments.append(baseStart, baseEnd + 1);
                baseStart = -1;
                baseEnd = -1;
                hadSequence = true;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(chars.charAt(i));
        }
        if (baseStart != -1) {
            segments.append(baseStart, baseEnd + 1);
            hadSequence = true;
        }
        if (stringBuilder != null) {
            if (!hadSequence) {
                segments.appendAnchor(chars.getStartOffset());
                hadSequence = true;
            }
            segments.append(stringBuilder.toString());
            segments.appendAnchor(chars.getEndOffset());
        }
        if (!hadSequence) {
            if (!1.$assertionsDisabled && chars.length() != 0) {
                throw new AssertionError();
            }
            segments.appendAnchor(chars.getStartOffset());
        }
    }

    public static BasedSequence asBased(CharSequence sequence) {
        return BasedSequence.of(sequence);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

