/******************************************************************************
 *{@C
 *      Copyright:      2006-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dFTGL
 *      Filename:       ftgl.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG module for wrapping the FTGL library.
 *
 *****************************************************************************/

%module ftgl

%{
#if defined (WIN32)
#include <windows.h>
#include <wingdi.h>
#endif
#include "FTGL.h"
#include "FTGlyph.h"
#include "FTFont.h"
#include "FTGLBitmapFont.h"
#include "FTGLExtrdFont.h"
#include "FTGLOutlineFont.h"
#include "FTGLPixmapFont.h"
#include "FTGLPolygonFont.h"
#include "FTGLTextureFont.h"
%}

%include tcl3dDefines.i

// FTGL specific macros.
#define FTGL_EXPORT

// Redefine some types and enumerations of the freetype library, so we do
// not have to include all the header files of freetype.
// POSSIBLE INCOMPATIBILITY.

#define FT_Error int
#define size_t int

// In FTGL 2.1.3 the font classes have been renamed and the old names
// kept with macro redefinitions.
// These defines are not recognized by Swig, so we rename the new class
// names to the old ones. The new names are made available at the Tcl level
// by aliasing them in tcl3dFTGLUtil.i.

%rename(FTGLExtrdFont)   FTExtrudeFont;
%rename(FTGLBitmapFont)  FTBitmapFont;
%rename(FTGLOutlineFont) FTOutlineFont;
%rename(FTGLPixmapFont)  FTPixmapFont;
%rename(FTGLPolygonFont) FTPolygonFont;
%rename(FTGLTextureFont) FTTextureFont;

%include "FTGL.h"
%include "FTGlyph.h"
%include "FTFont.h"
%include "FTGLBitmapFont.h"
%include "FTGLExtrdFont.h"
%include "FTGLOutlineFont.h"
%include "FTGLPixmapFont.h"
%include "FTGLPolygonFont.h"
%include "FTGLTextureFont.h"
