/******************************************************************************
 *{@C
 *      Copyright:      2005-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOde
 *      Filename:       tcl3dOde.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Main SWIG file for wrapping the OpenDynamicsEngine ODE.
 *                      This file is responsible for the Tcl package tcl3dOde.
 *
 *                      The macro USE_ODE_IF must be defined at compilation
 *                      time to include the functionality of the ODE library
 *                      into the Tcl3D package.
 *
 *****************************************************************************/

// The name of our generated Tcl package.

%module tcl3dOde


// Code to initialize the Tk stubs library.

%{
#include <tk.h>
%}

%init %{
#ifndef USE_ODE_IF
    Tcl_SetResult(interp, (char *) "ODE library not wrapped", TCL_STATIC);
    return TCL_ERROR;
#endif

#ifdef USE_TK_STUBS
    if (Tk_InitStubs(interp, (char*)"8.4", 0) == NULL) {
      return TCL_ERROR;
    }
#endif
%}

#ifdef USE_ODE_IF

// Standard modules from the SWIG library

%include typemaps.i


// Common Tcl3D wrapper modules.

%include tcl3dVectors.i
%include tcl3dConstHash.i
%include tcl3dPointer.i
%include tcl3dArgv.i
%include tcl3dTypemaps.i


// Wrap the ODE library.

%include ode.i

#endif // USE_ODE_IF
