/******************************************************************************
 *{@C
 *      Copyright:      2005-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOgl
 *      Filename:       tcl3dOgl.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Main SWIG files for wrapping the OpenGL library, the
 *                      GLU library as well as GLUT compatible basic shapes.
 *                      This file is responsible for the Tcl package tcl3dOgl.
 *
 *                      The macro USE_EXT_IF must be defined at compilation
 *                      time to include extended functionality like
 *                      operating systems specific OpenGL functions
 *                      into the Tcl3D package.
 *
 *****************************************************************************/

// The name of our generated Tcl package.

%module tcl3dOgl


// Code to initialize the Tk stubs library.

%{
#include <tk.h>
%}

%init %{
#ifdef USE_TK_STUBS
    if (Tk_InitStubs(interp, (char*)"8.4", 0) == NULL) {
      return TCL_ERROR;
    }
#endif

if (Tcl3dtogl_Init (interp) == TCL_ERROR) {
    return TCL_ERROR;
}
%}


// Standard modules from the SWIG library

%include typemaps.i


// Common Tcl3D wrapper modules.

%include tcl3dVectors.i
%include tcl3dConstHash.i
%include tcl3dPointer.i
%include tcl3dArgv.i
%include tcl3dTypemaps.i


// Wrap some GL functions redefined for better Tcl usage.

%include glew.i


// Wrap the GLEW library.

%include glewdefs.i
%include glewfuncs.i


// Wrap the Tk photo library.

%include tkphoto.i


// Wrap the vector utility library.

%include vector.i


// Wrap the utilities library.

%include util.i


// Wrap the heightmap library.

%include heightmap.i


// Wrap the list2vector library.

%include list2vector.i

// Wrap the GLU library.
// Note: This must be at the end of the include list, as this SWIG file
// redefines the standard typemaps for "float *" and "double *".
// All other SWIG files rely on this standard mapping.

%include glu.i


// Wrap the ByteArray library.
// Note: This must be at the end of the include list, as this SWIG file
// redefines the standard typemaps for "unsigned char *" and
// "const unsigned char *".
// All other SWIG files rely on this standard mapping.

%include bytearray.i
