/******************************************************************************
 *{@C
 *      Copyright:      2005-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOgl
 *      Filename:       tcl3dUtilStopWatch.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Declarations for stop watch functions.
 *
 *****************************************************************************/

#ifndef __TCL3D_UTIL_STOPWATCH_H__
#define __TCL3D_UTIL_STOPWATCH_H__

typedef struct swatchStruct {
    double numseconds;
    double laststart;
    int    clockrunning;
} SwatchStruct;

typedef struct swatchStruct *swatch;

#ifdef __cplusplus
   extern "C" {
#endif

    swatch tcl3dNewSwatch    (void);
    void   tcl3dDeleteSwatch (swatch sw);
    void   tcl3dStopSwatch   (swatch sw);
    void   tcl3dStartSwatch  (swatch sw);
    void   tcl3dResetSwatch  (swatch sw);
    double tcl3dLookupSwatch (const swatch sw);

#ifdef __cplusplus
   }
#endif

#endif /* __TCL3D_UTIL_STOPWATCH_H__ */
