/******************************************************************************
 *{@C
 *      Copyright:      2009-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osgManipulator.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file does the actual wrapping of OSG module 
 *                      osgManipulator.
 *
 *****************************************************************************/

%include "osgHeader.i"

%include "osgAnimationHeader.i"
%include "osgManipulatorHeader.i"
%include "osgParticleHeader.i"
%include "osgSimHeader.i"
%include "osgTextHeader.i"
%include "osgUtilHeader.i"

%import "osg.i"

%{
using namespace osg;
using namespace osgManipulator;
%}

%include osgManipulator/Selection
%include osgManipulator/AntiSquish
%include osgManipulator/Command
%include osgManipulator/Dragger
%include osgManipulator/CommandManager
%include osgManipulator/Constraint
%include osgManipulator/Projector
%include osgManipulator/RotateCylinderDragger
%include osgManipulator/RotateSphereDragger
%include osgManipulator/Scale1DDragger
%include osgManipulator/Scale2DDragger
%include osgManipulator/ScaleAxisDragger
%include osgManipulator/TabBoxDragger
%include osgManipulator/TabPlaneDragger
%include osgManipulator/TabPlaneTrackballDragger
%include osgManipulator/TrackballDragger
%include osgManipulator/Translate1DDragger
%include osgManipulator/Translate2DDragger
%include osgManipulator/TranslateAxisDragger
%include osgManipulator/TranslatePlaneDragger
%include osgManipulator/Version

%inline %{
osgManipulator::Dragger *NodeToDragger(osg::Node *d) {
  return dynamic_cast<osgManipulator::Dragger*>(d);
}
%}

%inline %{
osgManipulator::Selection *NodeToSelection(osg::Node *d) {
  return dynamic_cast<osgManipulator::Selection*>(d);
}
%}
