/******************************************************************************
 *{@C
 *      Copyright:      2009-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osgUtil.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file does the actual wrapping of OSG module 
 *                      osgUtil.
 *
 *****************************************************************************/

%include "osgHeader.i"

%include "osgAnimationHeader.i"
%include "osgParticleHeader.i"
%include "osgSimHeader.i"
%include "osgTextHeader.i"
%include "osgUtilHeader.i"

%import "osg.i"

%{

using namespace osg;
using namespace osgUtil;

%}

%ignore osgUtil::SceneView::ComputeStereoMatricesCallback;
%ignore osgUtil::SceneView::setComputeStereoMatricesCallback;
%ignore osgUtil::SceneView::getComputeStereoMatricesCallback;

%ignore osgUtil::RenderBin::setSortCallback;
%ignore osgUtil::RenderBin::getSortCallback;
%ignore osgUtil::RenderBin::setDrawCallback;
%ignore osgUtil::RenderBin::getDrawCallback;

%ignore osgUtil::Optimizer::setIsOperationPermissibleForObjectCallback;
%ignore osgUtil::Optimizer::getIsOperationPermissibleForObjectCallback;
%ignore osgUtil::Simplifier::setContinueSimplificationCallback;
%ignore osgUtil::Simplifier::getContinueSimplificationCallback;

%rename(get) osgUtil::LessDepthSortFunctor::operator ();

%feature("notabstract") osgUtil::SceneView;

%include osgUtil/GLObjectsVisitor
%include osgUtil/Optimizer
%include osgUtil/RenderBin
%include osgUtil/RenderLeaf
%include osgUtil/SceneView
%include osgUtil/SmoothingVisitor
%include osgUtil/StateGraph
%include osgUtil/Statistics
%include osgUtil/TriStripVisitor

// Duplicate nested class from osgUtil/IntersectionVisitor
struct ReadCallback : public osg::Referenced
{
    virtual osg::Node* readNodeFile(const std::string& filename) = 0;
};
%include osgUtil/IntersectionVisitor

// IntersectVisitor is deprecated and will not be wrapped.
// %include osgUtil/IntersectVisitor

// Duplicate nested class from osgUtil/PolytopeIntersector
struct Intersection
{
    Intersection() {}

    bool operator < (const Intersection& rhs) const
    {
        if (nodePath < rhs.nodePath) return true;
        if (rhs.nodePath < nodePath ) return false;
        return (drawable < rhs.drawable);
    }

    osg::NodePath                   nodePath;
    osg::ref_ptr<osg::Drawable>     drawable;
};

%typemap(out) osgUtil::PolytopeIntersector::Intersections& 
{
    for (osgUtil::PolytopeIntersector::Intersections::iterator i = $1->begin();
         i != $1->end(); ++i) {
        Tcl_Obj *obj = SWIG_NewPointerObj((new Intersection(static_cast< const Intersection& >(*i))), SWIGTYPE_p_Intersection, SWIG_POINTER_OWN |  0 );

        if (obj) {
            if (Tcl_ListObjAppendElement (interp, $result, obj) == TCL_ERROR) {
                return NULL;
            }
        }
    }
}

%include osgUtil/PolytopeIntersector

%{
    typedef osgUtil::PolytopeIntersector::Intersection Intersection;
%}

%include osgUtil/Version
