# STL std vector specific test procedures.
# These procedures are independent of the supplied vector class type.

package require tcl3d

source testUtil.tcl

# Start of test cases.

P "\n>>> Test cases for std::vector classes <<<\n"

# Test the different constructors.
set stdVec1 [osg::StdVec3f]
PN "Cnstr ()" ; tcl3dOsgVecArrayPrint $stdVec1

set stdVec2 [osg::StdVec3f 40]
PN "Cnstr (40)" ; tcl3dOsgVecArrayPrint $stdVec2

set stdVec3 [osg::StdVec3f 2 [CreateUnitVec osg::Vec3f 3 0]]
PN "Cnstr (size, Vec3f)" ; tcl3dOsgVecArrayPrint $stdVec3 

set stdVec4 [osg::StdVec3f $stdVec3]
PN "Cnstr (StdVec)" ; tcl3dOsgVecArrayPrint $stdVec4

set stdVec5 [osg::NodeStdVec]
PN "NodeStdVec ()" ; tcl3dOsgVecArrayPrint $stdVec5

$stdVec1 push [osg::Vec3f a 1 2 3]
$stdVec1 push [osg::Vec3f a 4 5 6] 
PN "Pushing 2 Vec3f:" ; tcl3dOsgVecArrayPrint $stdVec1
PN "Is StdVec empty? :" ; P [$stdVec1 empty]

set last [expr [$stdVec1 size] -1]
set vec1 [$stdVec1 get $last]
set vec2 [$stdVec1 pop]
PN "Vec3f at position $last:" ; tcl3dOsgVecPrint $vec1
PN "Vec3f popped:" ; tcl3dOsgVecPrint $vec2

set last [expr [$stdVec1 size] -1]
set vec1 [$stdVec1 get $last]
set vec2 [$stdVec1 pop]
PN "Vec3f at position $last:" ; tcl3dOsgVecPrint $vec1
PN "Vec3f popped:" ; tcl3dOsgVecPrint $vec2

PN "Is StdVec empty? :" ; P [$stdVec1 empty]

$stdVec1 push [osg::Vec3f a 10 20 30] 
$stdVec1 push [osg::Vec3f a 11 21 31] 
PN "New StdVec:" ; tcl3dOsgVecArrayPrint $stdVec1
$stdVec1 set 0 [osg::Vec3f a 5 6 7]
PN "set index 0:" ; tcl3dOsgVecArrayPrint $stdVec1

$stdVec1 clear
PN "StdVec after clear:" ; P "Is Empty? [$stdVec1 empty] Size: [$stdVec1 size]"

# OPA TODO
exit

osg::Node n1
n1 setName "Node-n1"
puts "[n1 getName] : [n1 cget -this] ([n1 cget -thisown])"
$stdVec5 push n1
puts "[n1 getName] : [n1 cget -this] ([n1 cget -thisown])"
set n [$stdVec5 get 0]
puts "Type of n: $n"
#puts "[$n getName] : [$n cget -this] ([$n cget -thisown])"

exit
