/******************************************************************************
 *{@C
 *      Copyright:      2005-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dSDL
 *      Filename:       sdl.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG module for wrapping the SDL library.
 *
 *****************************************************************************/

%module sdl

%{
#if defined (WIN32)
#include <windows.h>
#include <wingdi.h>
#endif
#include "SDL.h"
#include "SDL_active.h"
#include "SDL_types.h"
#include "SDL_getenv.h"
#include "SDL_error.h"
#include "SDL_rwops.h"
#include "SDL_byteorder.h"
#include "SDL_timer.h"
#include "SDL_loadso.h"
#include "SDL_thread.h"
#include "SDL_timer.h"
#include "SDL_cdrom.h"
#include "SDL_joystick.h"
#include "SDL_mouse.h"
#include "SDL_events.h"
#include "SDL_video.h"
#include "SDL_version.h"
#include "SDL_audio.h"
%}

%include tcl3dDefines.i

// SDL specific macros.
#define DECLSPEC
#define SDLCALL
#define __declspec(dllimport)
#define __declspec(dllexport)
#define __cdecl

%complexTypeVector (SDL_CDtrack,Track)

%ignore SDL_AudioCVT;

%include "SDL.h"
%include "SDL_active.h"
%include "SDL_types.h"
%include "SDL_getenv.h"
%include "SDL_error.h"
%include "SDL_byteorder.h"
%include "SDL_timer.h"
%include "SDL_loadso.h"
%include "SDL_thread.h"
%include "SDL_timer.h"
%include "SDL_cdrom.h"
%include "SDL_joystick.h"
%include "SDL_mouse.h"
%include "SDL_events.h"
%include "SDL_video.h"
%include "SDL_version.h"
%include "SDL_audio.h"
