/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.ResponseBody;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.api.model.metrics.EndpointListResult;
import org.rundeck.client.api.model.metrics.HealthCheckStatus;
import org.rundeck.client.api.model.metrics.MetricsData;
import org.rundeck.client.api.model.sysinfo.Link;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.options.VerboseOption;
import picocli.CommandLine;

@CommandLine.Command(description={"View metrics endpoints information."}, name="metrics")
public class Metrics
extends BaseCommand {
    @CommandLine.Command(description={"Print system information and stats."})
    public void list(@CommandLine.Mixin VerboseOption options) throws IOException, InputError {
        EndpointListResult endpointList = (EndpointListResult)this.apiCall(RundeckApi::listMetricsEndpoints);
        if (endpointList.size() > 0) {
            this.getRdOutput().info(endpointList.size() + " metric endpoints:");
            this.getRdOutput().output(endpointList.getEndpointLinks().entrySet().stream().map(metricEntry -> (String)metricEntry.getKey() + (options.isVerbose() ? " " + ((Link)metricEntry.getValue()).getHref() : "")).collect(Collectors.joining("\n", "", "\n")));
        } else {
            this.getRdOutput().warning("No metrics endpoints found.");
        }
    }

    @CommandLine.Command(description={"Print health check status information."})
    public int healthcheck(@CommandLine.Mixin HealthCheckOptions options) throws IOException, InputError {
        Map statusList;
        Map healthCheckStatus = (Map)this.apiCall(RundeckApi::getHealthCheckMetrics);
        Map unhealthyList = healthCheckStatus.entrySet().stream().filter(entry -> !((HealthCheckStatus)entry.getValue()).isHealthy()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map map = statusList = options.isUnhealthyOnly() ? unhealthyList : healthCheckStatus;
        if (statusList.size() > 0) {
            this.getRdOutput().info("Showing current health status for " + statusList.size() + " checks:");
            this.getRdOutput().output(statusList.entrySet().stream().map(healthCheckEntry -> String.format("%-11s %s%s", ((HealthCheckStatus)healthCheckEntry.getValue()).isHealthy() ? "HEALTHY" : "NOT-HEALTHY", healthCheckEntry.getKey(), ((HealthCheckStatus)healthCheckEntry.getValue()).getMessage() != null ? " -- " + ((HealthCheckStatus)healthCheckEntry.getValue()).getMessage() : "")).collect(Collectors.joining("\n", "", "")));
        } else {
            this.getRdOutput().warning("No results found.");
        }
        return !options.isFailOnUnhealthy() || unhealthyList.size() == 0 ? 0 : 1;
    }

    @CommandLine.Command(description={"Print system threads status information."})
    public void threads(@CommandLine.Mixin VerboseOption options) throws IOException, InputError {
        try (ResponseBody response = (ResponseBody)this.apiCall(RundeckApi::getThreadMetrics);){
            this.getRdOutput().info("System threads status: ");
            if (options.isVerbose()) {
                this.getRdOutput().output(response.string());
            } else {
                this.getRdOutput().output(Stream.of(response.string().split("\n")).filter(s -> s.matches("^\\S+.*")).collect(Collectors.joining("\n")));
            }
        }
    }

    @CommandLine.Command(description={"Returns a simple response."})
    public void ping() throws IOException, InputError {
        this.getRdOutput().info(this.printTimestamp() + "Pinging server...");
        try (ResponseBody response = (ResponseBody)this.apiCall(RundeckApi::getPing);){
            this.getRdOutput().info(this.printTimestamp() + response.string());
        }
    }

    private String printTimestamp() {
        return "[" + LocalDateTime.now() + "] ";
    }

    @CommandLine.Command(description={"Prints the metrics data."})
    public void data(@CommandLine.Mixin MetricsDataOptions options) throws IOException, InputError {
        boolean printAll;
        MetricsData metricsData = (MetricsData)this.apiCall(RundeckApi::getMetricsData);
        this.getRdOutput().info("Displaying system metric data:");
        this.getRdOutput().info("Version: " + metricsData.getVersion());
        boolean bl = printAll = options.isAll() || !options.isGauge() && !options.isCounter() && !options.isHistograms() && !options.isMeters() && !options.isTimers();
        if (printAll || options.isGauge()) {
            this.getRdOutput().info("Found " + metricsData.getGauges().size() + " gauge metrics.");
            if (!options.isSummary()) {
                this.getRdOutput().output(Metrics.printMetricMap(metricsData.getGauges()));
            }
        }
        if (printAll || options.isCounter()) {
            this.getRdOutput().info("Found " + metricsData.getCounters().size() + " counter metrics.");
            if (!options.isSummary()) {
                this.getRdOutput().output(Metrics.printMetricMap(metricsData.getCounters()));
            }
        }
        if (printAll || options.isHistograms()) {
            this.getRdOutput().info("Found " + metricsData.getHistograms().size() + " histogram metrics.");
            if (!options.isSummary()) {
                this.getRdOutput().output(Metrics.printMetricMap(metricsData.getHistograms()));
            }
        }
        if (printAll || options.isMeters()) {
            this.getRdOutput().info("Found " + metricsData.getMeters().size() + " meter metrics.");
            if (!options.isSummary()) {
                this.getRdOutput().output(Metrics.printMetricMap(metricsData.getMeters()));
            }
        }
        if (printAll || options.isTimers()) {
            this.getRdOutput().info("Found " + metricsData.getTimers().size() + " timer metrics.");
            if (!options.isSummary()) {
                this.getRdOutput().output(Metrics.printMetricMap(metricsData.getTimers()));
            }
        }
    }

    private static String printMetricMap(Map<String, Map<String, Object>> metricMap) {
        return metricMap.entrySet().stream().map(metricEntry -> ((Map)metricEntry.getValue()).entrySet().stream().map(metricValues -> String.format("- %s: %s", metricValues.getKey(), metricValues.getValue())).collect(Collectors.joining("\n", (String)metricEntry.getKey() + ":\n", "\n"))).collect(Collectors.joining("\n"));
    }

    static class MetricsDataOptions {
        @CommandLine.Option(names={"-s", "--summary"}, description={"Show only a summary of metric data selected."})
        boolean summary;
        @CommandLine.Option(names={"-a", "--all"}, description={"Show all metrics available, which is the default. This option supersedes all other selection options."})
        boolean all;
        @CommandLine.Option(names={"-g", "--gauges"}, description={"Show all gauge metrics available."})
        boolean gauge;
        @CommandLine.Option(names={"-c", "--counters"}, description={"Show all counter metrics available."})
        boolean counter;
        @CommandLine.Option(names={"-h", "--histograms"}, description={"Show all histogram metrics available."})
        boolean histograms;
        @CommandLine.Option(names={"-m", "--meters"}, description={"Show all meter metrics available."})
        boolean meters;
        @CommandLine.Option(names={"-t", "--timers"}, description={"Show all timer metrics available."})
        boolean timers;

        MetricsDataOptions() {
        }

        public boolean isSummary() {
            return this.summary;
        }

        public boolean isAll() {
            return this.all;
        }

        public boolean isGauge() {
            return this.gauge;
        }

        public boolean isCounter() {
            return this.counter;
        }

        public boolean isHistograms() {
            return this.histograms;
        }

        public boolean isMeters() {
            return this.meters;
        }

        public boolean isTimers() {
            return this.timers;
        }

        public void setSummary(boolean summary) {
            this.summary = summary;
        }

        public void setAll(boolean all) {
            this.all = all;
        }

        public void setGauge(boolean gauge) {
            this.gauge = gauge;
        }

        public void setCounter(boolean counter) {
            this.counter = counter;
        }

        public void setHistograms(boolean histograms) {
            this.histograms = histograms;
        }

        public void setMeters(boolean meters) {
            this.meters = meters;
        }

        public void setTimers(boolean timers) {
            this.timers = timers;
        }
    }

    static class HealthCheckOptions {
        @CommandLine.Option(names={"-u", "--unhealthy"}, description={"Show only checks with unhealthy status."})
        boolean unhealthyOnly;
        @CommandLine.Option(names={"-f", "--fail"}, description={"Exit with unsuccessful status if unhealthy checks are found."})
        boolean failOnUnhealthy;

        HealthCheckOptions() {
        }

        public boolean isUnhealthyOnly() {
            return this.unhealthyOnly;
        }

        public boolean isFailOnUnhealthy() {
            return this.failOnUnhealthy;
        }

        public void setUnhealthyOnly(boolean unhealthyOnly) {
            this.unhealthyOnly = unhealthyOnly;
        }

        public void setFailOnUnhealthy(boolean failOnUnhealthy) {
            this.failOnUnhealthy = failOnUnhealthy;
        }
    }
}

